/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.hierarchy.FakeType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.koneki.ldt.core.LuaUtils;
import org.eclipse.koneki.ldt.core.internal.LuaLanguageToolkit;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTModelUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.FunctionTypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Item;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.LuaFileAPI;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Parameter;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.RecordTypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.TypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.TypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaASTNode;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.core.internal.ast.models.dltk.FakeField;
import org.eclipse.koneki.ldt.core.internal.ast.models.dltk.FakeMethod;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Block;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Identifier;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Index;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Invoke;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaExpression;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaInternalContent;
import org.eclipse.koneki.ldt.ui.internal.Activator;
import org.eclipse.koneki.ldt.ui.internal.editor.LuaBuildManager;
import org.eclipse.koneki.ldt.ui.internal.editor.completion.Messages;
import org.eclipse.koneki.ldt.ui.internal.editor.text.LuaHeuristicScanner;
import org.eclipse.koneki.ldt.ui.internal.editor.text.LuaSymbols;

public class LuaCompletionEngine
extends ScriptCompletionEngine {
    private int hasCompletionCount;
    private Map<String, CompletionProposal> proposalMap = new HashMap<String, CompletionProposal>();
    private final String SELF = "self";
    private static final String OVERLOAD = "@overload";
    private static final String PARAM_COUNT_SEP = "-paramCount:";

    public void complete(IModuleSource module, int position, int k) {
        Invoke invoke;
        boolean isInsideSelf;
        this.proposalMap.clear();
        this.hasCompletionCount = 0;
        IProject project = module.getModelElement().getScriptProject().getProject();
        if (LuaBuildManager.isBuild(project)) {
            this.createInfoProposal("building project, please waiting...");
            return;
        }
        IModelElement modelElement = module.getModelElement();
        if (!(modelElement instanceof ISourceModule)) {
            return;
        }
        ISourceModule sourceModule = (ISourceModule)modelElement;
        String sourceContent = module.getSourceContents();
        if (position <= 0 || Character.isWhitespace(sourceContent.charAt(position - 1))) {
            this.addLocalDeclarations(sourceModule, "", position);
            this.addAllGlobalDeclarations(sourceModule, "", position);
            this.addKeywords("", position);
            return;
        }
        Document document = new Document(sourceContent);
        LuaHeuristicScanner luaHeuristicScanner = new LuaHeuristicScanner((IDocument)document);
        int previousToken = luaHeuristicScanner.previousToken(position - 1, -2);
        if (LuaSymbols.isKeywords(previousToken)) {
            try {
                int start = Math.max(luaHeuristicScanner.getPosition(), 0);
                int end = position;
                String keyword = document.get(start, end - start).trim();
                this.addLocalDeclarations(sourceModule, keyword, position);
                this.addAllGlobalDeclarations(sourceModule, keyword, position);
                this.addKeywords(keyword, position);
            }
            catch (BadLocationException e) {
                Activator.logWarning("LuaCompletionEngine : Unable to extract keyword. ", e);
            }
            return;
        }
        LuaExpression luaExpression = luaHeuristicScanner.guessLuaExpression(position);
        this.requestor.beginReporting();
        if (luaExpression == null) {
            this.addLocalDeclarations(sourceModule, "", position);
            this.addAllGlobalDeclarations(sourceModule, "", position);
            this.addKeywords("", position);
        } else if (luaExpression instanceof Identifier) {
            Item definition = ((Identifier)luaExpression).getDefinition();
            String start = definition.getName();
            this.addLocalDeclarations(sourceModule, start, position);
            this.addAllGlobalDeclarations(sourceModule, start, position);
            this.addKeywords(start, position);
        } else if (luaExpression instanceof Index) {
            Index index = (Index)luaExpression;
            boolean isInsideSelf2 = this.findSelfDeclarations(sourceModule, (LuaExpression)index, position);
            if (!isInsideSelf2) {
                LuaExpression left = index.getLeft();
                String right = index.getRight();
                List resolveTypes = LuaASTUtils.resolveTypes((ISourceModule)sourceModule, (LuaExpression)left);
                int i = 0;
                while (i < resolveTypes.size()) {
                    LuaASTUtils.TypeResolution resolveType = (LuaASTUtils.TypeResolution)resolveTypes.get(i);
                    this.addFields(resolveType, right, position);
                    ++i;
                }
            }
        } else if (luaExpression instanceof Invoke && !(isInsideSelf = this.findSelfDeclarations(sourceModule, (LuaExpression)(invoke = (Invoke)luaExpression), position))) {
            LuaExpression record = ((Invoke)luaExpression).getRecord();
            String right = ((Invoke)luaExpression).getFunctionName();
            List resolveTypes = LuaASTUtils.resolveTypes((ISourceModule)sourceModule, (LuaExpression)record);
            int i = 0;
            while (i < resolveTypes.size()) {
                LuaASTUtils.TypeResolution resolveType = (LuaASTUtils.TypeResolution)resolveTypes.get(i);
                if (luaExpression.isIncomplete()) {
                    this.addInvocableFields(resolveType, right, position);
                }
                ++i;
            }
        }
        this.setProposalsToRequestor();
        this.requestor.endReporting();
    }

    private boolean findSelfDeclarations(ISourceModule sourceModule, LuaExpression expression, int position) {
        block13: {
            block12: {
                Item item;
                String name;
                if (!(expression instanceof Index)) break block12;
                Index index = (Index)expression;
                LuaExpression left = index.getLeft();
                String right = index.getRight();
                if (!(left instanceof Identifier) || !"self".equals(name = (item = ((Identifier)left).getDefinition()).getName())) break block13;
                LuaSourceRoot root = LuaASTModelUtils.getLuaSourceRoot((ISourceModule)sourceModule);
                LuaInternalContent luaInternalContent = root.getInternalContent();
                Block contentBlock = luaInternalContent.getContent();
                List list = contentBlock.getContent();
                int i = 0;
                while (i < list.size()) {
                    LuaASTNode luaASTNode = (LuaASTNode)list.get(i);
                    if (luaASTNode instanceof Block) {
                        LuaASTNode lastNode;
                        Block block = (Block)luaASTNode;
                        int start = block.start();
                        int end = block.end();
                        if (position > start && position < end && i > 0 && (lastNode = (LuaASTNode)list.get(i - 1)) instanceof Index) {
                            Index functionIndex = (Index)lastNode;
                            LuaExpression functionLeft = functionIndex.getLeft();
                            String functionRight = functionIndex.getRight();
                            if (!functionRight.isEmpty()) {
                                if (functionLeft instanceof Identifier) {
                                    Item objectItem = ((Identifier)functionLeft).getDefinition();
                                    String objectName = objectItem.getName();
                                    Document document = new Document(objectName);
                                    LuaHeuristicScanner luaHeuristicScanner = new LuaHeuristicScanner((IDocument)document);
                                    LuaExpression luaExpression = luaHeuristicScanner.guessLuaExpression(objectName.length());
                                    List resolveTypes = LuaASTUtils.resolveTypes((ISourceModule)sourceModule, (LuaExpression)luaExpression);
                                    int j = 0;
                                    while (j < resolveTypes.size()) {
                                        LuaASTUtils.TypeResolution resolveType = (LuaASTUtils.TypeResolution)resolveTypes.get(j);
                                        this.addFields(resolveType, right, position);
                                        ++j;
                                    }
                                } else if (functionLeft instanceof Index) {
                                    List resolveTypes = LuaASTUtils.resolveTypes((ISourceModule)sourceModule, (LuaExpression)functionLeft);
                                    int j = 0;
                                    while (j < resolveTypes.size()) {
                                        LuaASTUtils.TypeResolution resolveType = (LuaASTUtils.TypeResolution)resolveTypes.get(j);
                                        this.addFields(resolveType, right, position);
                                        ++j;
                                    }
                                }
                            }
                        }
                    }
                    ++i;
                }
                break block13;
            }
            if (expression instanceof Invoke) {
                String selfObjectName;
                Identifier identifier;
                Item item;
                String name;
                Invoke invoke = (Invoke)expression;
                String functionName = invoke.getFunctionName();
                LuaExpression luaExpression = invoke.getRecord();
                if (luaExpression instanceof Identifier && "self".equals(name = (item = (identifier = (Identifier)luaExpression).getDefinition()).getName()) && (selfObjectName = this.getSelfObjectName(sourceModule, position)) != null) {
                    Document document = new Document(selfObjectName);
                    LuaHeuristicScanner luaHeuristicScanner = new LuaHeuristicScanner((IDocument)document);
                    LuaExpression luaSelfObjectExpression = luaHeuristicScanner.guessLuaExpression(selfObjectName.length());
                    List resolveTypes = LuaASTUtils.resolveTypes((ISourceModule)sourceModule, (LuaExpression)luaSelfObjectExpression);
                    int j = 0;
                    while (j < resolveTypes.size()) {
                        LuaASTUtils.TypeResolution resolveType = (LuaASTUtils.TypeResolution)resolveTypes.get(j);
                        this.addInvocableFields(resolveType, functionName, position);
                        ++j;
                    }
                }
            }
        }
        return false;
    }

    private String getSelfObjectName(ISourceModule sourceModule, int position) {
        LuaSourceRoot root = LuaASTModelUtils.getLuaSourceRoot((ISourceModule)sourceModule);
        LuaInternalContent luaInternalContent = root.getInternalContent();
        Block contentBlock = luaInternalContent.getContent();
        List list = contentBlock.getContent();
        int i = 0;
        while (i < list.size()) {
            LuaASTNode luaASTNode = (LuaASTNode)list.get(i);
            if (luaASTNode instanceof Block) {
                LuaASTNode lastNode;
                Block block = (Block)luaASTNode;
                int start = block.start();
                int end = block.end();
                if (position > start && position < end && i > 0 && (lastNode = (LuaASTNode)list.get(i - 1)) instanceof Index) {
                    Index functionIndex = (Index)lastNode;
                    LuaExpression functionLeft = functionIndex.getLeft();
                    String functionRight = functionIndex.getRight();
                    if (!functionRight.isEmpty() && functionLeft instanceof Identifier) {
                        Item objectItem = ((Identifier)functionLeft).getDefinition();
                        String objectName = objectItem.getName();
                        return objectName;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private void addGlobalDeclarations(ISourceModule sourceModule, String start, int cursorPosition) {
        ArrayList globalvars = new ArrayList();
        ISourceModule preloadedSourceModule = LuaASTUtils.getPreloadSourceModule((ISourceModule)sourceModule);
        if (preloadedSourceModule != null) {
            globalvars.addAll(LuaASTUtils.getAllInternalGlobalVarsDefinition((ISourceModule)preloadedSourceModule, (String)start));
        }
        for (LuaASTUtils.Definition definition : globalvars) {
            IMember member = LuaASTModelUtils.getIMember((ISourceModule)definition.getModule(), (Item)definition.getItem());
            if (member == null) continue;
            this.createMemberProposal(member, cursorPosition - start.length(), cursorPosition);
        }
        if (Platform.getPreferencesService().getBoolean(LuaLanguageToolkit.getDefault().getPreferenceQualifier(), "USE_GLOBAL_VAR_IN_LDT", true, null)) {
            List othersglobalvars = LuaASTUtils.getAllInternalGlobalVarsDefinition((ISourceModule)sourceModule, (String)start);
            othersglobalvars.addAll(LuaASTUtils.getAllExternalGlobalVarsDefinition((ISourceModule)sourceModule, (String)start));
            for (LuaASTUtils.Definition definition : othersglobalvars) {
                IMember member = LuaASTModelUtils.getIMember((ISourceModule)definition.getModule(), (Item)definition.getItem());
                if (member == null) continue;
                this.createMemberProposal(member, cursorPosition - start.length(), cursorPosition, false, 25);
            }
        }
    }

    private void addAllGlobalDeclarations(ISourceModule sourceModule, String start, int cursorPosition) {
        HashSet<String> allGlobalvarNames = new HashSet<String>();
        ArrayList globalvars = new ArrayList();
        List preloadedSourceModules = LuaASTUtils.getAllPreloadSourceModule((ISourceModule)sourceModule);
        if (preloadedSourceModules != null) {
            int i = 0;
            while (i < preloadedSourceModules.size()) {
                ISourceModule preloadedSourceModule = (ISourceModule)preloadedSourceModules.get(i);
                globalvars.addAll(LuaASTUtils.getAllInternalGlobalVarsDefinition((ISourceModule)preloadedSourceModule, (String)start));
                ++i;
            }
        }
        for (LuaASTUtils.Definition definition : globalvars) {
            IMember member = LuaASTModelUtils.getIMember((ISourceModule)definition.getModule(), (Item)definition.getItem());
            if (member == null) continue;
            this.createMemberProposal(member, cursorPosition - start.length(), cursorPosition);
            allGlobalvarNames.add(member.getElementName());
        }
        if (Platform.getPreferencesService().getBoolean(LuaLanguageToolkit.getDefault().getPreferenceQualifier(), "USE_GLOBAL_VAR_IN_LDT", true, null)) {
            List othersglobalvars = LuaASTUtils.getAllInternalGlobalVarsDefinition((ISourceModule)sourceModule, (String)start);
            othersglobalvars.addAll(LuaASTUtils.getAllExternalGlobalVarsDefinition((ISourceModule)sourceModule, (String)start));
            for (LuaASTUtils.Definition definition : othersglobalvars) {
                IMember member = LuaASTModelUtils.getIMember((ISourceModule)definition.getModule(), (Item)definition.getItem());
                if (member == null) continue;
                this.createMemberProposal(member, cursorPosition - start.length(), cursorPosition, false, 25);
                String name = member.getElementName();
                if (name == null) continue;
                allGlobalvarNames.add(member.getElementName());
            }
        }
        List resolveTypes = LuaASTUtils.getExternalPreloadedTypeResolutionByStart((ISourceModule)sourceModule, (String)start);
        int i = 0;
        while (i < resolveTypes.size()) {
            RecordTypeDef recordTypeDef;
            String name;
            LuaASTUtils.TypeResolution resolveType = (LuaASTUtils.TypeResolution)resolveTypes.get(i);
            TypeDef typeDef = resolveType.getTypeDef();
            if (typeDef instanceof RecordTypeDef && !allGlobalvarNames.contains(name = (recordTypeDef = (RecordTypeDef)typeDef).getName())) {
                this.createTypeResolution(resolveType, cursorPosition - start.length(), cursorPosition);
            }
            ++i;
        }
    }

    private void addKeywords(String start, int cursorPosition) {
        String[] keywords = new String[]{"and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while"};
        int j = 0;
        while (j < keywords.length) {
            if (!(keywords[j].equals(start) && this.hasCompletionCount <= 0 || !start.isEmpty() && !keywords[j].startsWith(start))) {
                this.createKeyWordProposal(keywords[j], cursorPosition - start.length(), cursorPosition);
            }
            ++j;
        }
    }

    private void addLocalDeclarations(ISourceModule sourceModule, String start, int cursorPosition) {
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot((ISourceModule)sourceModule);
        if (luaSourceRoot == null) {
            return;
        }
        Collection localVars = LuaASTUtils.getLocalVars((LuaSourceRoot)luaSourceRoot, (int)(cursorPosition - start.length()), (String)start);
        for (Item var : localVars) {
            IMember member = LuaASTModelUtils.getIMember((ISourceModule)sourceModule, (Item)var);
            if (member == null) continue;
            this.createMemberProposal(member, cursorPosition - start.length(), cursorPosition);
        }
    }

    private void addFields(LuaASTUtils.TypeResolution recordTypeResolution, String fieldName, int position) {
        if (recordTypeResolution == null) {
            return;
        }
        if (recordTypeResolution.getTypeDef() instanceof RecordTypeDef) {
            RecordTypeDef currentRecordTypeDef = (RecordTypeDef)recordTypeResolution.getTypeDef();
            ISourceModule currentSourceModule = recordTypeResolution.getModule();
            for (Map.Entry entry : currentRecordTypeDef.getFields().entrySet()) {
                IMember member;
                Item item = (Item)entry.getValue();
                boolean goodStart = item.getName().toLowerCase().startsWith(fieldName.toLowerCase());
                boolean nostart = fieldName.isEmpty();
                if (!goodStart && !nostart || (member = LuaASTModelUtils.getIMember((ISourceModule)currentSourceModule, (Item)item)) == null) continue;
                this.createMemberProposal(member, position - fieldName.length(), position, false);
            }
            this.createExtendProposal(currentSourceModule, fieldName, position, false);
        }
    }

    private List<String> getExtendObjectNames(ISourceModule module) {
        ArrayList<String> extendObjectNames = new ArrayList<String>();
        try {
            String source = module.getSource();
            Pattern pattern = Pattern.compile("--(\\s)*@extend(.|\\t|\\x0B|\\f|\\r)*\\n");
            Matcher mathcer = pattern.matcher(source);
            boolean result = mathcer.find();
            if (result) {
                String group = mathcer.group();
                int extendIndex = group.indexOf("@extend");
                String extendObjects = group.substring(extendIndex + 7);
                String[] extendArray = extendObjects.split(",");
                int i = 0;
                while (i < extendArray.length) {
                    extendObjectNames.add(extendArray[i].trim());
                    ++i;
                }
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return extendObjectNames;
    }

    private void addInvocableFields(LuaASTUtils.TypeResolution recordTypeResolution, String fieldName, int position) {
        if (recordTypeResolution == null) {
            return;
        }
        if (recordTypeResolution.getTypeDef() instanceof RecordTypeDef) {
            RecordTypeDef currentRecordTypeDef = (RecordTypeDef)recordTypeResolution.getTypeDef();
            ISourceModule currentSourceModule = recordTypeResolution.getModule();
            for (Map.Entry entry : currentRecordTypeDef.getFields().entrySet()) {
                LuaASTUtils.TypeResolution parameterTypeResolution;
                List parameters;
                LuaASTUtils.TypeResolution fieldTypeResolution;
                Item item = (Item)entry.getValue();
                boolean goodStart = item.getName().toLowerCase().startsWith(fieldName.toLowerCase());
                boolean nostart = fieldName.isEmpty();
                if (!goodStart && !nostart || (fieldTypeResolution = LuaASTUtils.resolveType((ISourceModule)currentSourceModule, (TypeRef)item.getType())) == null || !(fieldTypeResolution.getTypeDef() instanceof FunctionTypeDef) || (parameters = ((FunctionTypeDef)fieldTypeResolution.getTypeDef()).getParameters()).size() == 0) continue;
                Parameter firstParamter = (Parameter)parameters.get(0);
                if ("self".equals(firstParamter.getName()) && firstParamter.getType() == null) {
                    this.createMemberProposal(LuaASTModelUtils.getIMember((ISourceModule)currentSourceModule, (Item)item), position - fieldName.length(), position, true);
                }
                if (!recordTypeResolution.equals((Object)(parameterTypeResolution = LuaASTUtils.resolveType((ISourceModule)currentSourceModule, (TypeRef)firstParamter.getType())))) continue;
                this.createMemberProposal(LuaASTModelUtils.getIMember((ISourceModule)currentSourceModule, (Item)item), position - fieldName.length(), position, true);
            }
            this.createExtendProposal(currentSourceModule, fieldName, position, true);
        }
    }

    private void createExtendProposal(ISourceModule currentSourceModule, String fieldName, int position, boolean invocation) {
        List<String> extendObjectNames = this.getExtendObjectNames(currentSourceModule);
        for (String extendObjectName : extendObjectNames) {
            ISourceModule externalSourceModule = LuaUtils.getSourceModule((String)extendObjectName, (IScriptProject)currentSourceModule.getScriptProject());
            if (externalSourceModule == null) continue;
            this.createExtendProposal(externalSourceModule, fieldName, position, invocation);
            LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot((ISourceModule)externalSourceModule);
            TypeDef extendTypeDef = (TypeDef)luaSourceRoot.getFileapi().getTypes().get(extendObjectName);
            if (extendTypeDef == null) continue;
            LuaASTUtils.TypeResolution extendTypeResolution = new LuaASTUtils.TypeResolution(externalSourceModule, extendTypeDef);
            if (!(extendTypeDef instanceof RecordTypeDef)) continue;
            RecordTypeDef extendRecordTypeDef = (RecordTypeDef)extendTypeDef;
            ISourceModule extendSourceModule = extendTypeResolution.getModule();
            for (Map.Entry entry : extendRecordTypeDef.getFields().entrySet()) {
                Item item = (Item)entry.getValue();
                IMember member = LuaASTModelUtils.getIMember((ISourceModule)extendSourceModule, (Item)item);
                boolean goodStart = item.getName().toLowerCase().startsWith(fieldName.toLowerCase());
                boolean nostart = fieldName.isEmpty();
                if (!goodStart && !nostart) continue;
                this.createMemberProposal(member, position - fieldName.length(), position, invocation);
            }
        }
    }

    private void createMethodReturnTypeProposal(ISourceModule currentSourceModule, String fieldName, int position) {
        LuaASTUtils.Definition definition = LuaASTUtils.getInternalGlobalVarDefinition((ISourceModule)currentSourceModule, (String)fieldName);
        if (definition != null) {
            List list = definition.getItem().getChilds();
            int i = 0;
            while (i < list.size()) {
                ASTNode astNode = (ASTNode)list.get(i);
                if (astNode instanceof RecordTypeDef) {
                    for (Map.Entry entry : ((RecordTypeDef)astNode).getFields().entrySet()) {
                        Item item = (Item)entry.getValue();
                        IMember member = LuaASTModelUtils.getIMember((ISourceModule)currentSourceModule, (Item)item);
                        this.createMemberProposal(member, position, position + fieldName.length(), false);
                    }
                }
                ++i;
            }
        }
    }

    private void createInfoProposal(String info) {
    }

    private void createKeyWordProposal(String keyword, int startIndex, int endIndex) {
        CompletionProposal proposal = CompletionProposal.create((int)2, (int)0);
        proposal.setRelevance(100);
        proposal.setName(keyword);
        proposal.setCompletion(keyword);
        proposal.setReplaceRange(startIndex, endIndex);
        this.addProposal(proposal, keyword);
        ++this.hasCompletionCount;
    }

    private void createTypeResolution(LuaASTUtils.TypeResolution typeResolution, int startIndex, int endIndex) {
        CompletionProposal proposal = CompletionProposal.create((int)7, (int)0);
        ISourceModule sourceModule = typeResolution.getModule();
        TypeDef typeDef = typeResolution.getTypeDef();
        if (typeDef instanceof RecordTypeDef) {
            RecordTypeDef recordTypeDef = (RecordTypeDef)typeDef;
            String name = recordTypeDef.getName();
            proposal.setName(name);
            proposal.setModelElement((IModelElement)sourceModule);
            proposal.setCompletion(name);
            proposal.setReplaceRange(startIndex, endIndex);
            proposal.setRelevance(1);
            this.addProposal(proposal, name);
            ++this.hasCompletionCount;
        }
    }

    private void createMemberProposal(IMember member, int startIndex, int endIndex) {
        this.createMemberProposal(member, startIndex, endIndex, false);
    }

    private void createMemberProposal(IMember member, int startIndex, int endIndex, boolean invocation) {
        this.createMemberProposal(member, startIndex, endIndex, invocation, 50);
    }

    private void createMemberProposal(IMember member, int startIndex, int endIndex, boolean invocation, int relevance) {
        try {
            CompletionProposal proposal = null;
            if (member == null) {
                NullPointerException e = new NullPointerException("the given IMember is null");
                Activator.logWarning("Unable to perform completion", e);
                return;
            }
            switch (member.getElementType()) {
                case 9: {
                    proposal = CompletionProposal.create((int)5, (int)0);
                    IMethod method = (IMethod)member;
                    String methodSource = method.getSource();
                    List<List<String>> list = LuaCompletionEngine.getOverloadNames(methodSource);
                    if (list.size() > 0) {
                        int i = 0;
                        while (i < list.size()) {
                            List<String> params = list.get(i);
                            String[] paramStrs = new String[params.size()];
                            this.createOverloadMethodProposal(member, params.toArray(paramStrs), startIndex, endIndex, invocation, relevance);
                            ++i;
                        }
                        return;
                    }
                    if (invocation) {
                        String[] parameterNames = method.getParameterNames();
                        if (parameterNames.length == 0) {
                            return;
                        }
                        String[] parameterNamesWithoutFirstOne = Arrays.copyOfRange(parameterNames, 1, parameterNames.length);
                        proposal.setParameterNames(parameterNamesWithoutFirstOne);
                        break;
                    }
                    proposal.setParameterNames(method.getParameterNames());
                    break;
                }
                case 8: {
                    proposal = CompletionProposal.create((int)1, (int)0);
                    break;
                }
                case 7: {
                    proposal = CompletionProposal.create((int)7, (int)0);
                    break;
                }
                default: {
                    return;
                }
            }
            String displayName = member.getElementName();
            List<String> parentNames = this.getParentNames(member);
            if (parentNames.size() > 0) {
                displayName = String.valueOf(displayName) + " - ";
            }
            int i = parentNames.size() - 1;
            while (i >= 0) {
                displayName = String.valueOf(displayName) + parentNames.get(i);
                if (i != 0) {
                    displayName = String.valueOf(displayName) + ".";
                }
                --i;
            }
            proposal.setName(displayName);
            proposal.setFlags(member.getFlags());
            proposal.setModelElement((IModelElement)member);
            proposal.setCompletion(member.getElementName());
            proposal.setReplaceRange(startIndex, endIndex);
            proposal.setRelevance(relevance);
            this.addProposal(proposal, String.valueOf(displayName) + PARAM_COUNT_SEP + parentNames.size());
            ++this.hasCompletionCount;
        }
        catch (ModelException e) {
            Activator.logWarning(Messages.LuaCompletionEngineProblemProcessingGlobals, e);
            return;
        }
    }

    private void createOverloadMethodProposal(IMember member, String[] parameterNames, int startIndex, int endIndex, boolean invocation, int relevance) {
        try {
            CompletionProposal proposal = CompletionProposal.create((int)5, (int)0);
            if (invocation) {
                if (parameterNames.length == 0) {
                    return;
                }
                String[] parameterNamesWithoutFirstOne = Arrays.copyOfRange(parameterNames, 1, parameterNames.length);
                proposal.setParameterNames(parameterNamesWithoutFirstOne);
            } else {
                proposal.setParameterNames(parameterNames);
            }
            String displayName = member.getElementName();
            List<String> parentNames = this.getParentNames(member);
            if (parentNames.size() > 0) {
                displayName = String.valueOf(displayName) + " - ";
            }
            int i = parentNames.size() - 1;
            while (i >= 0) {
                displayName = String.valueOf(displayName) + parentNames.get(i);
                if (i != 0) {
                    displayName = String.valueOf(displayName) + ".";
                }
                --i;
            }
            proposal.setName(displayName);
            proposal.setFlags(member.getFlags());
            proposal.setModelElement((IModelElement)member);
            proposal.setCompletion(member.getElementName());
            proposal.setReplaceRange(startIndex, endIndex);
            proposal.setRelevance(relevance);
            this.addProposal(proposal, String.valueOf(displayName) + PARAM_COUNT_SEP + parameterNames.length);
            ++this.hasCompletionCount;
        }
        catch (ModelException e) {
            Activator.logWarning(Messages.LuaCompletionEngineProblemProcessingGlobals, e);
            return;
        }
    }

    private void addProposal(CompletionProposal proposal, String key) {
        if (!this.proposalMap.containsKey(key)) {
            this.proposalMap.put(key, proposal);
        }
    }

    private void setProposalsToRequestor() {
        for (Map.Entry<String, CompletionProposal> entry : this.proposalMap.entrySet()) {
            CompletionProposal proposal = entry.getValue();
            this.requestor.accept(proposal);
            ++this.hasCompletionCount;
        }
    }

    private List<String> getParentNames(IMember member) {
        IModelElement modelElement;
        List<String> parentNames = new ArrayList<String>();
        if (member instanceof FakeField) {
            FakeField field = (FakeField)member;
            LuaASTNode node = field.getLuaASTNode();
            if (node instanceof Item) {
                Item item = (Item)node;
                parentNames = this.getParentNames(item.getParent());
            }
        } else if (!(member instanceof FakeMethod)) {
            boolean cfr_ignored_0 = member instanceof FakeType;
        }
        if ((modelElement = member.getParent()) instanceof IMember) {
            IMember parent = (IMember)modelElement;
            parentNames.addAll(this.getParentNames(parent));
        }
        return parentNames;
    }

    private List<String> getParentNames(LuaASTNode node) {
        ArrayList<String> parentNames = new ArrayList<String>();
        if (node instanceof Item) {
            Item item = (Item)node;
            parentNames.add(item.getName());
            parentNames.addAll(this.getParentNames(item.getParent()));
        } else if (node instanceof RecordTypeDef) {
            RecordTypeDef def = (RecordTypeDef)node;
            parentNames.addAll(this.getParentNames(def.getParent()));
        } else {
            boolean cfr_ignored_0 = node instanceof LuaFileAPI;
        }
        return parentNames;
    }

    private static List<List<String>> getOverloadNames(String source) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        Pattern pattern = Pattern.compile("--(\\s)*@overload(.|\\t|\\x0B|\\f|\\r)*\\n");
        Matcher mathcer = pattern.matcher(source);
        while (mathcer.find()) {
            String group = mathcer.group();
            int overloadIndex = group.indexOf(OVERLOAD);
            String overloadObjects = group.substring(overloadIndex + OVERLOAD.length());
            String[] overloadArray = overloadObjects.split(",");
            ArrayList<String> overloads = new ArrayList<String>();
            int i = 0;
            while (i < overloadArray.length) {
                overloads.add(overloadArray[i].trim());
                ++i;
            }
            if (overloads.size() <= 0) continue;
            list.add(overloads);
        }
        return list;
    }
}

