/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTUtils;
import org.eclipse.koneki.ldt.metalua.Activator;

public class LuaBuildManager {
    private static final String BUILD_LUA_PROJECT = "build lua project:";
    private static final String BUILD_START = "build start...";
    private static Map<String, Job> currentBuildProjects = Collections.synchronizedMap(new HashMap());
    public static boolean isBuilding;
    public static IProject buildProject;

    public static void buildProject(final ISourceModule sourceModule) {
        IScriptProject scriptProject = sourceModule.getScriptProject();
        final IProject project = scriptProject.getProject();
        final String projectName = scriptProject.getElementName();
        if (currentBuildProjects.containsKey(projectName)) {
            return;
        }
        Job job = new Job(BUILD_LUA_PROJECT + projectName){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(LuaBuildManager.BUILD_START, -1);
                isBuilding = true;
                buildProject = project;
                try {
                    try {
                        LuaASTUtils.getAllGlobalVarsDefinition((ISourceModule)sourceModule, (String)sourceModule.getElementName());
                    }
                    catch (Exception e) {
                        Activator.logError((String)e.getMessage(), (Throwable)e);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        currentBuildProjects.remove(projectName);
                        isBuilding = false;
                        buildProject = null;
                        return iStatus;
                    }
                }
                finally {
                    currentBuildProjects.remove(projectName);
                    isBuilding = false;
                    buildProject = null;
                }
                return Status.OK_STATUS;
            }
        };
        currentBuildProjects.put(projectName, job);
        job.setUser(false);
        job.setPriority(10);
        job.schedule();
    }

    public static boolean isBuild(IProject project) {
        return isBuilding && buildProject == project;
    }
}

