/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.metalua;

import com.naef.jnlua.LuaState;
import com.naef.jnlua.eclipse.AbstractLuaModule;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.koneki.ldt.metalua.Activator;
import org.eclipse.koneki.ldt.metalua.internal.MetaluaStateFactory;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractMetaLuaModule
extends AbstractLuaModule {
    private static final String METALUA_PATTERN = "?.mlua;";

    protected LuaState loadLuaModule() {
        this.compileMetaluaFiles();
        return super.loadLuaModule();
    }

    protected void definePaths(LuaState state) {
        super.definePaths(state);
        List metaluaSourceFolders = this.getScriptFolders(this.getMetaLuaSourcePaths());
        AbstractMetaLuaModule.setMetaluaPath(state, metaluaSourceFolders);
    }

    public void compileMetaluaFiles() {
        LuaState newLuaState = MetaluaStateFactory.newLuaState();
        List<String> metaLuaFileToCompile = this.getMetaLuaFileToCompile();
        for (String metaluaSourcePath : this.getMetaLuaSourcePaths()) {
            File metaluaSourceFile = this.getScriptFolder(metaluaSourcePath);
            if (metaLuaFileToCompile == null || metaluaSourcePath == null) continue;
            String filename = null;
            try {
                int k = 0;
                while (k < metaLuaFileToCompile.size()) {
                    filename = metaLuaFileToCompile.get(k);
                    AbstractMetaLuaModule.compileMetaluaFile(newLuaState, metaluaSourceFile, filename);
                    ++k;
                }
            }
            catch (IOException e) {
                if (filename != null) {
                    Activator.logWarning(NLS.bind((String)"Unable to compile {0}.", filename), e);
                } else {
                    Activator.logWarning("Unable to compile Metalua file.", e);
                }
                newLuaState.close();
            }
        }
        newLuaState.close();
    }

    public static void compileMetaluaFile(LuaState luastate, File folder, String fileName) throws IOException {
        File regular = new File(folder, fileName);
        if (regular.isFile() && regular.exists()) {
            String fileNameWithoutExtension = fileName.substring(0, fileName.lastIndexOf(46));
            File build = new File(folder, String.valueOf(fileNameWithoutExtension) + ".luac");
            StringBuffer command = new StringBuffer("require 'metalua.loader'\n");
            command.append("local mlc = require ('metalua.compiler').new()\n");
            command.append("local bin = mlc:srcfile_to_bytecode([[");
            command.append(regular.getPath());
            command.append("]])\n");
            command.append("local file = io.open([[");
            command.append(build.getPath());
            command.append("]], 'wb') file:write(bin) file:close()\n");
            luastate.load(command.toString(), "libraryCompilation");
            luastate.call(0, 0);
        }
    }

    protected List<String> getLuacSourcePaths() {
        return this.getMetaLuaSourcePaths();
    }

    protected LuaState createLuaState() {
        return MetaluaStateFactory.newLuaState();
    }

    protected abstract List<String> getMetaLuaSourcePaths();

    protected abstract List<String> getMetaLuaFileToCompile();

    public static void setMetaluaPath(LuaState luaState, List<File> metaluaFolders) {
        StringBuffer code = new StringBuffer("package.mpath=[[");
        for (File folder : metaluaFolders) {
            code.append(folder.getPath());
            code.append(File.separatorChar);
            code.append(METALUA_PATTERN);
        }
        code.append("]]..package.mpath");
        luaState.load(code.toString(), "reloadingMetaluaPath");
        luaState.call(0, 0);
        AbstractMetaLuaModule.setLuaPath((LuaState)luaState, Collections.emptyList(), metaluaFolders);
    }
}

