/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.settings;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public class CommentProperties {
    private int minimumLogMessageSize;
    private int logWidthMarker;
    private String logTemplate;
    private int minimumLockMessageSize;

    public String getLogTemplate() {
        return this.logTemplate;
    }

    public void setLogTemplate(String logTemplate) {
        this.logTemplate = logTemplate;
    }

    public int getLogWidthMarker() {
        return this.logWidthMarker;
    }

    public void setLogWidthMarker(int logWidthMarker) {
        this.logWidthMarker = logWidthMarker;
    }

    public int getMinimumLogMessageSize() {
        return this.minimumLogMessageSize;
    }

    public void setMinimumLogMessageSize(int minimumLogMessageSize) {
        this.minimumLogMessageSize = minimumLogMessageSize;
    }

    public int getMinimumLockMessageSize() {
        return this.minimumLockMessageSize;
    }

    public void setMinimumLockMessageSize(int minimumLockMessageSize) {
        this.minimumLockMessageSize = minimumLockMessageSize;
    }

    public static CommentProperties getCommentProperties(IResource resource) throws SVNException {
        CommentProperties properties = null;
        ISVNProperty sizeProperty = null;
        ISVNProperty lockSizeProperty = null;
        ISVNProperty widthProperty = null;
        ISVNProperty templateProperty = null;
        IResource parent = resource;
        while (parent != null) {
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)parent);
            if (svnResource.isManaged()) {
                if (properties == null) {
                    properties = new CommentProperties();
                }
                if (sizeProperty == null) {
                    sizeProperty = svnResource.getSvnProperty("tsvn:logminsize");
                }
                if (lockSizeProperty == null) {
                    lockSizeProperty = svnResource.getSvnProperty("tsvn:lockmsgminsize");
                }
                if (widthProperty == null) {
                    widthProperty = svnResource.getSvnProperty("tsvn:logwidthmarker");
                }
                if (templateProperty == null) {
                    templateProperty = svnResource.getSvnProperty("tsvn:logtemplate");
                }
            }
            if (parent instanceof IProject || sizeProperty != null && lockSizeProperty != null && widthProperty != null && templateProperty != null) break;
            parent = parent.getParent();
        }
        if (properties != null) {
            if (sizeProperty != null) {
                int minSize = 0;
                try {
                    minSize = Integer.parseInt(sizeProperty.getValue());
                }
                catch (Exception exception) {}
                properties.setMinimumLogMessageSize(minSize);
            }
            if (lockSizeProperty != null) {
                int minSize = 0;
                try {
                    minSize = Integer.parseInt(lockSizeProperty.getValue());
                }
                catch (Exception exception) {}
                properties.setMinimumLockMessageSize(minSize);
            }
            if (widthProperty != null) {
                int width = 0;
                try {
                    width = Integer.parseInt(widthProperty.getValue());
                }
                catch (Exception exception) {}
                properties.setLogWidthMarker(width);
            }
            if (templateProperty != null) {
                properties.setLogTemplate(templateProperty.getValue());
            }
        }
        return properties;
    }
}

