/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.UpdateResourcesCommand;
import org.tigris.subversion.subclipse.core.sync.SVNWorkspaceSubscriber;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.conflicts.SVNConflictResolver;
import org.tigris.subversion.subclipse.ui.operations.RepositoryProviderOperation;
import org.tigris.subversion.svnclientadapter.ISVNConflictResolver;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class UpdateOperation
extends RepositoryProviderOperation {
    private final SVNRevision revision;
    private int depth = 0;
    private boolean setDepth = false;
    private boolean ignoreExternals = false;
    private boolean force = true;
    private boolean canRunAsJob = true;
    private ISVNConflictResolver conflictResolver;

    public UpdateOperation(IWorkbenchPart part, IResource resource, SVNRevision revision) {
        super(part, new IResource[]{resource});
        this.revision = revision;
    }

    public UpdateOperation(IWorkbenchPart part, IResource[] resources, SVNRevision revision) {
        super(part, resources);
        this.revision = revision;
    }

    protected String getTaskName() {
        return Policy.bind("UpdateOperation.taskName");
    }

    protected String getTaskName(SVNTeamProvider provider) {
        return Policy.bind("UpdateOperation.0", provider.getProject().getName());
    }

    protected void execute(SVNTeamProvider provider, IResource[] resources, IProgressMonitor monitor) throws SVNException, InterruptedException {
        block8: {
            monitor.beginTask(null, 100);
            try {
                try {
                    if (this.conflictResolver != null && this.conflictResolver instanceof SVNConflictResolver) {
                        ((SVNConflictResolver)this.conflictResolver).setPart(this.getPart());
                    }
                    SVNWorkspaceSubscriber.getInstance().updateRemote(resources);
                    UpdateResourcesCommand command = new UpdateResourcesCommand(provider.getSVNWorkspaceRoot(), resources, this.revision);
                    command.setDepth(this.depth);
                    command.setSetDepth(this.setDepth);
                    command.setIgnoreExternals(this.ignoreExternals);
                    command.setForce(this.force);
                    command.setConflictResolver(this.conflictResolver);
                    command.run(Policy.subMonitorFor(monitor, 100));
                }
                catch (SVNException e) {
                    if (e.operationInterrupted()) {
                        this.showCancelledMessage();
                        break block8;
                    }
                    this.collectStatus(e.getStatus());
                }
                catch (TeamException e) {
                    this.collectStatus(e.getStatus());
                }
            }
            finally {
                SVNProviderPlugin.broadcastSyncInfoChanges((IResource[])resources, (boolean)false);
                monitor.done();
            }
        }
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setSetDepth(boolean setDepth) {
        this.setDepth = setDepth;
    }

    public void setIgnoreExternals(boolean ignoreExternals) {
        this.ignoreExternals = ignoreExternals;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setCanRunAsJob(boolean canRunAsJob) {
        this.canRunAsJob = canRunAsJob;
    }

    protected boolean canRunAsJob() {
        return this.canRunAsJob;
    }

    public void setConflictResolver(ISVNConflictResolver conflictResolver) {
        this.conflictResolver = conflictResolver;
    }

    protected ISchedulingRule getSchedulingRule(SVNTeamProvider provider) {
        ISchedulingRule schedulingRule = super.getSchedulingRule(provider);
        if (schedulingRule != null && this.conflictResolver != null) {
            ((SVNConflictResolver)this.conflictResolver).setSchedulingRule(schedulingRule);
        }
        return schedulingRule;
    }
}

