/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.conflicts;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.commands.GetRemoteResourceCommand;
import org.tigris.subversion.subclipse.core.resources.SVNTreeConflict;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.File2Resource;
import org.tigris.subversion.subclipse.ui.Messages;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.conflicts.ResolveTreeConflictWizard;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ResolveTreeConflictWizardMainPage
extends WizardPage {
    private Button mergeFromRepositoryButton;
    private Button compareButton;
    private Button revertButton;
    private Button deleteButton1;
    private Button deleteButton2;
    private Button markResolvedButton;
    private Button option1Button;
    private Button option2Button;
    private Button option3Button;
    private Group option1Group;
    private Group option2Group;
    private Text mergeTargetText;
    private Combo mergeTargetCombo;
    private Label compareLabel;
    private Combo revertCombo;
    private boolean markResolvedEnabled = true;
    private ISVNStatus copiedTo;
    private ISVNStatus remoteCopiedTo;
    private ISVNStatus[] adds;
    private IResource mergeTarget;
    private IResource theirs;
    private IResource mine;
    private IResource revertResource;
    private IResource deleteResource1;
    private IResource deleteResource2;
    private ISVNLocalResource svnCompareResource;
    private IResource compareResource1;
    private IResource compareResource2;
    private ISVNRemoteResource remoteResource;
    private String mergeFromUrl;
    private SVNTreeConflict treeConflict;

    public ResolveTreeConflictWizardMainPage() {
        super("main", Messages.ResolveTreeConflictWizardMainPage_specifySteps, SVNUIPlugin.getPlugin().getImageDescriptor("wizban/resolve_treeconflict_wizban.png"));
    }

    public void createControl(Composite parent) {
        SelectionAdapter choiceListener;
        GridLayout option1Layout;
        String name;
        ResolveTreeConflictWizard wizard = (ResolveTreeConflictWizard)this.getWizard();
        this.treeConflict = wizard.getTreeConflict();
        Composite outerContainer = new Composite(parent, 0);
        outerContainer.setLayout((Layout)new GridLayout());
        outerContainer.setLayoutData((Object)new GridData(768));
        Group detailsGroup = new Group(outerContainer, 0);
        detailsGroup.setText(Messages.ResolveTreeConflictWizardMainPage_conflictDescription);
        GridLayout detailsLayout = new GridLayout();
        detailsLayout.numColumns = 2;
        detailsGroup.setLayout((Layout)detailsLayout);
        detailsGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)detailsGroup, 0);
        label.setText(this.treeConflict.getDescription());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label = new Label((Composite)detailsGroup, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label = new Label((Composite)detailsGroup, 0);
        label.setText(Messages.ResolveTreeConflictWizardMainPage_sourceLeft);
        label = new Label((Composite)detailsGroup, 64);
        if (this.treeConflict.getConflictDescriptor().getSrcLeftVersion() != null) {
            label.setText(this.treeConflict.getConflictDescriptor().getSrcLeftVersion().toString());
        }
        gd = new GridData();
        gd.widthHint = 500;
        label.setLayoutData((Object)gd);
        label = new Label((Composite)detailsGroup, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label = new Label((Composite)detailsGroup, 0);
        label.setText(Messages.ResolveTreeConflictWizardMainPage_sourceRight);
        label = new Label((Composite)detailsGroup, 64);
        if (this.treeConflict.getConflictDescriptor().getSrcRightVersion() != null) {
            label.setText(this.treeConflict.getConflictDescriptor().getSrcRightVersion().toString());
        }
        gd = new GridData();
        gd.widthHint = 500;
        label.setLayoutData((Object)gd);
        Group resolutionGroup = new Group(outerContainer, 0);
        resolutionGroup.setText(Messages.ResolveTreeConflictWizardMainPage_resolutionSteps);
        GridLayout resolutionLayout = new GridLayout();
        resolutionLayout.numColumns = 1;
        resolutionGroup.setLayout((Layout)resolutionLayout);
        resolutionGroup.setLayoutData((Object)new GridData(768));
        SVNConflictDescriptor conflictDescriptor = this.treeConflict.getConflictDescriptor();
        int reason = conflictDescriptor.getReason();
        int action = conflictDescriptor.getAction();
        int operation = conflictDescriptor.getOperation();
        if ((reason == 2 || reason == 3) && action == 0) {
            if (operation == 3) {
                this.remoteCopiedTo = this.getRemoteCopiedTo(true);
            } else {
                this.copiedTo = this.getCopiedTo(false);
            }
            this.getRemoteResource(wizard, this.treeConflict);
            this.compareButton = new Button((Composite)resolutionGroup, 32);
            this.compareButton.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_compare) + conflictDescriptor.getSrcRightVersion().getPathInRepos() + Messages.ResolveTreeConflictWizardMainPage_compareTo);
            this.compareLabel = new Label((Composite)resolutionGroup, 0);
            this.compareLabel.setText(Messages.ResolveTreeConflictWizardMainPage_compareEditorInformation);
            this.compareLabel.setVisible(false);
            this.mergeFromRepositoryButton = new Button((Composite)resolutionGroup, 32);
            this.mergeFromRepositoryButton.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_merge) + conflictDescriptor.getSrcRightVersion().getPathInRepos() + Messages.ResolveTreeConflictWizardMainPage_intoTarget);
            Group mergeTargetGroup = new Group((Composite)resolutionGroup, 0);
            mergeTargetGroup.setText(Messages.ResolveTreeConflictWizardMainPage_compareMergeTarget);
            GridLayout mergeTargetLayout = new GridLayout();
            mergeTargetLayout.numColumns = 2;
            mergeTargetGroup.setLayout((Layout)mergeTargetLayout);
            mergeTargetGroup.setLayoutData((Object)new GridData(768));
            this.mergeTargetText = new Text((Composite)mergeTargetGroup, 2056);
            gd = new GridData(768);
            this.mergeTargetText.setLayoutData((Object)gd);
            if (this.copiedTo != null) {
                this.mergeTarget = File2Resource.getResource((File)this.copiedTo.getFile());
                this.svnCompareResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.mergeTarget);
                this.mergeTargetText.setText(this.mergeTarget.getFullPath().toString());
            } else if (this.remoteCopiedTo != null) {
                this.mergeTarget = File2Resource.getResource((File)this.remoteCopiedTo.getFile());
                this.svnCompareResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.mergeTarget);
                this.mergeTargetText.setText(this.mergeTarget.getFullPath().toString());
            } else {
                this.setPageComplete(false);
            }
            Button selectMergeTargetButton = new Button((Composite)mergeTargetGroup, 8);
            selectMergeTargetButton.setText(Messages.ResolveTreeConflictWizardMainPage_browse);
            selectMergeTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String title = ResolveTreeConflictWizardMainPage.this.mergeFromRepositoryButton == null && ResolveTreeConflictWizardMainPage.this.compareButton != null ? Messages.ResolveTreeConflictWizardMainPage_selectCompareTarget : (ResolveTreeConflictWizardMainPage.this.compareButton == null && ResolveTreeConflictWizardMainPage.this.mergeFromRepositoryButton != null ? Messages.ResolveTreeConflictWizardMainPage_selectMergeTarget : Messages.ResolveTreeConflictWizardMainPage_selectCompareMergeTarget);
                    boolean container = ResolveTreeConflictWizardMainPage.this.isContainer();
                    Object dialog = container ? new ContainerSelectionDialog(ResolveTreeConflictWizardMainPage.this.getShell(), (IContainer)ResolveTreeConflictWizardMainPage.this.treeConflict.getResource().getProject(), false, title) : new ResourceSelectionDialog(ResolveTreeConflictWizardMainPage.this.getShell(), (IAdaptable)ResolveTreeConflictWizardMainPage.this.treeConflict.getResource().getProject(), title);
                    if (dialog.open() == 0) {
                        Object[] selectedResources = dialog.getResult();
                        IResource selectedResource = null;
                        if (selectedResources != null && selectedResources.length > 0) {
                            if (selectedResources[0] instanceof IResource) {
                                selectedResource = (IResource)selectedResources[0];
                            }
                            if (selectedResources[0] instanceof Path) {
                                Path path = (Path)selectedResources[0];
                                selectedResource = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
                            }
                        }
                        if (selectedResource != null) {
                            ResolveTreeConflictWizardMainPage.this.mergeTarget = selectedResource;
                            ResolveTreeConflictWizardMainPage.this.svnCompareResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)ResolveTreeConflictWizardMainPage.this.mergeTarget);
                            ResolveTreeConflictWizardMainPage.this.mergeTargetText.setText(ResolveTreeConflictWizardMainPage.this.mergeTarget.getFullPath().toString());
                            ResolveTreeConflictWizardMainPage.this.setPageComplete(true);
                        }
                    }
                }
            });
            this.mergeFromRepositoryButton.setSelection(true);
            SelectionAdapter choiceListener2 = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (ResolveTreeConflictWizardMainPage.this.compareButton.getSelection() || ResolveTreeConflictWizardMainPage.this.mergeFromRepositoryButton != null && ResolveTreeConflictWizardMainPage.this.mergeFromRepositoryButton.getSelection()) {
                        ResolveTreeConflictWizardMainPage.this.setPageComplete(ResolveTreeConflictWizardMainPage.this.mergeTargetText != null && ResolveTreeConflictWizardMainPage.this.mergeTargetText.getText().length() > 0 || ResolveTreeConflictWizardMainPage.this.mergeTargetCombo != null && ResolveTreeConflictWizardMainPage.this.mergeTargetCombo.getText().length() > 0);
                    } else {
                        ResolveTreeConflictWizardMainPage.this.setPageComplete(true);
                    }
                    if (ResolveTreeConflictWizardMainPage.this.compareButton.getSelection()) {
                        ResolveTreeConflictWizardMainPage.this.compareLabel.setVisible(true);
                        ResolveTreeConflictWizardMainPage.this.mergeFromRepositoryButton.setEnabled(false);
                        ResolveTreeConflictWizardMainPage.this.markResolvedButton.setEnabled(false);
                    } else {
                        ResolveTreeConflictWizardMainPage.this.compareLabel.setVisible(false);
                        ResolveTreeConflictWizardMainPage.this.mergeFromRepositoryButton.setEnabled(true);
                        ResolveTreeConflictWizardMainPage.this.markResolvedButton.setEnabled(true);
                    }
                }
            };
            this.compareButton.addSelectionListener((SelectionListener)choiceListener2);
            if (this.mergeFromRepositoryButton != null) {
                this.mergeFromRepositoryButton.addSelectionListener((SelectionListener)choiceListener2);
            }
        }
        if (reason == 0 && action == 2) {
            SelectionAdapter choiceListener3;
            this.compareButton = new Button((Composite)resolutionGroup, 32);
            boolean container = this.isContainer();
            name = container ? this.treeConflict.getResource().getFullPath().toString() : this.treeConflict.getResource().getName();
            this.compareButton.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_compare) + name + Messages.ResolveTreeConflictWizardMainPage_to);
            this.compareButton.setSelection(false);
            if (operation != 2) {
                this.compareLabel = new Label((Composite)resolutionGroup, 0);
                this.compareLabel.setText(Messages.ResolveTreeConflictWizardMainPage_compareEditorInformation);
                this.compareLabel.setVisible(false);
            }
            this.compareResource2 = this.treeConflict.getResource();
            if (operation == 3) {
                try {
                    this.adds = wizard.getAdds();
                }
                catch (SVNException e) {
                    SVNUIPlugin.log(4, e.getMessage(), e);
                }
                this.mergeFromRepositoryButton = new Button((Composite)resolutionGroup, 32);
                name = container ? this.treeConflict.getResource().getFullPath().toString() : this.treeConflict.getResource().getName();
                this.mergeFromRepositoryButton.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_merge) + name + Messages.ResolveTreeConflictWizardMainPage_into);
                this.mergeFromRepositoryButton.setSelection(true);
                this.mergeFromUrl = wizard.getSvnResource().getUrl().toString();
            } else {
                this.remoteCopiedTo = this.getRemoteCopiedTo(false);
            }
            Composite mergeTargetGroup = new Composite((Composite)resolutionGroup, 0);
            GridLayout mergeTargetLayout = new GridLayout();
            mergeTargetLayout.numColumns = 2;
            mergeTargetGroup.setLayout((Layout)mergeTargetLayout);
            mergeTargetGroup.setLayoutData((Object)new GridData(768));
            if (this.adds == null || this.adds.length == 0) {
                this.mergeTargetText = new Text(mergeTargetGroup, 2056);
                gd = new GridData(768);
                this.mergeTargetText.setLayoutData((Object)gd);
            } else {
                this.mergeTargetCombo = new Combo(mergeTargetGroup, 2056);
                gd = new GridData(768);
                this.mergeTargetCombo.setLayoutData((Object)gd);
                this.mergeTargetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        ISVNStatus selectedAdd = ResolveTreeConflictWizardMainPage.this.adds[ResolveTreeConflictWizardMainPage.this.mergeTargetCombo.getSelectionIndex()];
                        ResolveTreeConflictWizardMainPage.this.mergeTarget = File2Resource.getResource((File)selectedAdd.getFile());
                        ResolveTreeConflictWizardMainPage.this.compareResource1 = ResolveTreeConflictWizardMainPage.this.mergeTarget;
                    }
                });
            }
            if (this.adds != null && this.adds.length > 0) {
                int i = 0;
                while (i < this.adds.length) {
                    IResource mergeTargetResource = File2Resource.getResource((File)this.adds[i].getFile());
                    this.mergeTargetCombo.add(mergeTargetResource.getFullPath().toString());
                    ++i;
                }
                this.mergeTargetCombo.select(0);
                this.compareResource1 = this.mergeTarget = File2Resource.getResource((File)this.adds[0].getFile());
            } else if (this.remoteCopiedTo != null) {
                this.mergeTarget = File2Resource.getResource((File)this.remoteCopiedTo.getFile());
                this.mergeTargetText.setText(this.mergeTarget.getFullPath().toString());
                this.compareResource1 = this.mergeTarget;
            }
            Button selectMergeTargetButton = new Button(mergeTargetGroup, 8);
            selectMergeTargetButton.setText(Messages.ResolveTreeConflictWizardMainPage_browse);
            selectMergeTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String title = ResolveTreeConflictWizardMainPage.this.mergeFromRepositoryButton == null && ResolveTreeConflictWizardMainPage.this.compareButton != null ? Messages.ResolveTreeConflictWizardMainPage_selectCompareTarget : (ResolveTreeConflictWizardMainPage.this.compareButton == null && ResolveTreeConflictWizardMainPage.this.mergeFromRepositoryButton != null ? Messages.ResolveTreeConflictWizardMainPage_selectMergeTarget : Messages.ResolveTreeConflictWizardMainPage_selectCompareMergeTarget);
                    boolean container = ResolveTreeConflictWizardMainPage.this.isContainer();
                    Object dialog = container ? new ContainerSelectionDialog(ResolveTreeConflictWizardMainPage.this.getShell(), (IContainer)ResolveTreeConflictWizardMainPage.this.treeConflict.getResource().getProject(), false, title) : new ResourceSelectionDialog(ResolveTreeConflictWizardMainPage.this.getShell(), (IAdaptable)ResolveTreeConflictWizardMainPage.this.treeConflict.getResource().getProject(), title);
                    if (dialog.open() == 0) {
                        Object[] selectedResources = dialog.getResult();
                        IResource selectedResource = null;
                        if (selectedResources != null && selectedResources.length > 0) {
                            if (selectedResources[0] instanceof IResource) {
                                selectedResource = (IResource)selectedResources[0];
                            }
                            if (selectedResources[0] instanceof Path) {
                                Path path = (Path)selectedResources[0];
                                selectedResource = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
                            }
                        }
                        if (selectedResource != null) {
                            ResolveTreeConflictWizardMainPage.this.mergeTarget = selectedResource;
                            ResolveTreeConflictWizardMainPage.this.compareResource1 = ResolveTreeConflictWizardMainPage.this.mergeTarget;
                            if (ResolveTreeConflictWizardMainPage.this.mergeTargetText == null) {
                                ResolveTreeConflictWizardMainPage.this.mergeTargetCombo.setText(ResolveTreeConflictWizardMainPage.this.mergeTarget.getFullPath().toString());
                            } else {
                                ResolveTreeConflictWizardMainPage.this.mergeTargetText.setText(ResolveTreeConflictWizardMainPage.this.mergeTarget.getFullPath().toString());
                            }
                            ResolveTreeConflictWizardMainPage.this.setPageComplete(true);
                        }
                    }
                }
            });
            if (operation == 2) {
                this.compareLabel = new Label((Composite)resolutionGroup, 0);
                this.compareLabel.setText(Messages.ResolveTreeConflictWizardMainPage_compareEditorInformation);
                this.compareLabel.setVisible(false);
            }
            if (operation != 3) {
                this.revertResource = this.treeConflict.getResource();
                if (wizard.isAdded()) {
                    this.revertButton = new Button((Composite)resolutionGroup, 32);
                    name = this.revertResource instanceof IContainer ? this.revertResource.getFullPath().toString() : this.revertResource.getName();
                    this.revertButton.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_revert) + name + Messages.ResolveTreeConflictWizardMainPage_conflictWillBeResolved);
                    this.revertButton.setSelection(true);
                }
                this.deleteResource1 = this.treeConflict.getResource();
                this.deleteButton1 = new Button((Composite)resolutionGroup, 32);
                name = this.deleteResource1 instanceof IContainer ? this.deleteResource1.getFullPath().toString() : this.deleteResource1.getName();
                if (wizard.isAdded()) {
                    this.deleteButton1.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_remove) + name + Messages.ResolveTreeConflictWizardMainPage_fromWorkingCopy);
                } else {
                    this.deleteButton1.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_delete) + name);
                }
                this.deleteButton1.setSelection(true);
                if (wizard.isAdded()) {
                    this.markResolvedEnabled = false;
                }
                choiceListener3 = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (ResolveTreeConflictWizardMainPage.this.compareButton.getSelection() || ResolveTreeConflictWizardMainPage.this.mergeFromRepositoryButton != null && ResolveTreeConflictWizardMainPage.this.mergeFromRepositoryButton.getSelection()) {
                            ResolveTreeConflictWizardMainPage.this.setPageComplete(ResolveTreeConflictWizardMainPage.this.mergeTargetText != null && ResolveTreeConflictWizardMainPage.this.mergeTargetText.getText().length() > 0 || ResolveTreeConflictWizardMainPage.this.mergeTargetCombo != null && ResolveTreeConflictWizardMainPage.this.mergeTargetCombo.getText().length() > 0);
                        } else {
                            ResolveTreeConflictWizardMainPage.this.setPageComplete(true);
                        }
                        if (ResolveTreeConflictWizardMainPage.this.compareButton.getSelection()) {
                            ResolveTreeConflictWizardMainPage.this.compareLabel.setVisible(true);
                            if (ResolveTreeConflictWizardMainPage.this.revertButton != null) {
                                ResolveTreeConflictWizardMainPage.this.revertButton.setEnabled(false);
                            }
                            ResolveTreeConflictWizardMainPage.this.deleteButton1.setEnabled(false);
                            ResolveTreeConflictWizardMainPage.this.markResolvedButton.setEnabled(false);
                        } else {
                            ResolveTreeConflictWizardMainPage.this.compareLabel.setVisible(false);
                            if (ResolveTreeConflictWizardMainPage.this.revertButton != null) {
                                ResolveTreeConflictWizardMainPage.this.revertButton.setEnabled(true);
                                ResolveTreeConflictWizardMainPage.this.deleteButton1.setEnabled(true);
                                ResolveTreeConflictWizardMainPage.this.markResolvedButton.setEnabled(true);
                                if (ResolveTreeConflictWizardMainPage.this.revertButton.getSelection()) {
                                    ResolveTreeConflictWizardMainPage.this.deleteButton1.setEnabled(true);
                                    ResolveTreeConflictWizardMainPage.this.markResolvedButton.setSelection(false);
                                    ResolveTreeConflictWizardMainPage.this.markResolvedButton.setEnabled(false);
                                } else {
                                    ResolveTreeConflictWizardMainPage.this.deleteButton1.setSelection(false);
                                    ResolveTreeConflictWizardMainPage.this.deleteButton1.setEnabled(false);
                                    ResolveTreeConflictWizardMainPage.this.markResolvedButton.setEnabled(true);
                                }
                            }
                        }
                    }
                };
                this.compareButton.addSelectionListener((SelectionListener)choiceListener3);
                if (this.mergeFromRepositoryButton != null) {
                    this.mergeFromRepositoryButton.addSelectionListener((SelectionListener)choiceListener3);
                }
                if (this.revertButton != null) {
                    this.revertButton.addSelectionListener((SelectionListener)choiceListener3);
                }
                this.deleteButton1.addSelectionListener((SelectionListener)choiceListener3);
            }
            if (operation == 3) {
                if (this.treeConflict.getResource().exists()) {
                    this.deleteResource1 = this.treeConflict.getResource();
                    this.deleteButton1 = new Button((Composite)resolutionGroup, 32);
                    name = this.deleteResource1 instanceof IContainer ? this.deleteResource1.getFullPath().toString() : this.deleteResource1.getName();
                    this.deleteButton1.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_delete) + name);
                    this.deleteButton1.setSelection(true);
                    this.markResolvedEnabled = false;
                    if (this.markResolvedButton != null) {
                        this.markResolvedButton.setSelection(true);
                        this.markResolvedButton.setEnabled(false);
                    }
                }
                choiceListener3 = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (!ResolveTreeConflictWizardMainPage.this.compareButton.getSelection() && !ResolveTreeConflictWizardMainPage.this.mergeFromRepositoryButton.getSelection()) {
                            ResolveTreeConflictWizardMainPage.this.setPageComplete(true);
                        } else {
                            ResolveTreeConflictWizardMainPage.this.setPageComplete(ResolveTreeConflictWizardMainPage.this.mergeTargetText != null && ResolveTreeConflictWizardMainPage.this.mergeTargetText.getText().length() > 0 || ResolveTreeConflictWizardMainPage.this.mergeTargetCombo != null && ResolveTreeConflictWizardMainPage.this.mergeTargetCombo.getText().length() > 0);
                        }
                        if (ResolveTreeConflictWizardMainPage.this.compareButton.getSelection()) {
                            ResolveTreeConflictWizardMainPage.this.compareLabel.setVisible(true);
                            if (ResolveTreeConflictWizardMainPage.this.mergeFromRepositoryButton != null) {
                                ResolveTreeConflictWizardMainPage.this.mergeFromRepositoryButton.setEnabled(false);
                            }
                            if (ResolveTreeConflictWizardMainPage.this.deleteButton1 != null) {
                                ResolveTreeConflictWizardMainPage.this.deleteButton1.setEnabled(false);
                            }
                            if (ResolveTreeConflictWizardMainPage.this.markResolvedButton != null) {
                                ResolveTreeConflictWizardMainPage.this.markResolvedButton.setEnabled(false);
                            }
                        } else {
                            ResolveTreeConflictWizardMainPage.this.compareLabel.setVisible(false);
                            if (ResolveTreeConflictWizardMainPage.this.mergeFromRepositoryButton != null) {
                                ResolveTreeConflictWizardMainPage.this.mergeFromRepositoryButton.setEnabled(true);
                            }
                            if (ResolveTreeConflictWizardMainPage.this.deleteButton1 != null) {
                                ResolveTreeConflictWizardMainPage.this.deleteButton1.setEnabled(true);
                                if (ResolveTreeConflictWizardMainPage.this.deleteButton1.getSelection() && ResolveTreeConflictWizardMainPage.this.markResolvedButton != null) {
                                    ResolveTreeConflictWizardMainPage.this.markResolvedButton.setSelection(true);
                                    ResolveTreeConflictWizardMainPage.this.markResolvedButton.setEnabled(false);
                                }
                            }
                            if (!(ResolveTreeConflictWizardMainPage.this.markResolvedButton == null || ResolveTreeConflictWizardMainPage.this.deleteButton1 != null && ResolveTreeConflictWizardMainPage.this.deleteButton1.getSelection())) {
                                ResolveTreeConflictWizardMainPage.this.markResolvedButton.setEnabled(true);
                            }
                        }
                    }
                };
                this.compareButton.addSelectionListener((SelectionListener)choiceListener3);
                this.mergeFromRepositoryButton.addSelectionListener((SelectionListener)choiceListener3);
                if (this.deleteButton1 != null) {
                    this.deleteButton1.addSelectionListener((SelectionListener)choiceListener3);
                }
            }
        }
        if (reason == 2 && action == 2 && operation != 3) {
            this.copiedTo = this.getCopiedTo(true);
            this.remoteCopiedTo = this.getRemoteCopiedTo(true);
            this.theirs = null;
            this.mine = null;
            if (this.remoteCopiedTo != null) {
                this.theirs = File2Resource.getResource((File)this.remoteCopiedTo.getFile());
            }
            if (this.copiedTo != null) {
                this.mine = File2Resource.getResource((File)this.copiedTo.getFile());
            }
            if (this.mine != null && this.mine.exists() && this.theirs != null && this.theirs.exists()) {
                this.compareButton = new Button((Composite)resolutionGroup, 32);
                name = this.mine instanceof IContainer ? this.mine.getFullPath().toString() : this.mine.getName();
                this.compareButton.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_compare) + name + Messages.ResolveTreeConflictWizardMainPage_to2 + this.theirs.getName());
                this.compareButton.setSelection(false);
                this.compareResource1 = this.mine;
                this.compareResource2 = this.theirs;
                this.compareLabel = new Label((Composite)resolutionGroup, 0);
                this.compareLabel.setText(Messages.ResolveTreeConflictWizardMainPage_compareEditorInformation);
                this.compareLabel.setVisible(false);
                this.compareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        ResolveTreeConflictWizardMainPage.this.compareLabel.setVisible(ResolveTreeConflictWizardMainPage.this.compareButton.getSelection());
                        if (ResolveTreeConflictWizardMainPage.this.option1Button != null) {
                            ResolveTreeConflictWizardMainPage.this.option1Button.setEnabled(!ResolveTreeConflictWizardMainPage.this.compareButton.getSelection());
                        }
                        if (ResolveTreeConflictWizardMainPage.this.option1Group != null) {
                            ResolveTreeConflictWizardMainPage.this.option1Group.setEnabled(!ResolveTreeConflictWizardMainPage.this.compareButton.getSelection());
                        }
                        if (ResolveTreeConflictWizardMainPage.this.option2Button != null) {
                            ResolveTreeConflictWizardMainPage.this.option2Button.setEnabled(!ResolveTreeConflictWizardMainPage.this.compareButton.getSelection());
                        }
                        if (ResolveTreeConflictWizardMainPage.this.option2Group != null) {
                            ResolveTreeConflictWizardMainPage.this.option2Group.setEnabled(!ResolveTreeConflictWizardMainPage.this.compareButton.getSelection());
                        }
                        if (ResolveTreeConflictWizardMainPage.this.option3Button != null) {
                            ResolveTreeConflictWizardMainPage.this.option3Button.setEnabled(!ResolveTreeConflictWizardMainPage.this.compareButton.getSelection());
                        }
                        ResolveTreeConflictWizardMainPage.this.markResolvedButton.setEnabled(!ResolveTreeConflictWizardMainPage.this.compareButton.getSelection());
                    }
                });
            }
            if (this.mine != null && this.mine.exists()) {
                this.option1Button = new Button((Composite)resolutionGroup, 16);
                this.option1Button.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_choose) + this.mine.getFullPath());
                this.option1Button.setSelection(true);
                this.option1Group = new Group((Composite)resolutionGroup, 0);
                name = this.mine instanceof IContainer ? this.mine.getFullPath().toString() : this.mine.getName();
                this.option1Group.setText(name);
                option1Layout = new GridLayout();
                option1Layout.numColumns = 1;
                this.option1Group.setLayout((Layout)option1Layout);
                this.option1Group.setLayoutData((Object)new GridData(768));
                if (this.theirs != null && this.theirs.exists()) {
                    this.deleteResource1 = this.theirs;
                    this.deleteButton1 = new Button((Composite)this.option1Group, 32);
                    name = this.deleteResource1 instanceof IContainer ? this.deleteResource1.getFullPath().toString() : this.deleteResource1.getName();
                    this.deleteButton1.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_delete) + name);
                    this.deleteButton1.setSelection(true);
                } else {
                    this.option1Group.setVisible(false);
                }
            }
            if (this.theirs != null && this.theirs.exists()) {
                this.option2Button = new Button((Composite)resolutionGroup, 16);
                this.option2Button.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_choose) + this.theirs.getFullPath());
                if (this.option1Button == null) {
                    this.option2Button.setSelection(true);
                }
                this.option2Group = new Group((Composite)resolutionGroup, 0);
                name = this.theirs instanceof IContainer ? this.theirs.getFullPath().toString() : this.theirs.getName();
                this.option2Group.setText(name);
                GridLayout option2Layout = new GridLayout();
                option2Layout.numColumns = 1;
                this.option2Group.setLayout((Layout)option2Layout);
                this.option2Group.setLayoutData((Object)new GridData(768));
                if (this.mine != null && this.mine.exists()) {
                    ISVNLocalResource myResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.mine);
                    try {
                        if (myResource.getStatus().isAdded()) {
                            this.revertResource = this.mine;
                            this.revertButton = new Button((Composite)this.option2Group, 32);
                            name = this.mine instanceof IContainer ? this.mine.getFullPath().toString() : this.mine.getName();
                            this.revertButton.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_revert) + name);
                            this.revertButton.setSelection(true);
                        }
                    }
                    catch (SVNException e) {
                        SVNUIPlugin.log(4, e.getMessage(), e);
                    }
                    this.deleteResource2 = this.mine;
                    this.deleteButton2 = new Button((Composite)this.option2Group, 32);
                    name = this.deleteResource2 instanceof IContainer ? this.deleteResource2.getFullPath().toString() : this.deleteResource2.getName();
                    this.deleteButton2.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_remove) + name + Messages.ResolveTreeConflictWizardMainPage_fromWorkingCopy);
                    this.deleteButton2.setSelection(true);
                    this.option2Group.setEnabled(this.option1Button == null);
                } else {
                    this.option2Group.setVisible(false);
                }
            }
            if (this.mine != null && this.mine.exists() && this.theirs != null && this.theirs.exists()) {
                this.option3Button = new Button((Composite)resolutionGroup, 16);
                this.option3Button.setText(Messages.ResolveTreeConflictWizardMainPage_chooseBoth);
            }
            SelectionAdapter optionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (ResolveTreeConflictWizardMainPage.this.option1Button != null && ResolveTreeConflictWizardMainPage.this.option1Button.getSelection()) {
                        ResolveTreeConflictWizardMainPage.this.option1Group.setEnabled(true);
                        if (ResolveTreeConflictWizardMainPage.this.option2Group != null) {
                            ResolveTreeConflictWizardMainPage.this.option2Group.setEnabled(false);
                        }
                    }
                    if (ResolveTreeConflictWizardMainPage.this.option2Button != null && ResolveTreeConflictWizardMainPage.this.option2Button.getSelection()) {
                        ResolveTreeConflictWizardMainPage.this.option2Group.setEnabled(true);
                        if (ResolveTreeConflictWizardMainPage.this.option1Group != null) {
                            ResolveTreeConflictWizardMainPage.this.option1Group.setEnabled(false);
                        }
                    }
                    if (ResolveTreeConflictWizardMainPage.this.option3Button.getSelection()) {
                        ResolveTreeConflictWizardMainPage.this.option1Group.setEnabled(false);
                        ResolveTreeConflictWizardMainPage.this.option2Group.setEnabled(false);
                    }
                    if (ResolveTreeConflictWizardMainPage.this.revertButton != null) {
                        if (ResolveTreeConflictWizardMainPage.this.revertButton.getSelection()) {
                            ResolveTreeConflictWizardMainPage.this.deleteButton2.setEnabled(true);
                        } else {
                            ResolveTreeConflictWizardMainPage.this.deleteButton2.setEnabled(false);
                            ResolveTreeConflictWizardMainPage.this.deleteButton2.setSelection(false);
                        }
                    }
                }
            };
            if (this.option1Button != null) {
                this.option1Button.addSelectionListener((SelectionListener)optionListener);
            }
            if (this.option2Button != null) {
                this.option2Button.addSelectionListener((SelectionListener)optionListener);
            }
            if (this.option3Button != null) {
                this.option3Button.addSelectionListener((SelectionListener)optionListener);
            }
            if (this.revertButton != null) {
                this.revertButton.addSelectionListener((SelectionListener)optionListener);
            }
        }
        if (reason == 2 && action == 2 && operation == 3) {
            this.remoteCopiedTo = this.getRemoteCopiedTo(true);
            if (this.remoteCopiedTo != null) {
                this.mine = File2Resource.getResource((File)this.remoteCopiedTo.getFile());
            }
            if (this.mine != null && this.mine.exists()) {
                try {
                    this.adds = wizard.getAdds();
                }
                catch (SVNException e) {
                    SVNUIPlugin.log(4, e.getMessage(), e);
                }
                this.option1Button = new Button((Composite)resolutionGroup, 16);
                this.option1Button.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_choose) + this.mine.getFullPath());
                this.option1Button.setSelection(true);
                if (this.adds != null && this.adds.length > 0) {
                    this.option1Group = new Group((Composite)resolutionGroup, 0);
                    name = this.mine instanceof IContainer ? this.mine.getFullPath().toString() : this.mine.getName();
                    this.option1Group.setText(name);
                    option1Layout = new GridLayout();
                    option1Layout.numColumns = 1;
                    this.option1Group.setLayout((Layout)option1Layout);
                    this.option1Group.setLayoutData((Object)new GridData(768));
                    if (this.adds.length == 1) {
                        this.revertResource = File2Resource.getResource((File)this.adds[0].getFile());
                        this.revertButton = new Button((Composite)this.option1Group, 32);
                        name = this.revertResource instanceof IContainer ? this.revertResource.getFullPath().toString() : this.revertResource.getName();
                        this.revertButton.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_revert) + name);
                        this.revertButton.setSelection(true);
                        this.deleteResource1 = File2Resource.getResource((File)this.adds[0].getFile());
                        this.deleteButton1 = new Button((Composite)this.option1Group, 32);
                        name = this.deleteResource1 instanceof IContainer ? this.deleteResource1.getFullPath().toString() : this.deleteResource1.getName();
                        this.deleteButton1.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_remove) + name + Messages.ResolveTreeConflictWizardMainPage_fromWorkingCopy);
                        this.deleteButton1.setSelection(true);
                    } else {
                        this.revertButton = new Button((Composite)this.option1Group, 32);
                        this.revertButton.setText(Messages.ResolveTreeConflictWizardMainPage_revertSelected);
                        this.revertCombo = new Combo((Composite)this.option1Group, 2056);
                        gd = new GridData(768);
                        this.revertCombo.setLayoutData((Object)gd);
                        this.revertCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent evt) {
                                ISVNStatus selectedRevert = ResolveTreeConflictWizardMainPage.this.adds[ResolveTreeConflictWizardMainPage.this.revertCombo.getSelectionIndex()];
                                ResolveTreeConflictWizardMainPage.this.revertResource = File2Resource.getResource((File)selectedRevert.getFile());
                                ResolveTreeConflictWizardMainPage.this.deleteResource1 = ResolveTreeConflictWizardMainPage.this.revertResource;
                            }
                        });
                        int i = 0;
                        while (i < this.adds.length) {
                            IResource revertResource = File2Resource.getResource((File)this.adds[i].getFile());
                            this.revertCombo.add(revertResource.getFullPath().toString());
                            ++i;
                        }
                        this.revertCombo.select(0);
                        this.deleteResource1 = this.revertResource = File2Resource.getResource((File)this.adds[0].getFile());
                        this.deleteButton1 = new Button((Composite)this.option1Group, 32);
                        this.deleteButton1.setText(Messages.ResolveTreeConflictWizardMainPage_removeSelected);
                        this.deleteButton1.setEnabled(false);
                        this.setPageComplete(false);
                    }
                }
                this.option2Button = new Button((Composite)resolutionGroup, 16);
                this.option2Group = new Group((Composite)resolutionGroup, 0);
                GridLayout option2Layout = new GridLayout();
                option2Layout.numColumns = 1;
                this.option2Group.setLayout((Layout)option2Layout);
                this.option2Group.setLayoutData((Object)new GridData(768));
                if (this.adds == null || this.adds.length != 1) {
                    this.option2Button.setText(Messages.ResolveTreeConflictWizardMainPage_chooseIncoming);
                    this.option2Group.setText(Messages.ResolveTreeConflictWizardMainPage_incoming);
                } else {
                    IResource addResource = File2Resource.getResource((File)this.adds[0].getFile());
                    this.option2Button.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_choose) + addResource.getFullPath());
                    String name2 = addResource instanceof IContainer ? addResource.getFullPath().toString() : addResource.getName();
                    this.option2Group.setText(name2);
                }
                this.deleteResource2 = this.mine;
                this.deleteButton2 = new Button((Composite)this.option2Group, 32);
                String name3 = this.deleteResource2 instanceof IContainer ? this.deleteResource2.getFullPath().toString() : this.deleteResource2.getName();
                this.deleteButton2.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_delete) + name3);
                this.deleteButton2.setSelection(true);
                this.option2Group.setEnabled(false);
                this.option3Button = new Button((Composite)resolutionGroup, 16);
                this.option3Button.setText(Messages.ResolveTreeConflictWizardMainPage_chooseBoth);
                choiceListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (ResolveTreeConflictWizardMainPage.this.option1Group != null) {
                            ResolveTreeConflictWizardMainPage.this.option1Group.setEnabled(ResolveTreeConflictWizardMainPage.this.option1Button.getSelection());
                        }
                        if (ResolveTreeConflictWizardMainPage.this.option2Group != null) {
                            ResolveTreeConflictWizardMainPage.this.option2Group.setEnabled(ResolveTreeConflictWizardMainPage.this.option2Button.getSelection());
                        }
                        if (ResolveTreeConflictWizardMainPage.this.revertButton != null && ResolveTreeConflictWizardMainPage.this.deleteButton1 != null) {
                            if (ResolveTreeConflictWizardMainPage.this.revertButton.getSelection()) {
                                ResolveTreeConflictWizardMainPage.this.deleteButton1.setEnabled(true);
                            } else {
                                ResolveTreeConflictWizardMainPage.this.deleteButton1.setEnabled(false);
                                ResolveTreeConflictWizardMainPage.this.deleteButton1.setSelection(false);
                            }
                        }
                        if (ResolveTreeConflictWizardMainPage.this.option1Button.getSelection()) {
                            ResolveTreeConflictWizardMainPage.this.setPageComplete(ResolveTreeConflictWizardMainPage.this.revertButton == null || ResolveTreeConflictWizardMainPage.this.revertButton.getSelection());
                        }
                        if (ResolveTreeConflictWizardMainPage.this.option2Button.getSelection()) {
                            ResolveTreeConflictWizardMainPage.this.setPageComplete(ResolveTreeConflictWizardMainPage.this.deleteButton2 == null || ResolveTreeConflictWizardMainPage.this.deleteButton2.getSelection());
                        }
                        if (ResolveTreeConflictWizardMainPage.this.option3Button.getSelection()) {
                            ResolveTreeConflictWizardMainPage.this.setPageComplete(true);
                        }
                    }
                };
                this.option1Button.addSelectionListener((SelectionListener)choiceListener);
                this.option2Button.addSelectionListener((SelectionListener)choiceListener);
                this.option3Button.addSelectionListener((SelectionListener)choiceListener);
                if (this.revertButton != null) {
                    this.revertButton.addSelectionListener((SelectionListener)choiceListener);
                }
                if (this.deleteButton2 != null) {
                    this.deleteButton2.addSelectionListener((SelectionListener)choiceListener);
                }
                if (this.revertButton != null) {
                    this.revertButton.addSelectionListener((SelectionListener)choiceListener);
                }
            }
        }
        if (reason == 5 && action == 1 && (operation == 1 || operation == 3) || reason == 1 && action == 1 && operation == 3) {
            this.compareButton = new Button((Composite)resolutionGroup, 32);
            boolean container = this.isContainer();
            name = container ? this.treeConflict.getResource().getFullPath().toString() : this.treeConflict.getResource().getName();
            this.compareButton.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_compare) + name + Messages.ResolveTreeConflictWizardMainPage_to2 + this.treeConflict.getConflictDescriptor().getSrcRightVersion().getPathInRepos() + Messages.ResolveTreeConflictWizardMainPage_inRepository);
            this.compareButton.setSelection(false);
            this.compareResource1 = this.treeConflict.getResource();
            this.getRemoteResource(wizard, this.treeConflict);
            this.compareLabel = new Label((Composite)resolutionGroup, 0);
            this.compareLabel.setText(Messages.ResolveTreeConflictWizardMainPage_compareEditorInformation);
            this.compareLabel.setVisible(false);
            choiceListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (ResolveTreeConflictWizardMainPage.this.compareButton.getSelection()) {
                        ResolveTreeConflictWizardMainPage.this.compareLabel.setVisible(true);
                        ResolveTreeConflictWizardMainPage.this.markResolvedButton.setEnabled(false);
                    } else {
                        ResolveTreeConflictWizardMainPage.this.compareLabel.setVisible(false);
                        ResolveTreeConflictWizardMainPage.this.markResolvedButton.setEnabled(true);
                    }
                }
            };
            this.compareButton.addSelectionListener((SelectionListener)choiceListener);
        }
        if (conflictDescriptor.getSrcLeftVersion() == null) {
            this.revertButton = new Button((Composite)resolutionGroup, 32);
            this.revertResource = this.treeConflict.getResource();
            name = this.revertResource instanceof IContainer ? this.revertResource.getFullPath().toString() : this.revertResource.getName();
            this.revertButton.setText(String.valueOf(Messages.ResolveTreeConflictWizardMainPage_revert) + name + Messages.ResolveTreeConflictWizardMainPage_conflictWillBeResolved);
            this.revertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ResolveTreeConflictWizardMainPage.this.revertButton.getSelection()) {
                        ResolveTreeConflictWizardMainPage.this.markResolvedButton.setSelection(false);
                    }
                    ResolveTreeConflictWizardMainPage.this.markResolvedButton.setEnabled(!ResolveTreeConflictWizardMainPage.this.revertButton.getSelection());
                }
            });
        }
        this.markResolvedButton = new Button((Composite)resolutionGroup, 32);
        this.markResolvedButton.setText(Messages.ResolveTreeConflictWizardMainPage_markResolved);
        this.markResolvedButton.setSelection(true);
        if (this.markResolvedEnabled) {
            this.markResolvedButton.setSelection(true);
        } else {
            this.markResolvedButton.setEnabled(false);
        }
        this.setMessage(Messages.ResolveTreeConflictWizardMainPage_message);
        this.setControl((Control)outerContainer);
    }

    private void getRemoteResource(ResolveTreeConflictWizard wizard, SVNTreeConflict treeConflict) {
        ISVNRepositoryLocation repository = wizard.getSvnResource().getRepository();
        SVNRevision.Number revision = new SVNRevision.Number(treeConflict.getConflictDescriptor().getSrcRightVersion().getPegRevision());
        try {
            SVNUrl url = new SVNUrl(String.valueOf(treeConflict.getConflictDescriptor().getSrcRightVersion().getReposURL()) + "/" + treeConflict.getConflictDescriptor().getSrcRightVersion().getPathInRepos());
            GetRemoteResourceCommand command = new GetRemoteResourceCommand(repository, url, (SVNRevision)revision);
            command.run((IProgressMonitor)new NullProgressMonitor());
            this.remoteResource = command.getRemoteResource();
        }
        catch (Exception e) {
            SVNUIPlugin.log(4, e.getMessage(), e);
        }
    }

    public boolean getMergeFromRepository() {
        if (this.compareButton != null && this.compareButton.getSelection()) {
            return false;
        }
        return this.mergeFromRepositoryButton != null && this.mergeFromRepositoryButton.getSelection();
    }

    public boolean getCompare() {
        return this.compareButton != null && this.compareButton.getSelection();
    }

    public boolean getMarkResolved() {
        return !this.getCompare() && this.markResolvedButton.getSelection();
    }

    public IResource getMergeTarget() {
        return this.mergeTarget;
    }

    public IResource getRevertResource() {
        if (this.getCompare()) {
            return null;
        }
        if (this.revertButton != null && this.revertButton.isEnabled() && this.revertButton.getSelection()) {
            return this.revertResource;
        }
        return null;
    }

    public IResource getDeleteResource() {
        if (this.getCompare()) {
            return null;
        }
        if (this.deleteButton1 != null && this.deleteButton1.isEnabled() && this.deleteButton1.getSelection()) {
            return this.deleteResource1;
        }
        if (this.deleteButton2 != null && this.deleteButton2.isEnabled() && this.deleteButton2.getSelection()) {
            return this.deleteResource2;
        }
        return null;
    }

    public IResource getCompareResource1() {
        return this.compareResource1;
    }

    public IResource getCompareResource2() {
        return this.compareResource2;
    }

    public ISVNRemoteResource getRemoteResource() {
        return this.remoteResource;
    }

    public ISVNLocalResource getSvnCompareResource() {
        return this.svnCompareResource;
    }

    public String getMergeFromUrl() {
        if (this.mergeFromUrl == null) {
            return String.valueOf(this.treeConflict.getConflictDescriptor().getSrcRightVersion().getReposURL()) + "/" + this.treeConflict.getConflictDescriptor().getSrcRightVersion().getPathInRepos();
        }
        return this.mergeFromUrl;
    }

    private ISVNStatus getCopiedTo(final boolean getAll) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.setTaskName(Messages.ResolveTreeConflictWizardMainPage_lookingForCopiedToUrl);
                monitor.beginTask(Messages.ResolveTreeConflictWizardMainPage_lookingForCopiedToUrl, -1);
                ResolveTreeConflictWizard wizard = (ResolveTreeConflictWizard)ResolveTreeConflictWizardMainPage.this.getWizard();
                try {
                    ResolveTreeConflictWizardMainPage.this.copiedTo = wizard.getLocalCopiedTo(getAll);
                }
                catch (Exception e) {
                    SVNUIPlugin.log(4, e.getMessage(), e);
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (Exception e) {
            SVNUIPlugin.log(4, e.getMessage(), e);
        }
        return this.copiedTo;
    }

    private ISVNStatus getRemoteCopiedTo(final boolean getAll) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.setTaskName(Messages.ResolveTreeConflictWizardMainPage_lookingForCopiedToUrl);
                monitor.beginTask(Messages.ResolveTreeConflictWizardMainPage_lookingForCopiedToUrl, -1);
                ResolveTreeConflictWizard wizard = (ResolveTreeConflictWizard)ResolveTreeConflictWizardMainPage.this.getWizard();
                try {
                    ResolveTreeConflictWizardMainPage.this.remoteCopiedTo = wizard.getRemoteCopiedTo(getAll);
                }
                catch (Exception e) {
                    SVNUIPlugin.log(4, e.getMessage(), e);
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (Exception e) {
            SVNUIPlugin.log(4, e.getMessage(), e);
        }
        return this.remoteCopiedTo;
    }

    private boolean isContainer() {
        boolean container = this.treeConflict.getResource().exists() ? this.treeConflict.getResource() instanceof IContainer : (this.svnCompareResource == null || !this.svnCompareResource.exists() ? this.treeConflict.getResource().getName().indexOf(".") == -1 : this.svnCompareResource.isFolder());
        return container;
    }
}

