/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.ui.ISaveableWorkbenchPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.client.StatusAndInfoCommand;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.resources.RemoteResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.MultipleSelectionNode;
import org.tigris.subversion.subclipse.ui.compare.SVNAbstractCompareEditorInput;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalResourceSummaryNode;
import org.tigris.subversion.subclipse.ui.compare.SummaryDifferencer;
import org.tigris.subversion.subclipse.ui.compare.SummaryEditionNode;
import org.tigris.subversion.subclipse.ui.compare.internal.Utilities;
import org.tigris.subversion.subclipse.ui.internal.Utils;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class SVNLocalCompareSummaryInput
extends SVNAbstractCompareEditorInput
implements ISaveableWorkbenchPart {
    private ISVNLocalResource[] resources;
    private final SVNRevision remoteRevision;
    private ISVNRemoteFolder[] remoteFolders;
    private boolean readOnly;

    public SVNLocalCompareSummaryInput(ISVNLocalResource[] resources, SVNRevision remoteRevision) throws SVNException {
        super(new CompareConfiguration());
        this.resources = resources;
        this.remoteRevision = remoteRevision;
        this.remoteFolders = new RemoteFolder[resources.length];
        int i = 0;
        while (i < resources.length) {
            this.remoteFolders[i] = new RemoteFolder(resources[i].getRepository(), resources[i].getUrl(), remoteRevision);
            ++i;
        }
    }

    private void initLabels() {
        String rightLabel;
        String leftLabel;
        String title;
        CompareConfiguration cc = this.getCompareConfiguration();
        cc.setLeftEditable(!this.readOnly);
        cc.setRightEditable(false);
        if (this.resources.length > 1) {
            title = String.valueOf(Policy.bind("SVNLocalBaseCompareInput.0")) + this.remoteRevision;
            leftLabel = Policy.bind("SVNLocalBaseCompareInput.1");
            rightLabel = this.remoteRevision.toString();
        } else {
            title = Policy.bind("SVNCompareRevisionsInput.compareResourceAndVersions", new Object[]{this.resources[0].getName()});
            leftLabel = Policy.bind("SVNCompareRevisionsInput.workspace", new Object[]{this.resources[0].getName()});
            rightLabel = Policy.bind("SVNCompareRevisionsInput.repository", new Object[]{this.resources[0].getName()});
        }
        this.setTitle(title);
        cc.setLeftLabel(leftLabel);
        cc.setRightLabel(rightLabel);
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InterruptedException {
        this.initLabels();
        try {
            DiffNode diffNode;
            monitor.beginTask(Policy.bind("SVNCompareEditorInput.comparing"), 30);
            SubProgressMonitor sub = new SubProgressMonitor(monitor, 30);
            sub.beginTask(Policy.bind("SVNCompareEditorInput.comparing"), 100);
            Object[] result = new Object[1];
            ArrayList<SVNLocalResourceSummaryNode> resourceSummaryNodeList = new ArrayList<SVNLocalResourceSummaryNode>();
            ArrayList<SummaryEditionNode> summaryEditionNodeList = new ArrayList<SummaryEditionNode>();
            ISVNClientAdapter client = null;
            try {
                int i = 0;
                while (i < this.resources.length) {
                    ISVNLocalResource resource = this.resources[i];
                    ISVNRemoteFolder remoteFolder = this.remoteFolders[i];
                    SVNDiffSummary[] diffSummary = null;
                    if (remoteFolder.getRevision().equals((Object)SVNRevision.HEAD) && remoteFolder.getUrl().equals((Object)resource.getUrl())) {
                        StatusAndInfoCommand cmd = new StatusAndInfoCommand(SVNWorkspaceRoot.getSVNResourceFor((IResource)resource.getResource()), true, false, true);
                        cmd.run(monitor);
                        RemoteResourceStatus[] statuses = cmd.getRemoteResourceStatuses();
                        diffSummary = this.getDiffSummary(statuses, resource);
                    } else {
                        client = SVNProviderPlugin.getPlugin().getSVNClientManager().getSVNClient();
                        diffSummary = client.diffSummarize(new File(resource.getResource().getLocation().toString()), remoteFolder.getUrl(), remoteFolder.getRevision(), true);
                        SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
                        client = null;
                    }
                    if (diffSummary != null && diffSummary.length > 0) {
                        diffSummary = this.getDiffSummaryWithSubfolders(diffSummary);
                        SVNLocalResourceSummaryNode left = new SVNLocalResourceSummaryNode(resource, diffSummary, resource.getResource().getLocation().toString());
                        SummaryEditionNode right = new SummaryEditionNode((ISVNRemoteResource)remoteFolder);
                        right.setName(resource.getFile().getName());
                        right.setRootFolder((RemoteFolder)remoteFolder);
                        right.setNodeType(1);
                        right.setRoot(true);
                        right.setDiffSummary(diffSummary);
                        String localCharset = Utilities.getCharset(resource.getIResource());
                        try {
                            right.setCharset(localCharset);
                        }
                        catch (CoreException e) {
                            SVNUIPlugin.log(4, e.getMessage(), e);
                        }
                        resourceSummaryNodeList.add(left);
                        summaryEditionNodeList.add(right);
                    }
                    ++i;
                }
                if (resourceSummaryNodeList.size() == 0) {
                    result[0] = null;
                } else {
                    Object[] resourceSummaryNodes = new Object[resourceSummaryNodeList.size()];
                    resourceSummaryNodeList.toArray(resourceSummaryNodes);
                    Object[] summaryEditionNodes = new Object[summaryEditionNodeList.size()];
                    summaryEditionNodeList.toArray(summaryEditionNodes);
                    MultipleSelectionNode left = new MultipleSelectionNode(resourceSummaryNodes);
                    MultipleSelectionNode right = new MultipleSelectionNode(summaryEditionNodes);
                    result[0] = new SummaryDifferencer().findDifferences(false, monitor, null, null, left, right);
                }
            }
            finally {
                sub.done();
                if (client != null) {
                    SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
                }
            }
            if (result[0] instanceof DiffNode && !(diffNode = (DiffNode)result[0]).hasChildren()) {
                return null;
            }
            Object object = result[0];
            return object;
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (Exception e) {
            String string = e.getMessage();
            return string;
        }
        finally {
            monitor.done();
        }
    }

    private SVNDiffSummary[] getDiffSummary(RemoteResourceStatus[] statuses, ISVNLocalResource resource) {
        ArrayList<SVNDiffSummary> diffSummaryList = new ArrayList<SVNDiffSummary>();
        int rootPathLength = resource.getResource().getLocation().toString().length() + 1;
        int i = 0;
        while (i < statuses.length) {
            if (statuses[i].getFile() != null && !statuses[i].getNodeKind().equals((Object)SVNNodeKind.DIR)) {
                IFile file;
                SVNStatusKind textStatus = statuses[i].getTextStatus();
                boolean propertyChanges = !statuses[i].getPropStatus().equals((Object)SVNStatusKind.NORMAL) && !statuses[i].getPropStatus().equals((Object)SVNStatusKind.NONE);
                boolean localChanges = false;
                if (textStatus.equals((Object)SVNStatusKind.NONE) && propertyChanges && statuses[i].getNodeKind().equals((Object)SVNNodeKind.FILE) && (file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(statuses[i].getPath()))) != null) {
                    ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)file);
                    try {
                        LocalResourceStatus localStatus = svnResource.getStatus();
                        if (localStatus != null) {
                            localChanges = localStatus.isAdded() || localStatus.isDirty();
                        }
                    }
                    catch (SVNException sVNException) {}
                }
                if (!textStatus.equals((Object)SVNStatusKind.NONE) || !propertyChanges || localChanges) {
                    SVNDiffSummary.SVNDiffKind diffKind = null;
                    diffKind = statuses[i].getTextStatus().equals((Object)SVNStatusKind.ADDED) ? SVNDiffSummary.SVNDiffKind.ADDED : (statuses[i].getTextStatus().equals((Object)SVNStatusKind.DELETED) ? SVNDiffSummary.SVNDiffKind.DELETED : SVNDiffSummary.SVNDiffKind.MODIFIED);
                    SVNDiffSummary diffSummary = new SVNDiffSummary(statuses[i].getPath().substring(rootPathLength).replaceAll("\\\\", "/"), diffKind, propertyChanges, statuses[i].getNodeKind().toInt());
                    diffSummaryList.add(diffSummary);
                }
            }
            ++i;
        }
        SVNDiffSummary[] diffSummaries = new SVNDiffSummary[diffSummaryList.size()];
        diffSummaryList.toArray(diffSummaries);
        return diffSummaries;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.saveChanges(monitor);
        }
        catch (CoreException e) {
            Utils.handle(e);
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void addPropertyListener(IPropertyListener listener) {
    }

    public void createPartControl(Composite parent) {
        this.createContents(parent);
    }

    public void dispose() {
    }

    public IWorkbenchPartSite getSite() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void removePropertyListener(IPropertyListener listener) {
    }

    public boolean canRunAsJob() {
        return true;
    }

    private SVNDiffSummary[] getDiffSummaryWithSubfolders(SVNDiffSummary[] diffSummary) {
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<SVNDiffSummary> diffs = new ArrayList<SVNDiffSummary>();
        int i = 0;
        while (i < diffSummary.length) {
            paths.add(diffSummary[i].getPath());
            diffs.add(diffSummary[i]);
            ++i;
        }
        i = 0;
        while (i < diffSummary.length) {
            File file = new File(diffSummary[i].getPath());
            while (file.getParentFile() != null) {
                file = file.getParentFile();
                String path = file.getPath();
                if (paths.contains(path = path.replaceAll("\\\\", "/"))) continue;
                paths.add(path);
                SVNDiffSummary folder = new SVNDiffSummary(path, SVNDiffSummary.SVNDiffKind.NORMAL, false, SVNNodeKind.DIR.toInt());
                diffs.add(folder);
            }
            ++i;
        }
        diffSummary = new SVNDiffSummary[diffs.size()];
        diffs.toArray(diffSummary);
        return diffSummary;
    }
}

