/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.File;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.ui.ISaveableWorkbenchPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.commands.GetRemoteResourceCommand;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.ResourceEditionNode;
import org.tigris.subversion.subclipse.ui.compare.RevisionAwareDifferencer;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalResourceNode;
import org.tigris.subversion.subclipse.ui.compare.StatusAwareDifferencer;
import org.tigris.subversion.subclipse.ui.compare.internal.Utilities;
import org.tigris.subversion.subclipse.ui.internal.Utils;
import org.tigris.subversion.subclipse.ui.operations.ShowDifferencesAsUnifiedDiffOperationWC;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNLocalCompareInput
extends CompareEditorInput
implements ISaveableWorkbenchPart {
    private final SVNRevision remoteRevision;
    private ISVNLocalResource resource;
    private ISVNRemoteResource remoteResource;
    private SVNRevision pegRevision;
    private boolean readOnly;
    private File diffFile;
    private ShowDifferencesAsUnifiedDiffOperationWC diffOperation;

    public SVNLocalCompareInput(ISVNLocalResource resource, SVNRevision revision, boolean readOnly) throws SVNException, SVNClientException {
        super(new CompareConfiguration());
        this.remoteRevision = revision;
        this.readOnly = readOnly;
        this.resource = resource;
        LocalResourceStatus status = resource.getStatus();
        if (status != null && status.isCopied()) {
            ISVNClientAdapter svnClient = null;
            try {
                svnClient = resource.getRepository().getSVNClient();
                ISVNInfo info = svnClient.getInfoFromWorkingCopy(resource.getFile());
                SVNUrl copiedFromUrl = info.getCopyUrl();
                if (copiedFromUrl != null) {
                    GetRemoteResourceCommand getRemoteResourceCommand = new GetRemoteResourceCommand(resource.getRepository(), copiedFromUrl, SVNRevision.HEAD);
                    getRemoteResourceCommand.run(null);
                    this.remoteResource = getRemoteResourceCommand.getRemoteResource();
                }
            }
            finally {
                resource.getRepository().returnSVNClient(svnClient);
            }
        }
        if (this.remoteResource == null) {
            this.remoteResource = resource.getRemoteResource(revision);
        }
    }

    public SVNLocalCompareInput(ISVNLocalResource resource, SVNRevision revision) throws SVNException, SVNClientException {
        this(resource, revision, false);
    }

    public SVNLocalCompareInput(ISVNLocalResource resource, ISVNRemoteResource remoteResource) throws SVNException {
        this(resource, remoteResource, null);
    }

    public SVNLocalCompareInput(ISVNLocalResource resource, ISVNRemoteResource remoteResource, SVNRevision pegRevision) throws SVNException {
        super(new CompareConfiguration());
        this.resource = resource;
        this.remoteResource = remoteResource;
        this.remoteRevision = remoteResource.getRevision();
        this.pegRevision = pegRevision;
    }

    private void initLabels() {
        CompareConfiguration cc = this.getCompareConfiguration();
        String resourceName = this.resource.getName();
        this.setTitle(Policy.bind("SVNCompareRevisionsInput.compareResourceAndVersions", new Object[]{resourceName}));
        cc.setLeftEditable(!this.readOnly);
        cc.setRightEditable(false);
        String leftLabel = Policy.bind("SVNCompareRevisionsInput.workspace", new Object[]{resourceName});
        cc.setLeftLabel(leftLabel);
        String remoteResourceName = null;
        remoteResourceName = this.remoteResource != null ? this.remoteResource.getName() : resourceName;
        String rightLabel = Policy.bind("SVNCompareRevisionsInput.repository", new Object[]{remoteResourceName});
        cc.setRightLabel(rightLabel);
    }

    protected Object prepareInput(IProgressMonitor monitor) {
        if (this.diffOperation != null) {
            try {
                this.diffOperation.run(monitor);
                this.diffFile = this.diffOperation.getFile();
            }
            catch (Exception exception) {}
            if (this.diffOperation.isCanceled() || monitor.isCanceled()) {
                return null;
            }
        }
        this.initLabels();
        SVNLocalResourceNode left = new SVNLocalResourceNode(this.resource);
        ResourceEditionNode right = new ResourceEditionNode(this.remoteResource, this.pegRevision);
        if (left.getType() == "FOLDER") {
            right.setLocalResource(left);
        }
        if (right.getType() == "FOLDER") {
            left.setRemoteResource(right);
        }
        String localCharset = Utilities.getCharset(this.resource.getIResource());
        try {
            right.setCharset(localCharset);
        }
        catch (CoreException e) {
            SVNUIPlugin.log(4, e.getMessage(), e);
        }
        if (SVNRevision.BASE.equals((Object)this.remoteRevision)) {
            return new StatusAwareDifferencer().findDifferences(false, monitor, null, null, (Object)left, right);
        }
        return new RevisionAwareDifferencer(left, right, this.diffFile, this.pegRevision).findDifferences(false, monitor, null, null, (Object)left, right);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.saveChanges(monitor);
        }
        catch (CoreException e) {
            Utils.handle(e);
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void addPropertyListener(IPropertyListener listener) {
    }

    public void createPartControl(Composite parent) {
        this.createContents(parent);
    }

    public void dispose() {
    }

    public IWorkbenchPartSite getSite() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void removePropertyListener(IPropertyListener listener) {
    }

    public void setDiffOperation(ShowDifferencesAsUnifiedDiffOperationWC diffOperation) {
        this.diffOperation = diffOperation;
    }

    public void setDiffFile(File diffFile) {
        this.diffFile = diffFile;
    }

    public boolean canRunAsJob() {
        return true;
    }
}

