/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.comments;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.comments.CommentHistoryContentHandler;
import org.tigris.subversion.subclipse.ui.comments.CommentTemplatesContentHandler;
import org.tigris.subversion.subclipse.ui.internal.XMLWriter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CommentsManager {
    static String[] previousComments = new String[0];
    static String[] commentTemplates = new String[0];
    static final int MAX_COMMENTS = 10;
    private static final String COMMENT_HIST_FILE = "commitCommentHistory.xml";
    private static final String COMMENT_TEMPLATES_FILE = "commentTemplates.xml";
    static final String ELEMENT_COMMIT_COMMENT = "CommitComment";
    static final String ELEMENT_COMMIT_HISTORY = "CommitComments";
    static final String ELEMENT_COMMENT_TEMPLATES = "CommitCommentTemplates";

    public String[] getPreviousComments() {
        return previousComments;
    }

    public void addComment(String comment) {
        int index = this.getCommentIndex(comment);
        if (index != -1) {
            this.makeFirstElement(index);
            return;
        }
        if (this.containsCommentTemplate(comment)) {
            return;
        }
        String[] newComments = new String[Math.min(previousComments.length + 1, 10)];
        newComments[0] = comment;
        int i = 1;
        while (i < newComments.length) {
            newComments[i] = previousComments[i - 1];
            ++i;
        }
        previousComments = newComments;
    }

    private int getCommentIndex(String comment) {
        int i = 0;
        while (i < previousComments.length) {
            if (previousComments[i].equals(comment)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void makeFirstElement(int index) {
        String[] newComments = new String[previousComments.length];
        newComments[0] = previousComments[index];
        System.arraycopy(previousComments, 0, newComments, 1, index);
        int maxIndex = previousComments.length - 1;
        if (index != maxIndex) {
            int nextIndex = index + 1;
            System.arraycopy(previousComments, nextIndex, newComments, nextIndex, maxIndex - index);
        }
        previousComments = newComments;
    }

    public void loadCommentHistory() {
        IPath pluginStateLocation = SVNUIPlugin.getPlugin().getStateLocation().append(COMMENT_HIST_FILE);
        File file = pluginStateLocation.toFile();
        if (!file.exists()) {
            return;
        }
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                try {
                    SAXParser parser = factory.newSAXParser();
                    parser.parse(new InputSource(is), (DefaultHandler)new CommentHistoryContentHandler());
                }
                catch (SAXException ex) {
                    throw new SVNException(Policy.bind("RepositoryManager.parsingProblem", COMMENT_HIST_FILE), (Throwable)ex);
                }
                catch (ParserConfigurationException e) {
                    throw new SVNException(Policy.bind("RepositoryManager.parsingProblem", COMMENT_HIST_FILE), (Throwable)e);
                }
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            SVNUIPlugin.log((IStatus)new Status(4, "org.tigris.subversion.subclipse.ui", -6, Policy.bind("RepositoryManager.ioException"), (Throwable)e));
        }
        catch (TeamException e) {
            SVNUIPlugin.log(e.getStatus());
        }
    }

    public void saveCommentHistory() throws TeamException {
        IPath pluginStateLocation = SVNUIPlugin.getPlugin().getStateLocation();
        File tempFile = pluginStateLocation.append("commitCommentHistory.xml.tmp").toFile();
        File histFile = pluginStateLocation.append(COMMENT_HIST_FILE).toFile();
        try {
            boolean renamed;
            XMLWriter writer = new XMLWriter(new BufferedOutputStream(new FileOutputStream(tempFile)));
            try {
                writer.startTag(ELEMENT_COMMIT_HISTORY, null, false);
                int i = 0;
                while (i < previousComments.length && i < 10) {
                    writer.printSimpleTag(ELEMENT_COMMIT_COMMENT, previousComments[i]);
                    ++i;
                }
                writer.endTag(ELEMENT_COMMIT_HISTORY);
            }
            finally {
                writer.close();
            }
            if (histFile.exists()) {
                histFile.delete();
            }
            if (!(renamed = tempFile.renameTo(histFile))) {
                throw new TeamException((IStatus)new Status(4, "org.tigris.subversion.subclipse.ui", -6, Policy.bind("RepositoryManager.rename", tempFile.getAbsolutePath()), null));
            }
        }
        catch (IOException e) {
            throw new TeamException((IStatus)new Status(4, "org.tigris.subversion.subclipse.ui", -6, Policy.bind("RepositoryManager.save", histFile.getAbsolutePath()), (Throwable)e));
        }
    }

    public void loadCommentTemplates() {
        IPath pluginStateLocation = SVNUIPlugin.getPlugin().getStateLocation();
        File histFile = pluginStateLocation.append(COMMENT_TEMPLATES_FILE).toFile();
        if (!histFile.exists()) {
            return;
        }
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(histFile));
            try {
                this.readCommentTemplates(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            SVNUIPlugin.log((IStatus)new Status(4, "org.tigris.subversion.subclipse.ui", -6, Policy.bind("RepositoryManager.ioException"), (Throwable)e));
        }
        catch (TeamException e) {
            SVNUIPlugin.log(e.getStatus());
        }
    }

    private void readCommentTemplates(InputStream stream) throws IOException, TeamException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(stream), (DefaultHandler)new CommentTemplatesContentHandler());
        }
        catch (SAXException ex) {
            throw new SVNException(NLS.bind((String)Policy.bind("RepositoryManager.parsingProblem"), (Object[])new String[]{COMMENT_TEMPLATES_FILE}), (Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new SVNException(NLS.bind((String)Policy.bind("RepositoryManager.parsingProblem"), (Object[])new String[]{COMMENT_TEMPLATES_FILE}), (Throwable)ex);
        }
    }

    public void saveCommentTemplates() throws TeamException {
        IPath pluginStateLocation = SVNUIPlugin.getPlugin().getStateLocation();
        File tempFile = pluginStateLocation.append("commentTemplates.xml.tmp").toFile();
        File histFile = pluginStateLocation.append(COMMENT_TEMPLATES_FILE).toFile();
        try {
            boolean renamed;
            XMLWriter writer = new XMLWriter(new BufferedOutputStream(new FileOutputStream(tempFile)));
            try {
                this.writeCommentTemplates(writer);
            }
            finally {
                writer.close();
            }
            if (histFile.exists()) {
                histFile.delete();
            }
            if (!(renamed = tempFile.renameTo(histFile))) {
                throw new TeamException((IStatus)new Status(4, "org.tigris.subversion.subclipse.ui", -6, NLS.bind((String)Policy.bind("RepositoryManager.rename"), (Object[])new String[]{tempFile.getAbsolutePath()}), null));
            }
        }
        catch (IOException e) {
            throw new TeamException((IStatus)new Status(4, "org.tigris.subversion.subclipse.ui", -6, NLS.bind((String)Policy.bind("RepositoryManager.save"), (Object[])new String[]{histFile.getAbsolutePath()}), (Throwable)e));
        }
    }

    private void writeCommentTemplates(XMLWriter writer) {
        writer.startTag(ELEMENT_COMMENT_TEMPLATES, null, false);
        int i = 0;
        while (i < commentTemplates.length) {
            writer.printSimpleTag(ELEMENT_COMMIT_COMMENT, commentTemplates[i]);
            ++i;
        }
        writer.endTag(ELEMENT_COMMENT_TEMPLATES);
    }

    private boolean containsCommentTemplate(String comment) {
        int i = 0;
        while (i < commentTemplates.length) {
            if (commentTemplates[i].equals(comment)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getCommentTemplates() {
        return commentTemplates;
    }

    public void replaceAndSaveCommentTemplates(String[] templates) throws TeamException {
        commentTemplates = templates;
        this.saveCommentTemplates();
    }
}

