/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.xml;

import com.collabnet.subversion.merge.MergeOutput;
import com.collabnet.subversion.merge.MergeResult;
import com.collabnet.subversion.merge.MergeSummaryResult;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MergeOutputDocument {
    private MergeOutput mergeOutput;
    private Document document;

    public MergeOutputDocument(MergeOutput mergeOutput) {
        this.mergeOutput = mergeOutput;
        this.document = this.createDocument();
    }

    private Document createDocument() {
        try {
            String depth;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element rootElement = doc.createElement("mergeOutput");
            rootElement.setAttribute("resource", this.mergeOutput.getResource().getFullPath().toString());
            rootElement.setAttribute("date", this.mergeOutput.getMergeDate().toString());
            String status = null;
            status = this.mergeOutput.isInProgress() ? "inProgress" : (this.mergeOutput.isAbnormalEnd() ? "aborted" : "normal");
            rootElement.setAttribute("status", status);
            rootElement.setAttribute("revisionStart", Long.toString(this.mergeOutput.getLowerRevision()));
            rootElement.setAttribute("revisionEnd", Long.toString(this.mergeOutput.getUpperRevision()));
            Element workspaceElement = doc.createElement("workspace");
            workspaceElement.setAttribute("url", this.mergeOutput.getWorkspaceUrl());
            workspaceElement.setAttribute("revision", Long.toString(this.mergeOutput.getWorkspaceRevision()));
            rootElement.appendChild(workspaceElement);
            Element commandElement = doc.createElement("mergeCommand");
            commandElement.appendChild(doc.createTextNode(this.mergeOutput.getMergeCommand()));
            rootElement.appendChild(commandElement);
            Element optionsElement = doc.createElement("mergeOptions");
            optionsElement.setAttribute("force", this.getBoolean(this.mergeOutput.getMergeOptions().isForce()));
            optionsElement.setAttribute("ignoreAncestry", this.getBoolean(this.mergeOutput.getMergeOptions().isIgnoreAncestry()));
            optionsElement.setAttribute("recurse", this.getBoolean(this.mergeOutput.getMergeOptions().isRecurse()));
            if (this.mergeOutput.getMergeOptions().isReintegrate()) {
                optionsElement.setAttribute("reintegrate", "true");
            }
            switch (this.mergeOutput.getMergeOptions().getDepth()) {
                case 2: {
                    depth = "thisItem";
                    break;
                }
                case 3: {
                    depth = "fileChildren";
                    break;
                }
                case 4: {
                    depth = "immediateChildren";
                    break;
                }
                case 5: {
                    depth = "infinite";
                    break;
                }
                default: {
                    depth = "workingCopy";
                }
            }
            optionsElement.setAttribute("depth", depth);
            if (this.mergeOutput.getMergeOptions().getFromRevision() != null) {
                optionsElement.setAttribute("revisionFrom", this.mergeOutput.getMergeOptions().getFromRevision().toString());
            }
            if (this.mergeOutput.getMergeOptions().getToRevision() != null) {
                optionsElement.setAttribute("revisionTo", this.mergeOutput.getMergeOptions().getToRevision().toString());
            }
            Element fromUrlElement = doc.createElement("fromUrl");
            fromUrlElement.appendChild(doc.createTextNode(this.mergeOutput.getMergeOptions().getFromUrl().toString()));
            optionsElement.appendChild(fromUrlElement);
            if (this.mergeOutput.getMergeOptions().getRevisions() != null) {
                Element revisionRangesElement = doc.createElement("revisionRanges");
                SVNRevisionRange[] revisionRanges = this.mergeOutput.getMergeOptions().getRevisions();
                int i = 0;
                while (i < revisionRanges.length) {
                    Element revisionRangeElement = doc.createElement("revisionRange");
                    revisionRangeElement.appendChild(doc.createTextNode(revisionRanges[i].toString()));
                    revisionRangesElement.appendChild(revisionRangeElement);
                    ++i;
                }
                optionsElement.appendChild(revisionRangesElement);
            }
            if (this.mergeOutput.getMergeOptions().getToUrl() != null && !this.mergeOutput.getMergeOptions().getToUrl().toString().equals(this.mergeOutput.getMergeOptions().getFromUrl().toString())) {
                Element toUrlElement = doc.createElement("toUrl");
                toUrlElement.appendChild(doc.createTextNode(this.mergeOutput.getMergeOptions().getToUrl().toString()));
                optionsElement.appendChild(toUrlElement);
            }
            rootElement.appendChild(optionsElement);
            Element summaryElement = doc.createElement("summary");
            Element fileStatisticsElement = doc.createElement("fileStats");
            Element propertyStatisticsElement = doc.createElement("propertiesStats");
            Element treeConflictStatisticsElement = doc.createElement("treeConflictStats");
            MergeSummaryResult[] summaryResults = this.mergeOutput.getMergeSummaryResults();
            boolean fileStats = false;
            boolean propStats = false;
            boolean treeStats = false;
            int i = 0;
            while (i < summaryResults.length) {
                if (summaryResults[i].getType() == 0) {
                    fileStatisticsElement.setAttribute(summaryResults[i].getCategory().replaceAll(" ", "_"), summaryResults[i].getNumber());
                    fileStats = true;
                }
                if (summaryResults[i].getType() == 1) {
                    propertyStatisticsElement.setAttribute(summaryResults[i].getCategory().replaceAll(" ", "_"), summaryResults[i].getNumber());
                    propStats = true;
                }
                if (summaryResults[i].getType() == 2) {
                    treeConflictStatisticsElement.setAttribute(summaryResults[i].getCategory().replaceAll(" ", "_"), summaryResults[i].getNumber());
                    treeStats = true;
                }
                ++i;
            }
            if (fileStats) {
                summaryElement.appendChild(fileStatisticsElement);
            }
            if (propStats) {
                summaryElement.appendChild(propertyStatisticsElement);
            }
            if (treeStats) {
                summaryElement.appendChild(treeConflictStatisticsElement);
            }
            rootElement.appendChild(summaryElement);
            Element resultsElement = doc.createElement("mergeResults");
            Element textElement = doc.createElement("text");
            Element mergedTextElement = doc.createElement("merged");
            Element conflictedTextElement = doc.createElement("conflicted");
            Element skippedTextElement = doc.createElement("skipped");
            Element propertiesElement = doc.createElement("properties");
            Element mergedPropertiesElement = doc.createElement("merged");
            Element conflictedPropertiesElement = doc.createElement("conflicted");
            Element skippedPropertiesElement = doc.createElement("skipped");
            Element treeConflictsElement = doc.createElement("treeConflicts");
            boolean treeConflicts = false;
            boolean mergedText = false;
            boolean conflictedText = false;
            boolean skippedText = false;
            boolean mergedProperties = false;
            boolean conflictedProperties = false;
            boolean skippedProperties = false;
            MergeResult[] mergeResults = this.mergeOutput.getMergeResults();
            int i2 = 0;
            while (i2 < mergeResults.length) {
                Element resultElement;
                if (mergeResults[i2].hasTreeConflict()) {
                    resultElement = doc.createElement("result");
                    resultElement.setAttribute("resource", mergeResults[i2].getResource().getFullPath().toString());
                    resultElement.setAttribute("resolved", this.getBoolean(mergeResults[i2].isTreeConflictResolved()));
                    treeConflictsElement.appendChild(resultElement);
                    treeConflicts = true;
                }
                if (mergeResults[i2].getAction() != null && mergeResults[i2].getAction().trim().length() > 0) {
                    resultElement = doc.createElement("result");
                    resultElement.setAttribute("resource", mergeResults[i2].getResource().getFullPath().toString());
                    if (mergeResults[i2].isConflicted()) {
                        resultElement.setAttribute("resolved", this.getBoolean(mergeResults[i2].isResolved()));
                        if (mergeResults[i2].getAction().equals("A")) {
                            resultElement.setAttribute("added", "true");
                        } else if (mergeResults[i2].getAction().equals("D")) {
                            resultElement.setAttribute("deleted", "true");
                        }
                        conflictedTextElement.appendChild(resultElement);
                        conflictedText = true;
                    } else if (mergeResults[i2].isSkip()) {
                        skippedTextElement.appendChild(resultElement);
                        skippedText = true;
                    } else {
                        if (mergeResults[i2].getAction().equals("A")) {
                            resultElement.setAttribute("added", "true");
                        } else if (mergeResults[i2].getAction().equals("D")) {
                            resultElement.setAttribute("deleted", "true");
                        }
                        mergedTextElement.appendChild(resultElement);
                        mergedText = true;
                    }
                }
                if (mergeResults[i2].getPropertyAction() != null && mergeResults[i2].getPropertyAction().trim().length() > 0) {
                    resultElement = doc.createElement("result");
                    resultElement.setAttribute("resource", mergeResults[i2].getResource().getFullPath().toString());
                    if (mergeResults[i2].isPropertyConflicted()) {
                        resultElement.setAttribute("resolved", this.getBoolean(mergeResults[i2].isPropertyResolved()));
                        if (mergeResults[i2].getPropertyAction().equals("A")) {
                            resultElement.setAttribute("added", "true");
                        } else if (mergeResults[i2].getPropertyAction().equals("D")) {
                            resultElement.setAttribute("deleted", "true");
                        }
                        conflictedPropertiesElement.appendChild(resultElement);
                        conflictedProperties = true;
                    } else if (mergeResults[i2].isSkip()) {
                        skippedPropertiesElement.appendChild(resultElement);
                        skippedProperties = true;
                    } else {
                        if (mergeResults[i2].getPropertyAction().equals("A")) {
                            resultElement.setAttribute("added", "true");
                        } else if (mergeResults[i2].getPropertyAction().equals("D")) {
                            resultElement.setAttribute("deleted", "true");
                        }
                        mergedPropertiesElement.appendChild(resultElement);
                        mergedProperties = true;
                    }
                }
                ++i2;
            }
            if (mergedText || conflictedText || skippedText) {
                if (mergedText) {
                    textElement.appendChild(mergedTextElement);
                }
                if (conflictedText) {
                    textElement.appendChild(conflictedTextElement);
                }
                if (skippedText) {
                    textElement.appendChild(skippedTextElement);
                }
                resultsElement.appendChild(textElement);
            }
            if (mergedProperties || conflictedProperties || skippedProperties) {
                if (mergedProperties) {
                    propertiesElement.appendChild(mergedPropertiesElement);
                }
                if (conflictedProperties) {
                    propertiesElement.appendChild(conflictedPropertiesElement);
                }
                if (skippedProperties) {
                    propertiesElement.appendChild(skippedPropertiesElement);
                }
                resultsElement.appendChild(propertiesElement);
            }
            if (treeConflicts) {
                resultsElement.appendChild(treeConflictsElement);
            }
            rootElement.appendChild(resultsElement);
            doc.appendChild(rootElement);
            return doc;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Document getDocument() {
        return this.document;
    }

    private String getBoolean(boolean value) {
        if (value) {
            return "true";
        }
        return "false";
    }
}

