/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.AdaptableMergeResult;
import com.collabnet.subversion.merge.ConflictResolution;
import com.collabnet.subversion.merge.MergeOptions;
import com.collabnet.subversion.merge.MergeOutput;
import com.collabnet.subversion.merge.MergeResult;
import com.collabnet.subversion.merge.MergeSummaryResult;
import com.collabnet.subversion.merge.SVNConflictResolver;
import com.collabnet.subversion.merge.SkippedMergeResult;
import com.collabnet.subversion.merge.views.MergeResultsView;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class MergeListener
implements ISVNNotifyListener {
    private Date mergeDate;
    private ArrayList mergeResults = new ArrayList();
    private ArrayList mergeSummaryResults = new ArrayList();
    private boolean logging = true;
    private MergeResult lastMergeResult;
    private MergeOutput mergeOutput;
    private boolean viewShown = false;
    private MergeResultsView view;
    private IResource resource;
    private MergeOptions mergeOptions;
    private SVNConflictResolver conflictResolver;
    private boolean loggingFileStatistics = false;
    private boolean loggingPropertyStatistics = false;
    private boolean loggingConflictStatistics = false;
    private ArrayList skips = new ArrayList();
    private boolean resumed;

    public MergeListener(IResource resource, MergeOptions mergeOptions, SVNConflictResolver conflictResolver, MergeOutput mergeOutput) {
        this.resource = resource;
        this.mergeOptions = mergeOptions;
        this.conflictResolver = conflictResolver;
        this.mergeOutput = mergeOutput;
        if (this.mergeOutput == null) {
            this.mergeOutput = new MergeOutput();
        } else {
            this.resumed = true;
        }
        this.setWorkspaceInformation();
    }

    private void setWorkspaceInformation() {
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource);
        if (svnResource == null) {
            return;
        }
        if (svnResource.getUrl() != null) {
            this.mergeOutput.setWorkspaceUrl(svnResource.getUrl().toString());
        }
        try {
            if (svnResource.getRevision() != null) {
                this.mergeOutput.setWorkspaceRevision(((SVNRevision.Number)svnResource.getRevision()).getNumber());
            }
        }
        catch (SVNException sVNException) {}
    }

    public void logCommandLine(String commandLine) {
        if (!this.resumed) {
            this.mergeDate = new Date();
            this.mergeOutput.setResource(this.resource);
            this.mergeOutput.setMergeOptions(this.mergeOptions);
            this.mergeOutput.setMergeCommand(commandLine);
            this.mergeOutput.setMergeResults(new MergeResult[0]);
            this.mergeOutput.setMergeSummaryResults(new MergeSummaryResult[0]);
            this.mergeOutput.setMergeDate(this.mergeDate);
        } else {
            MergeResult[] previousResults = this.mergeOutput.getMergeResults();
            int i = 0;
            while (i < previousResults.length) {
                this.mergeResults.add(previousResults[i]);
                ++i;
            }
            MergeSummaryResult[] previousSummaries = this.mergeOutput.getMergeSummaryResults();
            int i2 = 0;
            while (i2 < previousSummaries.length) {
                this.mergeSummaryResults.add(previousSummaries[i2]);
                ++i2;
            }
        }
    }

    public void logCompleted(String message) {
        MergeSummaryResult mergeSummaryResult;
        MergeSummaryResult mergeSummaryResult2;
        this.logging = false;
        if (this.conflictResolver.getResolvedConflictCount(0) != 0) {
            mergeSummaryResult2 = new MergeSummaryResult(0, "Resolved conflicts", Integer.toString(this.conflictResolver.getResolvedConflictCount(0)));
            this.mergeSummaryResults.add(mergeSummaryResult2);
        }
        if (this.conflictResolver.getResolvedConflictCount(1) != 0) {
            mergeSummaryResult2 = new MergeSummaryResult(1, "Resolved conflicts", Integer.toString(this.conflictResolver.getResolvedConflictCount(1)));
            this.mergeSummaryResults.add(mergeSummaryResult2);
        }
        int skippedFiles = 0;
        int skippedFolders = 0;
        for (MergeResult skipped : this.skips) {
            if (skipped.getType() == 1) {
                ++skippedFiles;
                continue;
            }
            ++skippedFolders;
        }
        if (skippedFiles > 0) {
            mergeSummaryResult = new MergeSummaryResult(0, "Skipped files", Integer.toString(skippedFiles));
            this.mergeSummaryResults.add(mergeSummaryResult);
        }
        if (skippedFolders > 0) {
            mergeSummaryResult = new MergeSummaryResult(0, "Skipped folders", Integer.toString(skippedFolders));
            this.mergeSummaryResults.add(mergeSummaryResult);
        }
        if (skippedFiles > 0 || skippedFolders > 0) {
            this.refreshView();
        }
    }

    public void logError(String message) {
        if (this.logging && message.substring(0, 3).trim().length() > 0) {
            if (message.substring(3, 4).equals(" ")) {
                this.addMergeResult(message.substring(0, 1), message.substring(1, 2), message.substring(2, 3), message.substring(4), true);
            } else if (message.substring(2, 3).equals(" ")) {
                this.addMergeResult(message.substring(0, 1), message.substring(1, 2), " ", message.substring(3), true);
            }
        }
    }

    public void logMessage(String message) {
        if (message.indexOf("--- Merging r") != -1) {
            this.updateRevisionRange(message);
            return;
        }
        if (message.indexOf("--- Merging") != -1) {
            return;
        }
        if (this.logging) {
            if (message.startsWith("Merge info recorded for")) {
                this.addMergeResult(" ", "U", " ", message.substring(24), false);
                return;
            }
            if (message.substring(0, 3).trim().length() > 0) {
                if (message.substring(3, 4).equals(" ")) {
                    this.addMergeResult(message.substring(0, 1), message.substring(1, 2), message.substring(2, 3), message.substring(4), false);
                } else if (message.substring(2, 3).equals(" ")) {
                    this.addMergeResult(message.substring(0, 1), message.substring(1, 2), " ", message.substring(3), false);
                }
                if (message.startsWith("Skipped ")) {
                    this.addMergeResult("S", " ", " ", message.substring(8), false);
                }
            }
        }
        if (!this.logging) {
            int index;
            if (message.indexOf("File Statistics:") != -1) {
                this.loggingFileStatistics = true;
                return;
            }
            if (message.indexOf("Property Statistics:") != -1) {
                this.loggingFileStatistics = false;
                this.loggingPropertyStatistics = true;
                return;
            }
            if (message.indexOf("Conflict Statistics:") != -1) {
                this.loggingFileStatistics = false;
                this.loggingPropertyStatistics = false;
                this.loggingConflictStatistics = true;
                return;
            }
            if ((this.loggingFileStatistics || this.loggingPropertyStatistics || this.loggingConflictStatistics) && (index = message.indexOf(":")) != -1) {
                String category;
                int type;
                if (this.loggingConflictStatistics) {
                    if (message.startsWith("File conflicts:")) {
                        type = 0;
                        category = "Conflicts";
                    } else if (message.startsWith("Property conflicts:")) {
                        type = 1;
                        category = "Conflicts";
                    } else {
                        type = 2;
                        category = "Tree conflicts";
                    }
                } else {
                    type = this.loggingPropertyStatistics ? 1 : 0;
                    category = message.substring(0, index);
                }
                String number = message.substring(index + 1).trim();
                MergeSummaryResult mergeSummaryResult = new MergeSummaryResult(type, category, number);
                this.mergeSummaryResults.add(mergeSummaryResult);
                this.refreshView();
            }
        }
    }

    private void updateRevisionRange(String message) {
        int throughIndex;
        int mergingIndex = message.indexOf("--- Merging r");
        if (mergingIndex == -1) {
            return;
        }
        int lowerStart = mergingIndex + 13;
        int blankIndex = message.indexOf(" ", lowerStart);
        if (blankIndex == -1) {
            return;
        }
        String lower = message.substring(lowerStart, blankIndex);
        int lowerRevision = Integer.parseInt(lower);
        if (this.mergeOutput.getLowerRevision() == 0L || (long)lowerRevision < this.mergeOutput.getLowerRevision()) {
            this.mergeOutput.setLowerRevision(lowerRevision);
        }
        if ((long)lowerRevision > this.mergeOutput.getUpperRevision()) {
            this.mergeOutput.setUpperRevision(lowerRevision);
        }
        if ((throughIndex = message.indexOf(" through r")) == -1) {
            return;
        }
        int upperStart = throughIndex + 10;
        blankIndex = message.indexOf(" ", upperStart);
        if (blankIndex == -1) {
            return;
        }
        String upper = message.substring(upperStart, blankIndex);
        int upperRevision = Integer.parseInt(upper);
        if (this.mergeOutput.getUpperRevision() == 0L || (long)upperRevision > this.mergeOutput.getUpperRevision()) {
            this.mergeOutput.setUpperRevision(upperRevision);
        }
    }

    public void logRevision(long revision, String path) {
    }

    public void onNotify(File path, SVNNodeKind kind) {
        if (this.lastMergeResult != null && this.lastMergeResult.getPath().equals(path.toString().replaceAll("\\\\", "/"))) {
            this.lastMergeResult.setType(kind.toInt());
        }
    }

    private void addMergeResult(String action, String propertyAction, String treeConflictAction, String path, boolean error) {
        boolean add = true;
        this.lastMergeResult = action.equals("S") ? new SkippedMergeResult(action, propertyAction, treeConflictAction, path, error) : new AdaptableMergeResult(action, propertyAction, treeConflictAction, path, error);
        int index = this.mergeResults.indexOf(this.lastMergeResult);
        if (index != -1) {
            this.lastMergeResult = (MergeResult)this.mergeResults.get(index);
            this.lastMergeResult.setAction(action);
            this.lastMergeResult.setPropertyAction(propertyAction);
            this.lastMergeResult.setTreeConflictAction(treeConflictAction);
            this.lastMergeResult.setError(error);
            if (this.lastMergeResult.isConflicted()) {
                this.lastMergeResult.setConflictResolution(" ");
                this.lastMergeResult.setPropertyResolution(" ");
            }
            if (this.lastMergeResult.hasTreeConflict()) {
                this.lastMergeResult.setTreeConflictResolution(" ");
            }
            add = false;
        }
        if (add) {
            this.mergeResults.add(this.lastMergeResult);
            if (this.lastMergeResult.getAction().equals("S")) {
                this.setType(this.lastMergeResult);
                this.skips.add(this.lastMergeResult);
            } else if (this.lastMergeResult.hasTreeConflict()) {
                this.setType(this.lastMergeResult);
            }
        }
        if (!(this.lastMergeResult.isConflicted() || this.conflictResolver.getTextHandling() == 0 && this.conflictResolver.getBinaryHandling() == 0)) {
            this.updateConflictStatus(this.lastMergeResult);
        }
        this.refreshView();
    }

    private void setType(MergeResult mergeResult) {
        File file = new File(mergeResult.getPath());
        if (file.getName().indexOf(".") == -1) {
            mergeResult.setType(2);
        } else {
            mergeResult.setType(1);
        }
    }

    private void updateConflictStatus(MergeResult mergeResult) {
        ConflictResolution[] conflictResolutions = this.conflictResolver.getConflictResolutions();
        int i = 0;
        while (i < conflictResolutions.length) {
            if (conflictResolutions[i].getConflictDescriptor().getPath().equals(mergeResult.getPath()) && conflictResolutions[i].isResolved()) {
                mergeResult.setAction("C");
                mergeResult.setError(true);
                mergeResult.setConflictResolution(Integer.toString(conflictResolutions[i].getResolution()));
            }
            ++i;
        }
    }

    private MergeResult[] getMergeResults() {
        MergeResult[] mergeResultArray = new MergeResult[this.mergeResults.size()];
        this.mergeResults.toArray(mergeResultArray);
        return mergeResultArray;
    }

    private MergeSummaryResult[] getMergeSummaryResults() {
        MergeSummaryResult[] mergeSummaryResultArray = new MergeSummaryResult[this.mergeSummaryResults.size()];
        this.mergeSummaryResults.toArray(mergeSummaryResultArray);
        return mergeSummaryResultArray;
    }

    public MergeOutput getMergeOutput() {
        return this.mergeOutput;
    }

    public void setCommand(int command) {
    }

    private void refreshView() {
        MergeOutput.setInProgress(true);
        this.mergeOutput.setMergeResults(this.getMergeResults());
        this.mergeOutput.setMergeSummaryResults(this.getMergeSummaryResults());
        this.mergeOutput.store();
        if (!this.viewShown) {
            this.viewShown = true;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        MergeListener.this.view = (MergeResultsView)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.collabnet.subversion.merge.views.MergeResultsView");
                        MergeListener.this.view.getTreeViewer().setExpandedState((Object)MergeListener.this.mergeOutput, true);
                    }
                    catch (PartInitException e) {
                        Activator.handleError((Exception)((Object)e));
                    }
                }
            });
        }
        if (this.view != null) {
            this.view.refreshAsync(this.mergeOutput);
        }
        MergeOutput.setInProgress(false);
    }
}

