/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import com.collabnet.subversion.merge.MergeListener;
import com.collabnet.subversion.merge.MergeOptions;
import com.collabnet.subversion.merge.MergeOutput;
import com.collabnet.subversion.merge.SVNConflictResolver;
import java.io.File;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationProgressNotifyListener;
import org.tigris.subversion.subclipse.core.client.OperationResourceCollector;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.SVNUrlWithPegRevision;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNConflictResolver;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MergeCommand
implements ISVNCommand {
    private IResource resource;
    private SVNUrl svnUrl1;
    private SVNUrl svnUrl2;
    private SVNRevision svnRevision1;
    private SVNRevision svnRevision2;
    private SVNRevisionRange[] revisions;
    private boolean reintegrate = false;
    private boolean force = false;
    private boolean ignoreAncestry = false;
    private int depth = 5;
    private boolean recordOnly = false;
    private int textConflictHandling;
    private int binaryConflictHandling;
    private int propertyConflictHandling;
    private MergeOutput mergeOutput;
    private IWorkbenchPart part;
    private boolean mergeAborted;
    private String errorMessage;
    private OperationResourceCollector operationResourceCollector = new OperationResourceCollector();

    public MergeCommand(IResource resource, SVNUrl svnUrl1, SVNRevision svnRevision1, SVNUrl svnUrl2, SVNRevision svnRevision2, SVNRevisionRange[] revisions, MergeOutput mergeOutput) {
        this.resource = resource;
        this.svnUrl1 = svnUrl1;
        this.svnRevision1 = svnRevision1;
        this.svnUrl2 = svnUrl2;
        this.svnRevision2 = svnRevision2;
        this.revisions = revisions;
        this.mergeOutput = mergeOutput;
    }

    public void run(IProgressMonitor monitor) throws SVNException {
        this.mergeAborted = false;
        MergeListener mergeListener = null;
        ISVNClientAdapter svnClient = null;
        ISVNRepositoryLocation repository = null;
        try {
            try {
                monitor.beginTask(null, 100);
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource);
                repository = svnResource.getRepository();
                svnClient = repository.getSVNClient();
                SVNConflictResolver conflictResolver = new SVNConflictResolver(this.resource, this.textConflictHandling, this.binaryConflictHandling, this.propertyConflictHandling);
                conflictResolver.setPart(this.part);
                svnClient.addConflictResolutionCallback((ISVNConflictResolver)conflictResolver);
                MergeOptions mergeOptions = new MergeOptions();
                mergeOptions.setFromUrl(this.svnUrl1);
                mergeOptions.setFromRevision(this.svnRevision1);
                mergeOptions.setToUrl(this.svnUrl2);
                mergeOptions.setToRevision(this.svnRevision2);
                mergeOptions.setRevisions(this.revisions);
                mergeOptions.setForce(this.force);
                mergeOptions.setIgnoreAncestry(this.ignoreAncestry);
                mergeOptions.setDepth(this.depth);
                mergeListener = new MergeListener(this.resource, mergeOptions, conflictResolver, this.mergeOutput);
                svnClient.addNotifyListener((ISVNNotifyListener)mergeListener);
                svnClient.addNotifyListener((ISVNNotifyListener)this.operationResourceCollector);
                OperationManager.getInstance().beginOperation(svnClient, new OperationProgressNotifyListener(monitor));
                monitor.subTask(this.resource.getName());
                File file = this.resource.getLocation().toFile();
                if (this.reintegrate) {
                    SVNUrlWithPegRevision svnUrlWithPegRevision = new SVNUrlWithPegRevision(this.svnUrl1);
                    SVNRevision pegRevision = svnUrlWithPegRevision.getPegRevision();
                    if (pegRevision == null) {
                        pegRevision = this.svnRevision1;
                    }
                    svnClient.mergeReintegrate(svnUrlWithPegRevision.getUrl(), pegRevision, file, this.force, false);
                } else if (this.revisions == null) {
                    svnClient.merge(this.svnUrl1, this.svnRevision1, this.svnUrl2, this.svnRevision2, file, this.force, this.depth, false, this.ignoreAncestry, this.recordOnly);
                } else {
                    SVNUrlWithPegRevision svnUrlWithPegRevision = new SVNUrlWithPegRevision(this.svnUrl1);
                    SVNRevision pegRevision = svnUrlWithPegRevision.getPegRevision();
                    if (pegRevision == null) {
                        pegRevision = SVNRevision.HEAD;
                    }
                    svnClient.merge(svnUrlWithPegRevision.getUrl(), pegRevision, this.revisions, file, this.force, this.depth, this.ignoreAncestry, false, this.recordOnly);
                }
                monitor.worked(100);
            }
            catch (SVNClientException e) {
                if (e.getAprError() != 155015) {
                    throw SVNException.wrapException((Exception)((Object)e));
                }
                this.mergeAborted = true;
                this.errorMessage = e.getCause().getLocalizedMessage().replaceAll("\n", " ");
                if (mergeListener != null) {
                    this.mergeOutput = mergeListener.getMergeOutput();
                }
                Set operationResources = this.operationResourceCollector.getOperationResources();
                OperationManager.getInstance().endOperation(true, operationResources);
                monitor.done();
                svnClient.removeNotifyListener((ISVNNotifyListener)mergeListener);
                svnClient.removeNotifyListener((ISVNNotifyListener)this.operationResourceCollector);
                svnClient.addConflictResolutionCallback(null);
                if (repository != null) {
                    repository.returnSVNClient(svnClient);
                }
            }
        }
        finally {
            if (mergeListener != null) {
                this.mergeOutput = mergeListener.getMergeOutput();
            }
            Set operationResources = this.operationResourceCollector.getOperationResources();
            OperationManager.getInstance().endOperation(true, operationResources);
            monitor.done();
            svnClient.removeNotifyListener((ISVNNotifyListener)mergeListener);
            svnClient.removeNotifyListener((ISVNNotifyListener)this.operationResourceCollector);
            svnClient.addConflictResolutionCallback(null);
            if (repository != null) {
                repository.returnSVNClient(svnClient);
            }
        }
    }

    public void setReintegrate(boolean reintegrate) {
        this.reintegrate = reintegrate;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setIgnoreAncestry(boolean ignoreAncestry) {
        this.ignoreAncestry = ignoreAncestry;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public MergeOutput getMergeOutput() {
        return this.mergeOutput;
    }

    public void setTextConflictHandling(int textConflictHandling) {
        this.textConflictHandling = textConflictHandling;
    }

    public void setBinaryConflictHandling(int binaryConflictHandling) {
        this.binaryConflictHandling = binaryConflictHandling;
    }

    public void setPropertyConflictHandling(int propertyConflictHandling) {
        this.propertyConflictHandling = propertyConflictHandling;
    }

    public void setPart(IWorkbenchPart part) {
        this.part = part;
    }

    public boolean isMergeAborted() {
        return this.mergeAborted;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setRecordOnly(boolean recordOnly) {
        this.recordOnly = recordOnly;
    }
}

