/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.outline.node;

import com.boothen.jsonedit.core.model.jsonnode.JsonNode;
import com.boothen.jsonedit.core.model.jsonnode.JsonType;
import com.boothen.jsonedit.core.model.node.Node;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class JsonTreeNode {
    private JsonNode jsonNode;
    private JsonTreeNode parent;
    private boolean textSelection;
    private Image image;
    private static final Map<JsonType, String> imageMap = new HashMap<JsonType, String>();
    private static final Map<JsonType, StyledString.Styler> styleMap = new HashMap<JsonType, StyledString.Styler>();
    private List<JsonTreeNode> children = new LinkedList<JsonTreeNode>();

    static {
        imageMap.put(JsonType.Array, "/icons/JsonArray.gif");
        imageMap.put(JsonType.Object, "/icons/JsonObject.gif");
        imageMap.put(JsonType.True, "/icons/JsonBoolean.gif");
        imageMap.put(JsonType.False, "/icons/JsonBoolean.gif");
        imageMap.put(JsonType.Value, "/icons/JsonNumber.gif");
        imageMap.put(JsonType.Null, "/icons/JsonNull.gif");
        imageMap.put(JsonType.String, "/icons/JsonString.gif");
        imageMap.put(JsonType.Error, "/icons/JsonError.gif");
        styleMap.put(JsonType.String, StyledString.createColorRegistryStyler((String)"GREEN", (String)"WHITE"));
        styleMap.put(JsonType.True, StyledString.createColorRegistryStyler((String)"BLACK", (String)"WHITE"));
        styleMap.put(JsonType.False, StyledString.createColorRegistryStyler((String)"BLACK", (String)"WHITE"));
        styleMap.put(JsonType.Error, StyledString.createColorRegistryStyler((String)"RED", (String)"WHITE"));
        styleMap.put(JsonType.Value, StyledString.createColorRegistryStyler((String)"BLUE", (String)"WHITE"));
        styleMap.put(JsonType.Null, StyledString.createColorRegistryStyler((String)"BLUE", (String)"WHITE"));
        styleMap.put(JsonType.Object, StyledString.createColorRegistryStyler((String)"BLUE", (String)"WHITE"));
        styleMap.put(JsonType.Array, StyledString.createColorRegistryStyler((String)"BLUE", (String)"WHITE"));
    }

    public JsonTreeNode(JsonNode jsonNode, JsonTreeNode parent) {
        this.jsonNode = jsonNode;
        this.parent = parent;
    }

    public void removeEntry(JsonTreeNode jsonTreeNode) {
        this.children.remove(jsonTreeNode);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void clearChildren() {
        this.children.clear();
    }

    public List<JsonTreeNode> getChildren() {
        return this.children;
    }

    public void addChild(JsonTreeNode jsonTreeNode) {
        this.children.add(jsonTreeNode);
    }

    public void setParent(JsonTreeNode parent) {
        this.parent = parent;
    }

    public JsonTreeNode getParent() {
        return this.parent;
    }

    public void removeFromParent() {
        if (this.getParent() != null) {
            this.getParent().removeEntry(this);
        }
    }

    public boolean isTextSelection() {
        return this.textSelection;
    }

    public void setTextSelection(boolean textSelection) {
        this.textSelection = textSelection;
    }

    public StyledString getStyledString() {
        StyledString styledString = new StyledString();
        if (this.jsonNode.getKey() != null) {
            StyledString.Styler style1 = StyledString.createColorRegistryStyler((String)"BLACK", (String)"WHITE");
            styledString.append(this.jsonNode.getKey().getValue(), style1);
            StyledString.Styler style2 = StyledString.createColorRegistryStyler((String)"BLACK", (String)"WHITE");
            styledString.append(" : ", style2);
        }
        if (this.jsonNode.getValue() != null && this.jsonNode.getJsonType() != JsonType.Object && this.jsonNode.getJsonType() != JsonType.Array) {
            StyledString.Styler style3 = styleMap.get(this.jsonNode.getJsonType());
            styledString.append(this.jsonNode.getValue().getValue(), style3);
        }
        return styledString;
    }

    public Image getImage() {
        if (this.image != null) {
            return this.image;
        }
        this.image = this.createMyImage(imageMap.get(this.jsonNode.getJsonType()));
        return this.image;
    }

    private Image createMyImage(String urlPath) {
        URL resource = JsonTreeNode.class.getResource(urlPath);
        ImageDescriptor imgDescriptor = ImageDescriptor.createFromURL((URL)resource);
        if (imgDescriptor == null) {
            return null;
        }
        return imgDescriptor.createImage();
    }

    public int getStart() {
        Node startNode = this.jsonNode.getKey();
        if (startNode == null) {
            startNode = this.jsonNode.getValue();
        }
        return startNode.getStart();
    }

    public int getLength() {
        Node endNode;
        Node startNode = this.jsonNode.getKey();
        if (startNode == null) {
            startNode = this.jsonNode.getValue();
        }
        if ((endNode = this.jsonNode.getValue()) == null) {
            endNode = this.jsonNode.getKey();
        }
        return endNode.getEnd() - startNode.getStart();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.jsonNode == null ? 0 : this.jsonNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonTreeNode other = (JsonTreeNode)obj;
        return !(this.jsonNode == null ? other.jsonNode != null : !this.jsonNode.equals((Object)other.jsonNode));
    }

    public JsonNode getJsonNode() {
        return this.jsonNode;
    }

    public void setJsonNode(JsonNode jsonNode) {
        this.image = null;
        this.jsonNode = jsonNode;
    }
}

