/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.outline;

import com.boothen.jsonedit.core.model.jsonnode.JsonNode;
import com.boothen.jsonedit.outline.JsonModelOutlineParser;
import com.boothen.jsonedit.outline.node.JsonTreeNode;
import java.util.List;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class JsonContentProvider
implements ITreeContentProvider {
    protected IDocumentProvider fDocumentProvider;
    protected Object fInput;
    protected JsonTreeNode rootObject;
    public static final String JSON_ELEMENTS = "__json_elements";
    protected IPositionUpdater fPositionUpdater = new DefaultPositionUpdater("__json_elements");
    protected List<JsonNode> jsonNodes;

    protected void parse(IDocument document) {
        this.rootObject = new JsonModelOutlineParser().mergeNodes(this.rootObject, this.jsonNodes);
    }

    public JsonContentProvider(IDocumentProvider documentProvider) {
        this.fDocumentProvider = documentProvider;
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    public void setJsonNodes(List<JsonNode> jsonNodes) {
        this.jsonNodes = jsonNodes;
        this.rootObject = new JsonModelOutlineParser().mergeNodes(this.rootObject, jsonNodes);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement == this.fInput) {
            Object[] objectArray;
            if (this.rootObject != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.rootObject;
            } else {
                objectArray = new Object[]{};
            }
            return objectArray;
        }
        if (parentElement instanceof JsonTreeNode) {
            return ((JsonTreeNode)parentElement).getChildren().toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element == this.rootObject) {
            return this.fInput;
        }
        if (element instanceof JsonTreeNode) {
            return ((JsonTreeNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element == this.fInput) {
            return this.rootObject != null;
        }
        if (element instanceof JsonTreeNode) {
            return ((JsonTreeNode)element).hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == this.fInput) {
            Object[] objectArray;
            if (this.rootObject != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.rootObject;
            } else {
                objectArray = new Object[]{};
            }
            return objectArray;
        }
        return null;
    }

    public void dispose() {
        if (this.rootObject != null) {
            this.rootObject = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        IDocument document;
        if (oldInput != null && (document = this.fDocumentProvider.getDocument(oldInput)) != null) {
            try {
                document.removePositionCategory(JSON_ELEMENTS);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            document.removePositionUpdater(this.fPositionUpdater);
        }
        this.rootObject = null;
        if (newInput != null && (document = this.fDocumentProvider.getDocument(newInput)) != null) {
            document.addPositionCategory(JSON_ELEMENTS);
            document.addPositionUpdater(this.fPositionUpdater);
            this.parse(document);
        }
    }

    public JsonTreeNode findNearestElement(int start, int length) {
        if (this.rootObject == null) {
            return null;
        }
        return this.findNearestElement(this.rootObject, start, length);
    }

    private JsonTreeNode findNearestElement(JsonTreeNode parent, int start, int length) {
        JsonTreeNode previous = null;
        boolean found = false;
        if (parent.getChildren().size() == 0) {
            return parent;
        }
        for (JsonTreeNode jsonTreeNode : parent.getChildren()) {
            if (start < jsonTreeNode.getStart()) {
                found = true;
                if (previous != null) {
                    previous = this.findNearestElement(previous, start, length);
                    break;
                }
                previous = parent;
                break;
            }
            previous = jsonTreeNode;
        }
        if (!found) {
            previous = this.findNearestElement(previous, start, length);
        }
        return previous;
    }
}

