/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.text;

public class JsonTextFormatter {
    private String indent = "   ";
    private int indentLength = 3;
    private String carriageReturn;
    private int returnLength;
    private String unformattedText;

    public JsonTextFormatter(String text, boolean spaces, int numSpaces, String carriageReturn) {
        this.unformattedText = text;
        this.carriageReturn = carriageReturn;
        this.returnLength = carriageReturn.length();
        this.initPreferences(spaces, numSpaces);
    }

    private void initPreferences(boolean spaces, int numSpaces) {
        int n = this.indentLength = spaces ? numSpaces : 1;
        if (spaces) {
            StringBuffer strBuf = new StringBuffer();
            int i = 0;
            while (i < numSpaces) {
                strBuf.append(" ");
                ++i;
            }
            this.indent = strBuf.toString();
        } else {
            this.indent = "\t";
        }
    }

    public String formatText() {
        StringBuilder doc = new StringBuilder(this.unformattedText);
        try {
            int indentCount = 0;
            boolean key = false;
            int i = 0;
            while (i < doc.length()) {
                char ch = doc.charAt(i);
                if (ch == '\"' && doc.charAt(i - 1) != '\\') {
                    boolean bl = key = !key;
                }
                if (key) {
                    ++i;
                    continue;
                }
                switch (ch) {
                    case '{': {
                        doc.replace(i, i + 1, "{" + this.carriageReturn + this.indent(++indentCount));
                        i += this.returnLength + indentCount * this.indentLength;
                        break;
                    }
                    case '}': {
                        doc.replace(i, i + 1, String.valueOf(this.carriageReturn) + this.indent(--indentCount) + "}");
                        if (doc.charAt((i += this.returnLength + indentCount * this.indentLength) + 1) == ',' || !this.notBracket(doc, i + 1)) break;
                        doc.replace(i + 1, i + 1, String.valueOf(this.carriageReturn) + this.indent(indentCount));
                        i += this.returnLength + indentCount * this.indentLength;
                        break;
                    }
                    case ',': {
                        doc.replace(i, i + 1, "," + this.carriageReturn + this.indent(indentCount));
                        i += this.returnLength + indentCount * this.indentLength;
                        break;
                    }
                    case '[': {
                        doc.replace(i, i + 1, "[" + this.carriageReturn + this.indent(++indentCount));
                        i += this.returnLength + indentCount * this.indentLength;
                        break;
                    }
                    case ']': {
                        doc.replace(i, i + 1, String.valueOf(this.carriageReturn) + this.indent(--indentCount) + "]");
                        if (doc.charAt((i += this.returnLength + indentCount * this.indentLength) + 1) == ',' || !this.notBracket(doc, i + 1)) break;
                        doc.replace(i + 1, i + 1, String.valueOf(this.carriageReturn) + this.indent(indentCount));
                        i += this.returnLength + indentCount * this.indentLength;
                        break;
                    }
                    case ' ': {
                        doc.replace(i, i + 1, "");
                        --i;
                        break;
                    }
                    case '\n': {
                        doc.replace(i, i + 1, "");
                        --i;
                        break;
                    }
                    case '\r': {
                        doc.replace(i, i + 1, "");
                        --i;
                        break;
                    }
                    case '\t': {
                        doc.replace(i, i + 1, "");
                        --i;
                        break;
                    }
                    case '\\': {
                        if (doc.charAt(i + 1) != '\"') break;
                        ++i;
                    }
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return doc.toString();
    }

    private boolean notBracket(StringBuilder doc, int pos) {
        int i = pos;
        while (i < doc.length()) {
            if (doc.charAt(i) != ' ' && doc.charAt(i) != '\n' && doc.charAt(i) != '\r') {
                return doc.charAt(i) != '}' && doc.charAt(i) != ']';
            }
            doc.replace(i, i + 1, "");
            --i;
            ++i;
        }
        return false;
    }

    private String indent(int count) {
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < count) {
            ret.append(this.indent);
            ++i;
        }
        return ret.toString();
    }
}

