/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.text;

import com.boothen.jsonedit.coloring.JsonColorProvider;
import com.boothen.jsonedit.preferences.JsonPreferenceStore;
import com.boothen.jsonedit.text.detector.JsonWhitespaceDetector;
import com.boothen.jsonedit.text.detector.JsonWordDetector;
import java.util.LinkedList;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;

public class JsonScanner
extends RuleBasedScanner {
    private JsonColorProvider jsonColorProvider = new JsonColorProvider();

    public JsonScanner() {
        this.initScanner();
    }

    public void reinitScanner() {
        this.initScanner();
    }

    private void initScanner() {
        Token string = new Token((Object)new TextAttribute(this.getPreferenceColor("stringColor")));
        Token value = new Token((Object)new TextAttribute(this.getPreferenceColor("valueColor")));
        Token defaultText = new Token((Object)new TextAttribute(this.getPreferenceColor("defaultColor")));
        Token nullValue = new Token((Object)new TextAttribute(this.getPreferenceColor("nullColor")));
        LinkedList<Object> rules = new LinkedList<Object>();
        rules.add(new MultiLineRule(":\"", "\"", (IToken)value, '\\'));
        rules.add(new MultiLineRule("\"", "\"", (IToken)string, '\\'));
        WordRule wordRule = new WordRule((IWordDetector)new JsonWordDetector(), (IToken)defaultText);
        wordRule.addWord("null", (IToken)nullValue);
        rules.add(wordRule);
        rules.add(new WhitespaceRule((IWhitespaceDetector)new JsonWhitespaceDetector()));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    private Color getPreferenceColor(String preferenceValue) {
        return this.jsonColorProvider.getColor(StringConverter.asRGB((String)JsonPreferenceStore.getIPreferenceStore().getString(preferenceValue)));
    }
}

