/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class JsonIndentLineAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    private String indent;
    private String lineEnding;

    public JsonIndentLineAutoEditStrategy(boolean spaces, int numSpaces, String lineEnding) {
        this.initPreferences(spaces, numSpaces, lineEnding);
    }

    protected int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (!Character.isWhitespace(c)) {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    private int findPreviousBracket(IDocument document, int offset) throws BadLocationException {
        while (offset >= 0) {
            char c = document.getChar(offset);
            if (!Character.isWhitespace(c)) {
                if (c == '{' || c == '[') {
                    return offset;
                }
                return -1;
            }
            --offset;
        }
        return -1;
    }

    private boolean isNextBracket(IDocument document, int offset, char bracket) throws BadLocationException {
        while (offset < document.getLength()) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return c == bracket;
            }
            ++offset;
        }
        return false;
    }

    private void autoIndentAfterNewLine(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int bracketPos;
            int start = this.findStartOfCurrentLine(d, c);
            int end = this.findEndOfWhiteSpace(d, start, c.offset);
            StringBuffer buf = new StringBuffer(c.text);
            if (end > start) {
                buf.append(d.get(start, end - start));
            }
            if ((bracketPos = this.findPreviousBracket(d, c.offset - 1)) != -1) {
                buf.append(this.indent);
                char ch = this.determineBracketType(d, bracketPos);
                if (!this.isNextBracket(d, c.offset, ch)) {
                    d.replace(c.offset, 0, String.valueOf(this.lineEnding) + d.get(start, end - start) + ch);
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    private char determineBracketType(IDocument d, int bracketPos) throws BadLocationException {
        char ch = ']';
        if (d.getChar(bracketPos) == '{') {
            ch = '}';
        }
        return ch;
    }

    private int findStartOfCurrentLine(IDocument d, DocumentCommand c) throws BadLocationException {
        int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
        IRegion info = d.getLineInformationOfOffset(p);
        int start = info.getOffset();
        return start;
    }

    public void initPreferences(boolean spaces, int numSpaces, String lineEnding) {
        this.lineEnding = lineEnding;
        if (spaces) {
            StringBuffer strBuf = new StringBuffer();
            int i = 0;
            while (i < numSpaces) {
                strBuf.append(" ");
                ++i;
            }
            this.indent = strBuf.toString();
        } else {
            this.indent = "\t";
        }
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.length == 0 && c.text != null && TextUtilities.endsWith((String[])d.getLegalLineDelimiters(), (String)c.text) != -1) {
            this.autoIndentAfterNewLine(d, c);
        }
    }
}

