/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.ast.parser;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.ccdt.common.search.source.LuaSearchPath;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.ast.parser.AbstractSourceParser;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.koneki.ldt.core.LuaUtils;
import org.eclipse.koneki.ldt.core.internal.Activator;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaDLTKModelUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Item;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.LuaFileAPI;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaASTNode;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Block;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Identifier;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Index;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Invoke;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaExpression;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaInternalContent;
import org.eclipse.koneki.ldt.core.internal.ast.parser.AdvancedParserExtend;
import org.eclipse.koneki.ldt.core.internal.ast.parser.EncodingVisitor;
import org.eclipse.koneki.ldt.core.internal.ast.parser.ModelsBuilderLuaModule;
import org.eclipse.koneki.ldt.core.internal.ast.parser.OffsetFixer;
import org.eclipse.osgi.util.NLS;

public class LuaSourceParser
extends AbstractSourceParser {
    private static ModelsBuilderLuaModule astBuilder = new ModelsBuilderLuaModule();
    private static final String[] SEARCH_PATH_METHODS = new String[]{"addSearchPath"};
    private static final String INVOKE_GETINSTANDE = "getInstance";
    private static final String INDEX_LEFT = "cc";
    private static final String INDEX_RIGHT = "FileUtils";
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static Map<IModelElement, IModuleDeclaration> cache = new Hashtable<IModelElement, IModuleDeclaration>();
    private static IElementChangedListener changedListener = new IElementChangedListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void elementChanged(ElementChangedEvent event) {
            Class<LuaSourceParser> clazz = LuaSourceParser.class;
            synchronized (LuaSourceParser.class) {
                IModelElementDelta delta = event.getDelta();
                this.processDelta(delta);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        private void processDelta(IModelElementDelta delta) {
            IModelElement element = delta.getElement();
            if (element.getElementType() == 5) {
                if (delta.getKind() == 2) {
                    cache.remove(element);
                } else if (delta.getKind() == 4 && delta.getFlags() == 65536) {
                    cache.remove(element);
                }
            }
            if (delta.getFlags() == 128 && delta.getAffectedChildren().length == 0) {
                for (IModelElement sourcemodule : new ArrayList(cache.keySet())) {
                    if (!LuaDLTKModelUtils.isAncestor(sourcemodule, element)) continue;
                    cache.remove(sourcemodule);
                }
            }
            if ((delta.getFlags() & 8) != 0) {
                IModelElementDelta[] affectedChildren = delta.getAffectedChildren();
                int i = 0;
                while (i < affectedChildren.length) {
                    IModelElementDelta child = affectedChildren[i];
                    this.processDelta(child);
                    ++i;
                }
            }
        }
    };

    static {
        DLTKCore.addElementChangedListener((IElementChangedListener)changedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModuleDeclaration parse(IModuleSource input, IProblemReporter reporter) {
        String source = input.getSourceContents();
        String moduleName = LuaUtils.getModuleFullName(input);
        LuaSourceRoot module = new LuaSourceRoot(source.length());
        OffsetFixer fixer = new OffsetFixer(source);
        Class<LuaSourceParser> clazz = LuaSourceParser.class;
        synchronized (LuaSourceParser.class) {
            try {
                module = astBuilder.buildAST(source, moduleName);
                if (module != null) {
                    module.traverse(new EncodingVisitor(fixer));
                }
            }
            catch (Exception e) {
                Activator.logWarning(NLS.bind((String)"Unable to parse file {0}.", (Object)input.getFileName()), e);
                if (module == null) {
                    module = new LuaSourceRoot(source.length());
                }
                module.setProblem(1, 1, 0, 0, "This file probably contains a syntax error.");
            }
            if (module != null) {
                if (module.hasError()) {
                    DefaultProblem problem = module.getProblem();
                    problem.setOriginatingFileName(input.getFileName());
                    reporter.reportProblem((IProblem)problem);
                    if (problem.getSourceEnd() < 0) {
                        try {
                            int line = problem.getSourceLineNumber();
                            Document document = new Document(source);
                            int endLineOffset = document.getLineOffset(line) + document.getLineLength(line) - 1;
                            problem.setSourceStart(fixer.getCharacterPosition(problem.getSourceStart()));
                            problem.setSourceEnd(endLineOffset);
                        }
                        catch (BadLocationException e) {
                            Activator.logWarning("Unable to retrive error offset", e);
                        }
                    } else {
                        problem.setSourceStart(fixer.getCharacterPosition(problem.getSourceStart()));
                        problem.setSourceEnd(fixer.getCharacterPosition(problem.getSourceEnd()));
                    }
                    if (input.getModelElement() != null) {
                        if (module.getFileapi() == null || module.getInternalContent() == null) {
                            LuaSourceRoot cached = (LuaSourceRoot)cache.get(input.getModelElement());
                            if (cached != null) {
                                cached.setError(true);
                                // ** MonitorExit[var7_7] (shouldn't be in output)
                                return cached;
                            }
                            module.setLuaFileApi(new LuaFileAPI());
                            module.setInternalContent(new LuaInternalContent());
                        } else {
                            cache.put(input.getModelElement(), (IModuleDeclaration)module);
                        }
                    }
                } else if (input.getModelElement() != null) {
                    cache.put(input.getModelElement(), (IModuleDeclaration)module);
                }
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            if (module != null) {
                AdvancedParserExtend.parseSetmetatableMethod(input, module);
                LuaSourceParser.findSearchPath(input, module);
            }
            return module;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModuleDeclaration parse(IModuleSource input, IProblemReporter reporter, String itemName, int itemStart, boolean isCompletion) {
        String source = input.getSourceContents();
        String moduleName = LuaUtils.getModuleFullName(input);
        LuaSourceRoot module = new LuaSourceRoot(source.length());
        OffsetFixer fixer = new OffsetFixer(source);
        Class<LuaSourceParser> clazz = LuaSourceParser.class;
        synchronized (LuaSourceParser.class) {
            try {
                module = astBuilder.buildAST(source, moduleName, itemName, itemStart, isCompletion);
                if (module != null) {
                    module.traverse(new EncodingVisitor(fixer));
                }
            }
            catch (Exception e) {
                Activator.logWarning(NLS.bind((String)"Unable to parse file {0}.", (Object)input.getFileName()), e);
                if (module == null) {
                    module = new LuaSourceRoot(source.length());
                }
                module.setProblem(1, 1, 0, 0, "This file probably contains a syntax error.");
            }
            if (module != null) {
                if (module.hasError()) {
                    DefaultProblem problem = module.getProblem();
                    problem.setOriginatingFileName(input.getFileName());
                    reporter.reportProblem((IProblem)problem);
                    if (problem.getSourceEnd() < 0) {
                        try {
                            int line = problem.getSourceLineNumber();
                            Document document = new Document(source);
                            int endLineOffset = document.getLineOffset(line) + document.getLineLength(line) - 1;
                            problem.setSourceStart(fixer.getCharacterPosition(problem.getSourceStart()));
                            problem.setSourceEnd(endLineOffset);
                        }
                        catch (BadLocationException e) {
                            Activator.logWarning("Unable to retrive error offset", e);
                        }
                    } else {
                        problem.setSourceStart(fixer.getCharacterPosition(problem.getSourceStart()));
                        problem.setSourceEnd(fixer.getCharacterPosition(problem.getSourceEnd()));
                    }
                    if (input.getModelElement() != null) {
                        if (module.getFileapi() == null || module.getInternalContent() == null) {
                            LuaSourceRoot cached = (LuaSourceRoot)cache.get(input.getModelElement());
                            if (cached != null) {
                                cached.setError(true);
                                // ** MonitorExit[var10_10] (shouldn't be in output)
                                return cached;
                            }
                            module.setLuaFileApi(new LuaFileAPI());
                            module.setInternalContent(new LuaInternalContent());
                        } else {
                            cache.put(input.getModelElement(), (IModuleDeclaration)module);
                        }
                    }
                } else if (input.getModelElement() != null) {
                    cache.put(input.getModelElement(), (IModuleDeclaration)module);
                }
            }
            // ** MonitorExit[var10_10] (shouldn't be in output)
            return module;
        }
    }

    private static void findSearchPath(IModuleSource input, LuaSourceRoot luaSourceRoot) {
        LuaInternalContent luaInternalContent = luaSourceRoot.getInternalContent();
        Block block = luaInternalContent.getContent();
        IResource resource = input.getModelElement().getResource();
        ArrayList<String> searchPaths = new ArrayList<String>();
        String sourceContent = input.getSourceContents();
        Document document = new Document(sourceContent);
        searchPaths.addAll(LuaSourceParser.findPathAtBlock(document, block));
        if (searchPaths.size() == 0) {
            LuaSearchPath.hasResource((IResource)resource);
            LuaSearchPath.removePath((IResource)resource);
        } else {
            LuaSearchPath.putPath((IResource)resource, searchPaths);
        }
    }

    private static List<String> findPathAtBlock(Document document, Block block) {
        ArrayList<String> searchPaths = new ArrayList<String>();
        List<LuaASTNode> nodeList = block.getContent();
        int i = 0;
        while (i < nodeList.size()) {
            LuaASTNode luaASTNode = nodeList.get(i);
            if (luaASTNode instanceof Invoke) {
                Invoke invoke = (Invoke)luaASTNode;
                if (LuaSourceParser.isSearchPath(invoke)) {
                    int start = luaASTNode.sourceStart();
                    int end = luaASTNode.sourceEnd();
                    try {
                        String content = document.get(start, end - start);
                        String path = LuaSourceParser.getPath(content);
                        if (path != null) {
                            searchPaths.add(path);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            } else if (luaASTNode instanceof Block) {
                Block childBlock = (Block)luaASTNode;
                searchPaths.addAll(LuaSourceParser.findPathAtBlock(document, childBlock));
            }
            ++i;
        }
        return searchPaths;
    }

    private static boolean isSearchPath(Invoke invoke) {
        if (invoke == null) {
            return false;
        }
        String functionName = invoke.getFunctionName();
        int j = 0;
        while (j < SEARCH_PATH_METHODS.length) {
            String right;
            String itemName;
            Identifier identifier;
            Item item;
            Index index;
            Invoke getInstanceInvoke;
            String getInstanceName;
            LuaExpression express;
            String searchPathMethod = SEARCH_PATH_METHODS[j];
            if (searchPathMethod.equals(functionName) && (express = invoke.getRecord()) instanceof Invoke && INVOKE_GETINSTANDE.equals(getInstanceName = (getInstanceInvoke = (Invoke)express).getFunctionName()) && (express = getInstanceInvoke.getRecord()) instanceof Index && (express = (index = (Index)express).getLeft()) instanceof Identifier && (item = (identifier = (Identifier)express).getDefinition()) != null && INDEX_LEFT.equals(itemName = item.getName()) && INDEX_RIGHT.equals(right = index.getRight())) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private static String getPath(String content) {
        if (content == null) {
            return null;
        }
        String path = null;
        int firstQuote = content.indexOf(SINGLE_QUOTE);
        int lastQuote = content.lastIndexOf(SINGLE_QUOTE);
        if (firstQuote > -1 && lastQuote > -1 && firstQuote != lastQuote) {
            path = content.substring(firstQuote + 1, lastQuote);
        }
        firstQuote = content.indexOf(DOUBLE_QUOTE);
        lastQuote = content.lastIndexOf(DOUBLE_QUOTE);
        if (firstQuote > -1 && lastQuote > -1 && firstQuote != lastQuote) {
            path = content.substring(firstQuote + 1, lastQuote);
        }
        if (path != null && path.trim().isEmpty()) {
            return null;
        }
        return path;
    }
}

