/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.ast.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.InlineTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Item;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.RecordTypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.TypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.TypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaASTNode;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Block;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Call;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Identifier;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaExpression;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaInternalContent;

public class AdvancedParserExtend {
    private static final String SETMETABLE_METHOD = "setmetatable";

    private AdvancedParserExtend() {
    }

    public static void parseSetmetatableMethod(IModuleSource input, LuaSourceRoot luaSourceRoot) {
        if (luaSourceRoot == null) {
            return;
        }
        List<CallBody> callBodies = AdvancedParserExtend.findSetmetatableCalls(luaSourceRoot);
        int i = 0;
        while (i < callBodies.size()) {
            CallBody callBody = callBodies.get(i);
            AdvancedParserExtend.parseEvaluation(input, luaSourceRoot, callBody);
            ++i;
        }
    }

    private static void parseEvaluation(IModuleSource input, LuaSourceRoot luaSourceRoot, CallBody callBody) {
        RecordTypeDef recordTypeDef;
        HashMap<String, Item> firstFieldMap;
        InlineTypeRef inlineTypeRef;
        TypeDef typeDef;
        InlineTypeRef inlineTypeRef2;
        TypeDef typeDef2;
        if (luaSourceRoot == null) {
            return;
        }
        if (callBody == null) {
            return;
        }
        if (callBody.getCall() == null) {
            return;
        }
        if (!callBody.canEvaluate()) {
            return;
        }
        Identifier firstIdentifier = callBody.getFirstIdentifier();
        Identifier lastIdentifier = callBody.getLastIdentifier();
        HashMap<String, Item> lastFieldMap = null;
        Item lastItem = lastIdentifier.getDefinition();
        TypeRef lastTypeRef = lastItem.getType();
        if (lastTypeRef instanceof InlineTypeRef && (typeDef2 = (inlineTypeRef2 = (InlineTypeRef)lastTypeRef).getDefinition()) instanceof RecordTypeDef) {
            RecordTypeDef recordTypeDef2 = (RecordTypeDef)typeDef2;
            lastFieldMap = recordTypeDef2.getFields();
        }
        if (lastFieldMap == null) {
            return;
        }
        TypeRef firstTypeRef = firstIdentifier.getDefinition().getType();
        if (firstTypeRef instanceof InlineTypeRef && (typeDef = (inlineTypeRef = (InlineTypeRef)firstTypeRef).getDefinition()) instanceof RecordTypeDef && (firstFieldMap = (recordTypeDef = (RecordTypeDef)typeDef).getFields()) != null) {
            firstFieldMap.putAll(lastFieldMap);
        }
    }

    private static List<CallBody> findSetmetatableCalls(LuaSourceRoot luaSourceRoot) {
        ArrayList<CallBody> callBodies = new ArrayList<CallBody>();
        LuaInternalContent luaInternalContent = luaSourceRoot.getInternalContent();
        Block contentBlock = luaInternalContent.getContent();
        List<LuaASTNode> list = contentBlock.getContent();
        int i = 0;
        while (i < list.size()) {
            int end;
            Identifier identifier;
            int start;
            CallBody callBody;
            LuaASTNode luaASTNode = list.get(i);
            if (luaASTNode instanceof Call) {
                String itemName;
                Identifier identifier2;
                Item item;
                Call call = (Call)luaASTNode;
                LuaExpression functionExpression = call.getFunction();
                if (functionExpression instanceof Identifier && (item = (identifier2 = (Identifier)functionExpression).getDefinition()) != null && SETMETABLE_METHOD.equals(itemName = item.getName())) {
                    CallBody callBody2 = new CallBody();
                    callBody2.setCall(call);
                    callBodies.add(callBody2);
                }
            } else if (luaASTNode instanceof Identifier && callBodies.size() > 0 && (callBody = AdvancedParserExtend.getCallBody(callBodies, start = (identifier = (Identifier)luaASTNode).start(), end = identifier.end())) != null) {
                callBody.addIdentifier(identifier);
            }
            ++i;
        }
        return callBodies;
    }

    private static CallBody getCallBody(List<CallBody> callBodies, int start, int end) {
        if (callBodies == null) {
            return null;
        }
        int i = 0;
        while (i < callBodies.size()) {
            CallBody callBody = callBodies.get(i);
            Call call = callBody.getCall();
            if (call != null) {
                int callStart = call.start();
                int callEnd = call.end();
                if (callStart < start && end < callEnd) {
                    return callBody;
                }
            }
            ++i;
        }
        return null;
    }

    private static class CallBody {
        private Call call;
        private Identifier firstIdentifier;
        private Identifier lastIdentifier;

        public Call getCall() {
            return this.call;
        }

        public void setCall(Call call) {
            this.call = call;
        }

        public Identifier getFirstIdentifier() {
            return this.firstIdentifier;
        }

        public Identifier getLastIdentifier() {
            return this.lastIdentifier;
        }

        public void addIdentifier(Identifier identifier) {
            if (identifier == null) {
                return;
            }
            if (this.firstIdentifier != null && this.lastIdentifier != null) {
                return;
            }
            if (this.firstIdentifier == null) {
                this.firstIdentifier = identifier;
            } else if (this.firstIdentifier.end() < identifier.start()) {
                this.lastIdentifier = identifier;
            } else if (identifier.end() < this.firstIdentifier.start()) {
                this.lastIdentifier = this.firstIdentifier;
                this.firstIdentifier = identifier;
            }
        }

        public boolean canEvaluate() {
            return this.firstIdentifier != null && this.lastIdentifier != null && this.firstIdentifier.end() < this.lastIdentifier.start();
        }
    }
}

