/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.ast.models;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.UnknownItem;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Call;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Identifier;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Index;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Invoke;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaExpression;

public class LuaHeuristicScanner {
    public static final int NOT_FOUND = -1;
    public static final int UNBOUND = -2;
    private static final char LBRACE = '{';
    private static final char RBRACE = '}';
    private static final char LBRACKET = '[';
    private static final char RBRACKET = ']';
    private static final char LPAREN = '(';
    private static final char RPAREN = ')';
    private static final char SEMICOLON = ';';
    private static final char COMMA = ',';
    private static final char COLON = ':';
    private static final char DOT = '.';
    private static final char EQUAL = '=';
    private static final char LANGLE = '<';
    private static final char RANGLE = '>';
    private static final char PLUS = '+';
    private static final char MINUS = '-';
    private static final char ASTERISK = '*';
    private static final char SLASH = '/';
    private static final char PERSENT = '%';
    private static final char CARET = '^';
    private static final char SHARP = '#';
    private static final StopCondition FNONWS = new NonWhitespace();
    private final StopCondition fNonWSDefaultPart = new NonWhitespaceDefaultPartition();
    private final StopCondition fNonIdent = new NonJavaIdentifierPartDefaultPartition();
    private final IDocument fDocument;
    private char fChar;
    private int fPos;
    private ITypedRegion fCachedPartition = new TypedRegion(-1, 0, "__no_partition_at_all");

    public LuaHeuristicScanner(IDocument document) {
        Assert.isLegal((document != null ? 1 : 0) != 0);
        this.fDocument = document;
    }

    public int getPosition() {
        return this.fPos;
    }

    public int nextToken(int start, int bound) {
        int pos = this.scanForward(start, bound, this.fNonWSDefaultPart);
        if (pos == -1) {
            return -1;
        }
        ++this.fPos;
        if (this.getPartition(pos).getType().equals("__lua_string")) {
            return 3000;
        }
        switch (this.fChar) {
            case '{': {
                return 1;
            }
            case '}': {
                return 2;
            }
            case '[': {
                return 3;
            }
            case ']': {
                return 4;
            }
            case '(': {
                return 5;
            }
            case ')': {
                return 6;
            }
            case ';': {
                return 7;
            }
            case ',': {
                return 9;
            }
            case '=': {
                return 12;
            }
            case '<': {
                return 13;
            }
            case '>': {
                return 14;
            }
            case '+': {
                return 15;
            }
            case '-': {
                return 16;
            }
            case '#': {
                return 21;
            }
            case '.': {
                return 11;
            }
            case ':': {
                return 10;
            }
            case '*': {
                return 17;
            }
            case '/': {
                return 18;
            }
            case '%': {
                return 19;
            }
            case '^': {
                return 20;
            }
        }
        if (Character.isJavaIdentifierPart(this.fChar)) {
            String identOrKeyword;
            int from = pos;
            int to = (pos = this.scanForward(pos + 1, bound, this.fNonIdent)) == -1 ? (bound == -2 ? this.fDocument.getLength() : bound) : pos;
            try {
                identOrKeyword = this.fDocument.get(from, to - from);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            return this.getToken(identOrKeyword);
        }
        return -2;
    }

    public int previousToken(int start, int bound) {
        int pos = this.scanBackward(start, bound, this.fNonWSDefaultPart);
        if (pos == -1) {
            return -1;
        }
        --this.fPos;
        if (this.getPartition(pos).getType().equals("__lua_string")) {
            return 3000;
        }
        switch (this.fChar) {
            case '{': {
                return 1;
            }
            case '}': {
                return 2;
            }
            case '[': {
                return 3;
            }
            case ']': {
                return 4;
            }
            case '(': {
                return 5;
            }
            case ')': {
                return 6;
            }
            case ';': {
                return 7;
            }
            case ':': {
                return 10;
            }
            case ',': {
                return 9;
            }
            case '=': {
                return 12;
            }
            case '<': {
                return 13;
            }
            case '>': {
                return 14;
            }
            case '+': {
                return 15;
            }
            case '-': {
                return 16;
            }
            case '#': {
                return 21;
            }
            case '.': {
                return 11;
            }
            case '*': {
                return 17;
            }
            case '/': {
                return 18;
            }
            case '%': {
                return 19;
            }
            case '^': {
                return 20;
            }
        }
        if (Character.isJavaIdentifierPart(this.fChar)) {
            String identOrKeyword;
            int to = pos + 1;
            int from = (pos = this.scanBackward(pos - 1, bound, this.fNonIdent)) == -1 ? (bound == -2 ? 0 : bound + 1) : pos + 1;
            try {
                identOrKeyword = this.fDocument.get(from, to - from);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            return this.getToken(identOrKeyword);
        }
        return -2;
    }

    private int getToken(String s) {
        Assert.isNotNull((Object)s);
        switch (s.length()) {
            case 2: {
                if ("if".equals(s)) {
                    return 1009;
                }
                if ("do".equals(s)) {
                    return 1010;
                }
                if (!"or".equals(s)) break;
                return 1031;
            }
            case 3: {
                if ("for".equals(s)) {
                    return 1011;
                }
                if ("end".equals(s)) {
                    return 1019;
                }
                if ("nil".equals(s)) {
                    return 1024;
                }
                if ("and".equals(s)) {
                    return 1032;
                }
                if (!"not".equals(s)) break;
                return 1033;
            }
            case 4: {
                if ("else".equals(s)) {
                    return 1013;
                }
                if ("then".equals(s)) {
                    return 1018;
                }
                if (!"true".equals(s)) break;
                return 1022;
            }
            case 5: {
                if ("break".equals(s)) {
                    return 1015;
                }
                if ("while".equals(s)) {
                    return 1016;
                }
                if ("local".equals(s)) {
                    return 1020;
                }
                if (!"false".equals(s)) break;
                return 1023;
            }
            case 6: {
                if ("return".equals(s)) {
                    return 1017;
                }
                if ("repeat".equals(s)) {
                    return 1012;
                }
                if (!"elseif".equals(s)) break;
                return 1014;
            }
            case 8: {
                if (!"function".equals(s)) break;
                return 1021;
            }
        }
        return 2000;
    }

    public int findNonWhitespaceForward(int position, int bound) {
        return this.scanForward(position, bound, this.fNonWSDefaultPart);
    }

    public int findNonWhitespaceForwardInAnyPartition(int position, int bound) {
        return this.scanForward(position, bound, FNONWS);
    }

    public int findNonWhitespaceBackward(int position, int bound) {
        return this.scanBackward(position, bound, this.fNonWSDefaultPart);
    }

    public int findNonWhitespaceBackwardInAnyPartition(int position, int bound) {
        return this.scanBackward(position, bound, FNONWS);
    }

    public int scanForward(int start, int bound, StopCondition condition) {
        Assert.isLegal((start >= 0 ? 1 : 0) != 0);
        if (bound == -2) {
            bound = this.fDocument.getLength();
        }
        Assert.isLegal((bound <= this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = start;
            while (this.fPos < bound) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (condition.stop(this.fChar, this.fPos, true)) {
                    return this.fPos;
                }
                this.fPos = condition.nextPosition(this.fPos, true);
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanForward(int position, int bound, char ch) {
        return this.scanForward(position, bound, new CharacterMatch(ch));
    }

    public int scanForward(int position, int bound, char[] chars) {
        return this.scanForward(position, bound, new CharacterMatch(chars));
    }

    public int scanBackward(int start, int bound, StopCondition condition) {
        if (bound == -2) {
            bound = -1;
        }
        Assert.isLegal((bound >= -1 ? 1 : 0) != 0);
        Assert.isLegal((start < this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = start;
            while (this.fPos > bound) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (condition.stop(this.fChar, this.fPos, false)) {
                    return this.fPos;
                }
                this.fPos = condition.nextPosition(this.fPos, false);
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanBackward(int position, int bound, char ch) {
        return this.scanBackward(position, bound, new CharacterMatch(ch));
    }

    public int scanBackward(int position, int bound, char[] chars) {
        return this.scanBackward(position, bound, new CharacterMatch(chars));
    }

    public boolean isAcceptedPartition(int position) {
        return this.isAcceptedPartition(this.getPartition(position));
    }

    public boolean isAcceptedPartition(ITypedRegion partition) {
        return "__dftl_partition_content_type".equals(partition.getType()) || "__lua_string".equals(partition.getType());
    }

    private ITypedRegion getPartition(int position) {
        if (!this.contains((IRegion)this.fCachedPartition, position)) {
            Assert.isTrue((position >= 0 ? 1 : 0) != 0);
            Assert.isTrue((position <= this.fDocument.getLength() ? 1 : 0) != 0);
            try {
                this.fCachedPartition = TextUtilities.getPartition((IDocument)this.fDocument, (String)"__lua_partitioning", (int)position, (boolean)false);
            }
            catch (BadLocationException badLocationException) {
                this.fCachedPartition = new TypedRegion(position, 0, "__no_partition_at_all");
            }
        }
        return this.fCachedPartition;
    }

    private boolean contains(IRegion region, int position) {
        int offset = region.getOffset();
        return offset <= position && position < offset + region.getLength();
    }

    public boolean eatForwardBetweenSepartor(int start, int bound, int leftSeparatorToken, int rightSeparatorToken) {
        int position = start;
        int currenttoken = this.nextToken(position, bound);
        if (currenttoken != leftSeparatorToken) {
            return false;
        }
        position = this.getPosition();
        while ((currenttoken = this.nextToken(position, bound)) != rightSeparatorToken) {
            if (currenttoken == leftSeparatorToken ? !this.eatForwardBetweenSepartor(position, bound, leftSeparatorToken, rightSeparatorToken) : currenttoken == -1) {
                return false;
            }
            position = this.getPosition();
        }
        return true;
    }

    public boolean eatBackwardBetweenSepartor(int start, int bound, int leftSeparatorToken, int rightSeparatorToken) {
        int position = start;
        int currenttoken = this.previousToken(position, bound);
        if (currenttoken != rightSeparatorToken) {
            return false;
        }
        position = this.getPosition();
        while ((currenttoken = this.previousToken(position, bound)) != leftSeparatorToken) {
            if (currenttoken == rightSeparatorToken ? !this.eatBackwardBetweenSepartor(position, bound, leftSeparatorToken, rightSeparatorToken) : currenttoken == -1) {
                return false;
            }
            position = this.getPosition();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LuaExpression guessLuaExpression(int start) {
        try {
            int nextToken;
            int position = start - 1;
            boolean stop = false;
            int previousToken = this.previousToken(position, -2);
            if (previousToken == 6) {
                if (!this.eatBackwardBetweenSepartor(position, -2, 5, 6)) {
                    return null;
                }
                previousToken = -2000;
            }
            position = this.getPosition();
            do {
                int currenttoken = this.previousToken(position, -2);
                switch (previousToken) {
                    case -2000: 
                    case 10: 
                    case 11: {
                        if (previousToken == 11 && currenttoken == 11) {
                            ++position;
                            stop = true;
                            break;
                        }
                        if (currenttoken != 6 && currenttoken != 2000) {
                            return null;
                        }
                        if (currenttoken == 6) {
                            if (!this.eatBackwardBetweenSepartor(position, -2, 5, 6)) {
                                return null;
                            }
                            previousToken = -2000;
                        } else {
                            previousToken = currenttoken;
                        }
                        position = this.getPosition();
                        break;
                    }
                    case 2000: {
                        if (currenttoken == 10 || currenttoken == 11) {
                            position = this.getPosition();
                            previousToken = currenttoken;
                            break;
                        }
                        stop = true;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            } while (!stop);
            if ((nextToken = this.nextToken(++position, start)) != 2000) {
                return null;
            }
            String itemname = this.fDocument.get(position, this.getPosition() - position).trim();
            UnknownItem item = new UnknownItem();
            item.setName(itemname);
            Identifier identifier = new Identifier();
            identifier.setDefinition(item);
            identifier.setStart(position);
            identifier.setEnd(this.getPosition());
            stop = false;
            position = this.getPosition();
            LuaExpression exp = identifier;
            do {
                nextToken = this.nextToken(position, start);
                switch (nextToken) {
                    case -1: {
                        stop = true;
                        break;
                    }
                    case 11: {
                        String indexfieldname;
                        position = this.getPosition();
                        nextToken = this.nextToken(this.getPosition(), start);
                        if (nextToken == -1) {
                            indexfieldname = "";
                        } else {
                            if (nextToken != 2000) {
                                return null;
                            }
                            indexfieldname = this.fDocument.get(position, this.getPosition() - position).trim();
                        }
                        Index index = new Index();
                        index.setLeft(exp);
                        index.setRight(indexfieldname);
                        if (nextToken == -1) {
                            index.setIncomplete(true);
                        }
                        exp = index;
                        position = this.getPosition();
                        break;
                    }
                    case 10: {
                        String invokefunctionname;
                        position = this.getPosition();
                        nextToken = this.nextToken(this.getPosition(), start);
                        if (nextToken == -1) {
                            invokefunctionname = "";
                        } else {
                            if (nextToken != 2000) {
                                return null;
                            }
                            invokefunctionname = this.fDocument.get(position, this.getPosition() - position).trim();
                        }
                        Invoke invoke = new Invoke();
                        invoke.setRecord(exp);
                        invoke.setFunctionName(invokefunctionname);
                        position = this.getPosition();
                        nextToken = this.nextToken(this.getPosition(), start);
                        if (nextToken == 5) {
                            if (!this.eatForwardBetweenSepartor(position, start, 5, 6)) {
                                invoke.setIncomplete(true);
                            }
                        } else {
                            if (nextToken != -1) {
                                return null;
                            }
                            invoke.setIncomplete(true);
                        }
                        exp = invoke;
                        position = this.getPosition();
                        break;
                    }
                    case 5: {
                        Call call = new Call();
                        call.setFunction(exp);
                        if (!this.eatForwardBetweenSepartor(position, start, 5, 6)) {
                            call.setIncomplete(true);
                        }
                        exp = call;
                        position = this.getPosition();
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            } while (!stop);
            return exp;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private final class CharacterMatch
    extends StopCondition {
        private final char[] fChars;

        public CharacterMatch(char ch) {
            this(new char[]{ch});
        }

        public CharacterMatch(char[] chars) {
            Assert.isNotNull((Object)chars);
            Assert.isTrue((chars.length > 0 ? 1 : 0) != 0);
            this.fChars = chars;
            Arrays.sort(chars);
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return Arrays.binarySearch(this.fChars, ch) >= 0 && LuaHeuristicScanner.this.isAcceptedPartition(position);
        }

        @Override
        public int nextPosition(int position, boolean forward) {
            ITypedRegion partition = LuaHeuristicScanner.this.getPartition(position);
            if (LuaHeuristicScanner.this.isAcceptedPartition(partition)) {
                return super.nextPosition(position, forward);
            }
            if (forward) {
                int end = partition.getOffset() + partition.getLength();
                if (position < end) {
                    return end;
                }
            } else {
                int offset = partition.getOffset();
                if (position > offset) {
                    return offset - 1;
                }
            }
            return super.nextPosition(position, forward);
        }
    }

    private static class NonJavaIdentifierPart
    extends StopCondition {
        private NonJavaIdentifierPart() {
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return !Character.isJavaIdentifierPart(ch);
        }
    }

    private final class NonJavaIdentifierPartDefaultPartition
    extends NonJavaIdentifierPart {
        private NonJavaIdentifierPartDefaultPartition() {
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) || !LuaHeuristicScanner.this.isAcceptedPartition(position);
        }

        @Override
        public int nextPosition(int position, boolean forward) {
            ITypedRegion partition = LuaHeuristicScanner.this.getPartition(position);
            if (LuaHeuristicScanner.this.isAcceptedPartition(partition)) {
                return super.nextPosition(position, forward);
            }
            if (forward) {
                int end = partition.getOffset() + partition.getLength();
                if (position < end) {
                    return end;
                }
            } else {
                int offset = partition.getOffset();
                if (position > offset) {
                    return offset - 1;
                }
            }
            return super.nextPosition(position, forward);
        }
    }

    private static class NonWhitespace
    extends StopCondition {
        private NonWhitespace() {
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return !Character.isWhitespace(ch);
        }

        /* synthetic */ NonWhitespace(NonWhitespace nonWhitespace, NonWhitespace nonWhitespace2) {
            this();
        }
    }

    private final class NonWhitespaceDefaultPartition
    extends NonWhitespace {
        private NonWhitespaceDefaultPartition() {
            super(null, null);
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) && LuaHeuristicScanner.this.isAcceptedPartition(position);
        }

        @Override
        public int nextPosition(int position, boolean forward) {
            ITypedRegion partition = LuaHeuristicScanner.this.getPartition(position);
            if (LuaHeuristicScanner.this.isAcceptedPartition(partition)) {
                return super.nextPosition(position, forward);
            }
            if (forward) {
                int end = partition.getOffset() + partition.getLength();
                if (position < end) {
                    return end;
                }
            } else {
                int offset = partition.getOffset();
                if (position > offset) {
                    return offset - 1;
                }
            }
            return super.nextPosition(position, forward);
        }
    }

    private static abstract class StopCondition {
        private StopCondition() {
        }

        public abstract boolean stop(char var1, int var2, boolean var3);

        public int nextPosition(int position, boolean forward) {
            return forward ? position + 1 : position - 1;
        }
    }
}

