/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.ast.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.koneki.ldt.core.IProjectSourceVisitor2;
import org.eclipse.koneki.ldt.core.LuaUtils;
import org.eclipse.koneki.ldt.core.internal.Activator;
import org.eclipse.koneki.ldt.core.internal.LuaLanguageToolkit;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTModelUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaHeuristicScanner;
import org.eclipse.koneki.ldt.core.internal.ast.models.MatchNodeVisitor;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.ExprTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.ExternalTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.FunctionTypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.InlineTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.InternalTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Item;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.LuaFileAPI;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.ModuleTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.PrimitiveTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.RecordTypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Return;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.TypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.TypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.UnknownItem;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaASTNode;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Block;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Call;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Identifier;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Index;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Invoke;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LocalVar;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaExpression;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaInternalContent;

public final class LuaASTUtils {
    private static final String LUA_EXT = ".lua";
    private static final String FUNCTION_NEW = "new";
    private static final String PARENT_MODULE = "@parent_module";
    private static final String EXTEND = "@extend";
    private static final String RETURN = "@return";
    private static final String FUNCTION_CLASS = "class";
    private static final String FUNCTION_REQUIRE = "require";
    private static LuaASTNode luaASTNode;

    private LuaASTUtils() {
    }

    public static Item getClosestLocalVar(LuaSourceRoot luaSourceRoot, String identifierName, int position) {
        try {
            ClosestItemVisitor closestItemVisitor = new ClosestItemVisitor(position, identifierName);
            luaSourceRoot.getInternalContent().getContent().traverse(closestItemVisitor);
            return closestItemVisitor.getResult();
        }
        catch (Exception e) {
            Activator.logError("unable to collect local var", e);
            return null;
        }
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, TypeRef typeRef) {
        if (typeRef instanceof PrimitiveTypeRef) {
            return LuaASTUtils.resolveType(sourceModule, (PrimitiveTypeRef)typeRef);
        }
        if (typeRef instanceof InternalTypeRef) {
            return LuaASTUtils.resolveType(sourceModule, (InternalTypeRef)typeRef);
        }
        if (typeRef instanceof ExternalTypeRef) {
            return LuaASTUtils.resolveType(sourceModule, (ExternalTypeRef)typeRef);
        }
        if (typeRef instanceof ModuleTypeRef) {
            return LuaASTUtils.resolveType(sourceModule, (ModuleTypeRef)typeRef);
        }
        if (typeRef instanceof ExprTypeRef) {
            return LuaASTUtils.resolveType(sourceModule, (ExprTypeRef)typeRef);
        }
        if (typeRef instanceof InlineTypeRef) {
            return LuaASTUtils.resolveType(sourceModule, (InlineTypeRef)typeRef);
        }
        return null;
    }

    public static List<TypeResolution> resolveTypes(ISourceModule sourceModule, TypeRef typeRef) {
        ArrayList<TypeResolution> resolveTypes = new ArrayList<TypeResolution>();
        if (typeRef instanceof PrimitiveTypeRef) {
            resolveTypes.add(LuaASTUtils.resolveType(sourceModule, (PrimitiveTypeRef)typeRef));
        }
        if (typeRef instanceof InternalTypeRef) {
            resolveTypes.add(LuaASTUtils.resolveType(sourceModule, (InternalTypeRef)typeRef));
        }
        if (typeRef instanceof ExternalTypeRef) {
            resolveTypes.add(LuaASTUtils.resolveType(sourceModule, (ExternalTypeRef)typeRef));
        }
        if (typeRef instanceof ModuleTypeRef) {
            resolveTypes.addAll(LuaASTUtils.resolveTypes(sourceModule, (ModuleTypeRef)typeRef));
        }
        if (typeRef instanceof ExprTypeRef) {
            resolveTypes.addAll(LuaASTUtils.resolveTypes(sourceModule, (ExprTypeRef)typeRef));
        }
        if (typeRef instanceof InlineTypeRef) {
            resolveTypes.add(LuaASTUtils.resolveType(sourceModule, (InlineTypeRef)typeRef));
        }
        return resolveTypes;
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, PrimitiveTypeRef primitiveTypeRef) {
        if (primitiveTypeRef.getTypeName().equals("string")) {
            ISourceModule stringSourceModule = LuaUtils.getSourceModule("string", sourceModule.getScriptProject());
            if (stringSourceModule == null) {
                return null;
            }
            LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(stringSourceModule);
            TypeDef typeDef = luaSourceRoot.getFileapi().getTypes().get("string");
            return new TypeResolution(stringSourceModule, typeDef);
        }
        return null;
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, InternalTypeRef internalTypeRef) {
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(sourceModule);
        TypeDef typeDef = luaSourceRoot.getFileapi().getTypes().get(internalTypeRef.getTypeName());
        return new TypeResolution(sourceModule, typeDef);
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, ExternalTypeRef externalTypeRef) {
        ISourceModule externalSourceModule = LuaUtils.getSourceModule(externalTypeRef.getModuleName(), sourceModule.getScriptProject());
        if (externalSourceModule == null) {
            return null;
        }
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(externalSourceModule);
        TypeDef typeDef = luaSourceRoot.getFileapi().getTypes().get(externalTypeRef.getTypeName());
        return new TypeResolution(externalSourceModule, typeDef);
    }

    public static List<TypeResolution> resolveTypes(ISourceModule sourceModule, ModuleTypeRef moduleTypeRef) {
        String moduleName = moduleTypeRef.getModuleName();
        return LuaASTUtils.resolveModuleTypes(sourceModule, moduleName);
    }

    public static List<TypeResolution> resolveModuleTypes(ISourceModule sourceModule, String moduleName) {
        ArrayList<TypeResolution> list = new ArrayList<TypeResolution>();
        if ((moduleName = LuaASTUtils.getEnabledModuleName(moduleName)) == null) {
            return list;
        }
        ISourceModule referencedSourceModule = LuaUtils.getSourceModule(moduleName, sourceModule.getScriptProject());
        if (referencedSourceModule == null) {
            return list;
        }
        String returnObjectName = null;
        try {
            String source = referencedSourceModule.getSource();
            returnObjectName = LuaASTUtils.getReturnObjectName(source);
        }
        catch (ModelException modelException) {}
        if (returnObjectName != null && !returnObjectName.isEmpty()) {
            Document document = new Document(returnObjectName);
            LuaHeuristicScanner luaHeuristicScanner = new LuaHeuristicScanner((IDocument)document);
            LuaExpression luaExpression = luaHeuristicScanner.guessLuaExpression(returnObjectName.length());
            List<TypeResolution> types = LuaASTUtils.resolveTypes(referencedSourceModule, luaExpression);
            list.addAll(types);
        }
        return list;
    }

    private static String getReturnObjectName(String source) {
        Pattern pattern = Pattern.compile("return((\\s)*(\\S)+(\\s)*(;)?(\\s)*)$");
        Matcher mathcer = pattern.matcher(source);
        boolean result = mathcer.find();
        if (result) {
            String group = mathcer.group();
            group = group.replace("return", "").replace(";", "");
            group = group.trim();
            return group;
        }
        return null;
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, ModuleTypeRef moduleTypeRef) {
        Return returnValues;
        ArrayList<Return> returns;
        ISourceModule referencedSourceModule = LuaUtils.getSourceModule(moduleTypeRef.getModuleName(), sourceModule.getScriptProject());
        if (referencedSourceModule == null) {
            return null;
        }
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(referencedSourceModule);
        LuaFileAPI fileapi = luaSourceRoot.getFileapi();
        if (fileapi != null && (returns = fileapi.getReturns()).size() > 0 && (returnValues = returns.get(0)).getTypes().size() > moduleTypeRef.getReturnPosition() - 1) {
            TypeRef typeRef = returnValues.getTypes().get(moduleTypeRef.getReturnPosition() - 1);
            return LuaASTUtils.resolveType(referencedSourceModule, typeRef);
        }
        return null;
    }

    private static String getEnabledModuleName(String moduleName) {
        if (moduleName == null) {
            return null;
        }
        if (moduleName.startsWith("src.") || moduleName.startsWith("src/")) {
            moduleName = moduleName.substring(4, moduleName.length());
        }
        if (moduleName.endsWith(LUA_EXT)) {
            moduleName = moduleName.substring(0, moduleName.length() - 4);
        }
        moduleName = moduleName.replaceAll("/", ".");
        return moduleName;
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, ExprTypeRef exprTypeRef) {
        LuaExpression expression = exprTypeRef.getExpression();
        if (expression == null) {
            return null;
        }
        return LuaASTUtils.resolveType(sourceModule, expression, exprTypeRef.getReturnPosition());
    }

    public static List<TypeResolution> resolveTypes(ISourceModule sourceModule, ExprTypeRef exprTypeRef) {
        LuaExpression expression = exprTypeRef.getExpression();
        if (expression == null) {
            return null;
        }
        return LuaASTUtils.resolveTypes(sourceModule, expression, exprTypeRef.getReturnPosition());
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, LuaExpression expr) {
        return LuaASTUtils.resolveType(sourceModule, expr, 1);
    }

    public static List<TypeResolution> resolveTypes(ISourceModule sourceModule, LuaExpression expr) {
        return LuaASTUtils.resolveTypes(sourceModule, expr, 1);
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, LuaExpression expr, int returnposition) {
        List<TypeRef> types;
        FunctionTypeDef functiontype;
        TypeResolution resolvedFunctionType;
        RecordTypeDef recordtype;
        Item item;
        Invoke invoke;
        TypeResolution resolvedRecordType;
        if (expr instanceof Identifier) {
            Definition definition = LuaASTUtils.getDefinition(sourceModule, expr);
            if (definition == null || definition.getItem() == null || definition.getItem().getType() == null) {
                return null;
            }
            return LuaASTUtils.resolveType(definition.getModule(), definition.getItem().getType());
        }
        if (expr instanceof Index) {
            RecordTypeDef recordtype2;
            Item item2;
            Index index = (Index)expr;
            LuaExpression left = index.getLeft();
            TypeResolution resolvedLeftType = LuaASTUtils.resolveType(sourceModule, left);
            if (resolvedLeftType != null && resolvedLeftType.getTypeDef() instanceof RecordTypeDef && (item2 = (recordtype2 = (RecordTypeDef)resolvedLeftType.getTypeDef()).getFields().get(index.getRight())) != null && item2.getType() != null) {
                return LuaASTUtils.resolveType(resolvedLeftType.getModule(), item2.getType());
            }
            return null;
        }
        if (expr instanceof Call) {
            List<TypeRef> types2;
            FunctionTypeDef functiontype2;
            Call call = (Call)expr;
            TypeResolution resolvedFunctionType2 = LuaASTUtils.resolveType(sourceModule, call.getFunction());
            if (resolvedFunctionType2 != null && resolvedFunctionType2.getTypeDef() instanceof FunctionTypeDef && (functiontype2 = (FunctionTypeDef)resolvedFunctionType2.getTypeDef()).getReturns().size() > 0 && (types2 = functiontype2.getReturns().get(0).getTypes()).size() >= returnposition) {
                return LuaASTUtils.resolveType(resolvedFunctionType2.getModule(), types2.get(returnposition - 1));
            }
            return null;
        }
        if (expr instanceof Invoke && (resolvedRecordType = LuaASTUtils.resolveType(sourceModule, (invoke = (Invoke)expr).getRecord())) != null && resolvedRecordType.getTypeDef() instanceof RecordTypeDef && (item = (recordtype = (RecordTypeDef)resolvedRecordType.getTypeDef()).getFields().get(invoke.getFunctionName())) != null && item.getType() != null && (resolvedFunctionType = LuaASTUtils.resolveType(resolvedRecordType.getModule(), item.getType())) != null && resolvedFunctionType.getTypeDef() instanceof FunctionTypeDef && (functiontype = (FunctionTypeDef)resolvedFunctionType.getTypeDef()).getReturns().size() > 0 && (types = functiontype.getReturns().get(0).getTypes()).size() >= returnposition) {
            return LuaASTUtils.resolveType(resolvedFunctionType.getModule(), types.get(returnposition - 1));
        }
        return null;
    }

    public static List<TypeResolution> resolveTypes(ISourceModule sourceModule, LuaExpression expr, int returnposition) {
        ArrayList<TypeResolution> list;
        block65: {
            block70: {
                Identifier identifier;
                Item item;
                block69: {
                    block67: {
                        String itemName;
                        TypeResolution typeResolution;
                        block68: {
                            list = new ArrayList<TypeResolution>();
                            if (!(expr instanceof Identifier)) break block67;
                            String name = ((Identifier)expr).getDefinition().getName();
                            List<Definition> allDefinitions = LuaASTUtils.getAllDefinition(sourceModule, expr);
                            if (allDefinitions.size() <= 0) break block68;
                            int i = 0;
                            while (i < allDefinitions.size()) {
                                Definition definition = allDefinitions.get(i);
                                Item item2 = definition.getItem();
                                String itemName2 = item2.getName();
                                if (name.equals(itemName2)) {
                                    if (definition == null || definition.getItem() == null || definition.getItem().getType() == null) {
                                        List<Definition> definitions;
                                        if (item2 != null && (definitions = LuaASTUtils.getAllGlobalVarsDefinition(sourceModule, itemName2)).size() > 0) {
                                            Definition globalDefinition = definitions.get(0);
                                            item2 = globalDefinition.getItem();
                                            itemName2 = item2.getName();
                                            if (item2 != null) {
                                                Definition definition1;
                                                TypeRef typeRef = item2.getType();
                                                int itemStart = -1;
                                                if (typeRef instanceof ExprTypeRef) {
                                                    itemStart = item2.sourceStart();
                                                } else if (typeRef instanceof InlineTypeRef) {
                                                    itemStart = item2.sourceStart();
                                                }
                                                if (itemStart != -1 && (definition1 = LuaASTUtils.getDefinition(globalDefinition.getModule(), expr, itemName2, itemStart, true)) != null) {
                                                    list.addAll(LuaASTUtils.resolveTypes(definition1.getModule(), definition1.getItem().getType()));
                                                    LuaASTUtils.getDefinition(globalDefinition.getModule(), expr, itemName2, itemStart, false);
                                                }
                                            }
                                            list.add(LuaASTUtils.resolveType(globalDefinition.getModule(), globalDefinition.getItem().getType()));
                                        }
                                    } else {
                                        boolean find = false;
                                        if (item2 != null) {
                                            TypeRef typeRef = item2.getType();
                                            int itemStart = -1;
                                            if (typeRef instanceof ExprTypeRef) {
                                                itemStart = item2.sourceStart();
                                            } else if (typeRef instanceof InlineTypeRef) {
                                                itemStart = item2.sourceStart();
                                            }
                                            if (itemStart != -1) {
                                                find = true;
                                                Definition definition1 = LuaASTUtils.getDefinition(definition.getModule(), expr, itemName2, itemStart, true);
                                                if (definition1 != null) {
                                                    list.addAll(LuaASTUtils.resolveTypes(definition1.getModule(), definition1.getItem().getType()));
                                                    LuaASTUtils.getDefinition(definition.getModule(), expr, itemName2, itemStart, false);
                                                }
                                            }
                                        }
                                        list.addAll(LuaASTUtils.resolveTypes(definition.getModule(), definition.getItem().getType()));
                                        if (find) break block65;
                                    }
                                }
                                ++i;
                            }
                            break block65;
                        }
                        Identifier identifier2 = (Identifier)expr;
                        Item item3 = identifier2.getDefinition();
                        if (item3 == null || (typeResolution = LuaASTUtils.getExternalPreloadedTypeResolution(sourceModule, itemName = item3.getName())) == null) break block65;
                        list.add(typeResolution);
                        break block65;
                    }
                    if (!(expr instanceof Index)) break block69;
                    Index index = (Index)expr;
                    LuaExpression left = index.getLeft();
                    String right = index.getRight();
                    if (FUNCTION_NEW.equals(right)) {
                        list.addAll(LuaASTUtils.resolveTypes(sourceModule, left));
                    } else {
                        List<TypeResolution> resolvedLeftTypes = LuaASTUtils.resolveTypes(sourceModule, left);
                        int i = 0;
                        while (i < resolvedLeftTypes.size()) {
                            RecordTypeDef recordtype;
                            Item item4;
                            TypeResolution resolvedLeftType = resolvedLeftTypes.get(i);
                            if (resolvedLeftType != null && resolvedLeftType.getTypeDef() instanceof RecordTypeDef && (item4 = (recordtype = (RecordTypeDef)resolvedLeftType.getTypeDef()).getFields().get(index.getRight())) != null && item4.getType() != null) {
                                list.add(LuaASTUtils.resolveType(resolvedLeftType.getModule(), item4.getType()));
                            }
                            ++i;
                        }
                    }
                    break block65;
                }
                if (!(expr instanceof Call)) break block70;
                Call call = (Call)expr;
                LuaExpression functionExpression = call.getFunction();
                if (functionExpression instanceof Identifier && (item = (identifier = (Identifier)functionExpression).getDefinition()) != null) {
                    LuaSourceRoot root;
                    Definition definition;
                    String callName = item.getName();
                    List<Definition> othersglobalvars = LuaASTUtils.getAllInternalGlobalVarsDefinition(sourceModule, callName);
                    othersglobalvars.addAll(LuaASTUtils.getAllExternalGlobalVarsDefinition(sourceModule, callName));
                    if (othersglobalvars.size() > 0 && (definition = othersglobalvars.get(0)) != null) {
                        sourceModule = definition.getModule();
                    }
                    if ((root = LuaASTModelUtils.getLuaSourceRoot(sourceModule)) != null) {
                        int end;
                        int start;
                        LuaInternalContent luaInternalContent = root.getInternalContent();
                        Block block = luaInternalContent.getContent();
                        if (FUNCTION_CLASS.equals(callName)) {
                            start = call.sourceStart();
                            end = call.sourceEnd();
                            LuaASTNode luaASTNode = LuaASTUtils.getLuaASTNodeByPosition(block, start, end);
                            list.addAll(LuaASTUtils.resolveTypesLuaASTNode(sourceModule, luaASTNode));
                        } else if (FUNCTION_REQUIRE.equals(callName)) {
                            start = identifier.sourceStart();
                            end = identifier.sourceEnd();
                            try {
                                String source = sourceModule.getSource();
                                Document doc = new Document(source);
                                int lineStart = doc.getLineOfOffset(start);
                                int lineLength = doc.getLineLength(lineStart);
                                int lineEnd = lineStart + lineLength;
                                String content = doc.get(end, lineEnd);
                                int index = content.indexOf(41);
                                if (index > -1) {
                                    content = content.substring(0, index);
                                    content = content.replaceAll("\"", "").replaceAll("'", "").replaceAll("\\(", "").replaceAll("\\)", "").trim();
                                    list.addAll(LuaASTUtils.resolveModuleTypes(sourceModule, content));
                                }
                            }
                            catch (ModelException modelException) {
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                    }
                }
                List<TypeResolution> resolvedFunctionTypes = LuaASTUtils.resolveTypes(sourceModule, call.getFunction());
                int i = 0;
                while (i < resolvedFunctionTypes.size()) {
                    block71: {
                        FunctionTypeDef functiontype;
                        TypeResolution resolvedFunctionType;
                        block73: {
                            Return returnObject;
                            TypeRef typeRef;
                            block72: {
                                String typeName;
                                block74: {
                                    LuaExpression luaExpression;
                                    resolvedFunctionType = resolvedFunctionTypes.get(i);
                                    if (resolvedFunctionType == null && (luaExpression = call.getFunction()) instanceof Index) {
                                        LuaExpression leftLuaExpression = ((Index)luaExpression).getLeft();
                                        if (leftLuaExpression instanceof Identifier) {
                                            ExprTypeRef exprTypeRef;
                                            LuaExpression typeRefExpression;
                                            LuaExpression extendLuaExpression;
                                            TypeResolution resolvedRecordType;
                                            TypeRef typeRef2;
                                            Definition definition = LuaASTUtils.getDefinition(sourceModule, leftLuaExpression);
                                            if (definition != null && (typeRef2 = definition.getItem().getType()) instanceof ExprTypeRef && (resolvedRecordType = LuaASTUtils.resolveType(sourceModule, extendLuaExpression = LuaASTUtils.findExtendLuaExtendExpression(sourceModule, typeRefExpression = (exprTypeRef = (ExprTypeRef)typeRef2).getExpression()))) != null && resolvedRecordType.getTypeDef() instanceof RecordTypeDef) {
                                                RecordTypeDef recordtype = (RecordTypeDef)resolvedRecordType.getTypeDef();
                                                if (functionExpression instanceof Index) {
                                                    List<TypeRef> types;
                                                    FunctionTypeDef functiontype2;
                                                    TypeResolution itemResolvedFunctionType;
                                                    Index functionIndex = (Index)functionExpression;
                                                    String functionName = functionIndex.getRight();
                                                    Item item5 = recordtype.getFields().get(functionName);
                                                    if (item5 != null && item5.getType() != null && (itemResolvedFunctionType = LuaASTUtils.resolveType(resolvedRecordType.getModule(), item5.getType())) != null && itemResolvedFunctionType.getTypeDef() instanceof FunctionTypeDef && (functiontype2 = (FunctionTypeDef)itemResolvedFunctionType.getTypeDef()).getReturns().size() > 0 && (types = functiontype2.getReturns().get(0).getTypes()).size() >= returnposition) {
                                                        list.add(LuaASTUtils.resolveType(itemResolvedFunctionType.getModule(), types.get(returnposition - 1)));
                                                    }
                                                }
                                            }
                                        } else if (leftLuaExpression instanceof Index) {
                                            LuaExpression extendLuaExtendExpression = LuaASTUtils.findExtendLuaExtendExpression(sourceModule, luaExpression);
                                            resolvedFunctionType = LuaASTUtils.resolveType(sourceModule, extendLuaExtendExpression);
                                        }
                                    }
                                    if (resolvedFunctionType != null && resolvedFunctionType.getTypeDef() instanceof RecordTypeDef) {
                                        list.add(resolvedFunctionType);
                                    }
                                    if (resolvedFunctionType == null || !(resolvedFunctionType.getTypeDef() instanceof FunctionTypeDef)) break block71;
                                    functiontype = (FunctionTypeDef)resolvedFunctionType.getTypeDef();
                                    if (functiontype.getReturns().size() <= 0) break block72;
                                    List<TypeRef> types = functiontype.getReturns().get(0).getTypes();
                                    if (types.size() < returnposition) break block73;
                                    TypeRef ref = types.get(returnposition - 1);
                                    typeName = null;
                                    if (ref instanceof ExternalTypeRef) {
                                        typeName = ((ExternalTypeRef)ref).getTypeName();
                                    } else if (ref instanceof InternalTypeRef) {
                                        typeName = ((InternalTypeRef)ref).getTypeName();
                                    }
                                    if (typeName == null) break block73;
                                    Definition definition = LuaASTUtils.getGlobalVarDefinition(resolvedFunctionType.getModule(), typeName);
                                    if (definition == null) break block74;
                                    Item itemDef = definition.getItem();
                                    if (itemDef != null && (typeRef = itemDef.getType()) != null) {
                                        returnObject = new Return();
                                        returnObject.addType(typeRef);
                                        functiontype.addReturn(returnObject);
                                    }
                                    break block73;
                                }
                                TypeResolution typeResolution = LuaASTUtils.getExternalPreloadedTypeResolution(sourceModule, typeName);
                                if (typeResolution == null) break block73;
                                list.add(typeResolution);
                                break block73;
                            }
                            List<String> returnValues = LuaASTUtils.getFunctionReturnValue(resolvedFunctionType, functiontype);
                            int j = 0;
                            while (j < returnValues.size()) {
                                String returnValue = returnValues.get(j);
                                Definition definition = LuaASTUtils.getGlobalVarDefinition(resolvedFunctionType.getModule(), returnValue);
                                if (definition != null) {
                                    Item item6 = definition.getItem();
                                    if (item6 != null && (typeRef = item6.getType()) != null) {
                                        returnObject = new Return();
                                        returnObject.addType(typeRef);
                                        functiontype.addReturn(returnObject);
                                    }
                                } else {
                                    TypeResolution typeResolution = LuaASTUtils.getExternalPreloadedTypeResolution(sourceModule, returnValue);
                                    if (typeResolution != null) {
                                        list.add(typeResolution);
                                    }
                                }
                                ++j;
                            }
                        }
                        List<Return> returns = functiontype.getReturns();
                        int j = 0;
                        while (j < returns.size()) {
                            List<TypeRef> types = returns.get(j).getTypes();
                            if (types.size() >= returnposition) {
                                list.add(LuaASTUtils.resolveType(resolvedFunctionType.getModule(), types.get(returnposition - 1)));
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                break block65;
            }
            if (expr instanceof Invoke) {
                Invoke invoke = (Invoke)expr;
                String functionName = invoke.getFunctionName();
                if (FUNCTION_NEW.equals(functionName)) {
                    LuaExpression newObjectExpression = invoke.getRecord();
                    list.addAll(LuaASTUtils.resolveTypes(sourceModule, newObjectExpression, returnposition));
                } else {
                    List<TypeResolution> resolvedRecordTypes = LuaASTUtils.resolveTypes(sourceModule, invoke.getRecord());
                    int i = 0;
                    while (i < resolvedRecordTypes.size()) {
                        TypeResolution resolvedRecordType = resolvedRecordTypes.get(i);
                        if (resolvedRecordType == null) {
                            LuaExpression extendLuaExtendExpression = LuaASTUtils.findExtendLuaExtendExpression(sourceModule, invoke.getRecord());
                            resolvedRecordType = LuaASTUtils.resolveType(sourceModule, extendLuaExtendExpression);
                        }
                        if (resolvedRecordType != null && resolvedRecordType.getTypeDef() instanceof RecordTypeDef) {
                            List<TypeRef> types;
                            FunctionTypeDef functiontype;
                            TypeResolution resolvedFunctionType;
                            RecordTypeDef recordtype = (RecordTypeDef)resolvedRecordType.getTypeDef();
                            Item item = recordtype.getFields().get(invoke.getFunctionName());
                            if (item == null) {
                                LuaExpression extendLuaExpression;
                                LuaExpression record = invoke.getRecord();
                                if (record instanceof Identifier) {
                                    ExprTypeRef exprTypeRef;
                                    LuaExpression typeRefExpression;
                                    LuaExpression extendLuaExpression2;
                                    Definition definition = LuaASTUtils.getDefinition(sourceModule, invoke.getRecord());
                                    TypeRef typeRef = definition.getItem().getType();
                                    if (typeRef instanceof ExprTypeRef && (resolvedRecordType = LuaASTUtils.resolveType(sourceModule, extendLuaExpression2 = LuaASTUtils.findExtendLuaExtendExpression(sourceModule, typeRefExpression = (exprTypeRef = (ExprTypeRef)typeRef).getExpression()))) != null && resolvedRecordType.getTypeDef() instanceof RecordTypeDef) {
                                        recordtype = (RecordTypeDef)resolvedRecordType.getTypeDef();
                                        item = recordtype.getFields().get(invoke.getFunctionName());
                                    }
                                } else if (record instanceof Index && (resolvedRecordType = LuaASTUtils.resolveType(sourceModule, extendLuaExpression = LuaASTUtils.findExtendLuaExtendExpression(sourceModule, invoke.getRecord()))) != null && resolvedRecordType.getTypeDef() instanceof RecordTypeDef) {
                                    recordtype = (RecordTypeDef)resolvedRecordType.getTypeDef();
                                    item = recordtype.getFields().get(invoke.getFunctionName());
                                }
                            }
                            if (item != null && item.getType() != null && (resolvedFunctionType = LuaASTUtils.resolveType(resolvedRecordType.getModule(), item.getType())) != null && resolvedFunctionType.getTypeDef() instanceof FunctionTypeDef && (functiontype = (FunctionTypeDef)resolvedFunctionType.getTypeDef()).getReturns().size() > 0 && (types = functiontype.getReturns().get(0).getTypes()).size() >= returnposition) {
                                list.add(LuaASTUtils.resolveType(resolvedFunctionType.getModule(), types.get(returnposition - 1)));
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        return list;
    }

    private static LuaASTNode getLuaASTNodeByPosition(Block block, final int start, final int end) {
        luaASTNode = null;
        try {
            block.traverse(new ASTVisitor(){

                public boolean visit(ASTNode s) throws Exception {
                    int nodeStart = s.sourceStart();
                    int nodeEnd = s.sourceEnd();
                    if (start < nodeStart && nodeEnd < end && s instanceof LuaASTNode) {
                        LuaASTUtils.luaASTNode = (LuaASTNode)s;
                        return false;
                    }
                    return super.visit(s);
                }
            });
        }
        catch (Exception exception) {}
        return luaASTNode;
    }

    private static List<TypeResolution> resolveTypesLuaASTNode(ISourceModule sourceModule, LuaASTNode node) {
        ArrayList<TypeResolution> list = new ArrayList<TypeResolution>();
        if (node instanceof Identifier) {
            Identifier identifier = (Identifier)node;
            list.addAll(LuaASTUtils.resolveTypes(sourceModule, identifier));
        } else if (node instanceof Index) {
            Index index = (Index)node;
            list.addAll(LuaASTUtils.resolveTypes(sourceModule, index));
        } else if (node instanceof Invoke) {
            Invoke invoke = (Invoke)node;
            list.addAll(LuaASTUtils.resolveTypes(sourceModule, invoke));
        } else if (node instanceof Block) {
            Block block = (Block)node;
            List<LuaASTNode> nodes = block.getContent();
            int i = 0;
            while (i < nodes.size()) {
                list.addAll(LuaASTUtils.resolveTypesLuaASTNode(sourceModule, nodes.get(i)));
                ++i;
            }
        }
        return list;
    }

    private static LuaExpression findExtendLuaExtendExpression(ISourceModule sourceModule, LuaExpression luaExpression) {
        if (luaExpression instanceof Index) {
            Index index = (Index)luaExpression;
            LuaExpression left = index.getLeft();
            if (left instanceof Index) {
                ISourceModule module;
                List<String> extendObjectNames;
                Index leftIndex = (Index)left;
                TypeResolution resolveType = LuaASTUtils.resolveType(sourceModule, left);
                if (resolveType != null && (extendObjectNames = LuaASTUtils.getExtendObjectNames(module = resolveType.getModule())).size() > 0) {
                    leftIndex.setRight(extendObjectNames.get(0));
                }
                return luaExpression;
            }
            if (left instanceof Identifier) {
                ISourceModule module;
                List<String> extendObjectNames;
                TypeResolution resolveType = LuaASTUtils.resolveType(sourceModule, index);
                if (resolveType != null && (extendObjectNames = LuaASTUtils.getExtendObjectNames(module = resolveType.getModule())).size() > 0) {
                    index.setRight(extendObjectNames.get(0));
                }
                return luaExpression;
            }
            LuaASTUtils.findExtendLuaExtendExpression(sourceModule, left);
        } else if (luaExpression instanceof Call) {
            Call call = (Call)luaExpression;
            LuaExpression function = call.getFunction();
            if (function instanceof Index) {
                LuaExpression left = ((Index)function).getLeft();
                if (left instanceof Index) {
                    ISourceModule module;
                    List<String> extendObjectNames;
                    Index leftIndex = (Index)left;
                    TypeResolution resolveType = LuaASTUtils.resolveType(sourceModule, left);
                    if (resolveType != null && (extendObjectNames = LuaASTUtils.getExtendObjectNames(module = resolveType.getModule())).size() > 0) {
                        leftIndex.setRight(extendObjectNames.get(0));
                    }
                    return luaExpression;
                }
                LuaASTUtils.findExtendLuaExtendExpression(sourceModule, left);
            }
        } else if (luaExpression instanceof Invoke) {
            Invoke invoke = (Invoke)luaExpression;
            LuaExpression record = invoke.getRecord();
            if (record instanceof Index) {
                ISourceModule module;
                List<String> extendObjectNames;
                Index index = (Index)record;
                TypeResolution resolveType = LuaASTUtils.resolveType(sourceModule, index);
                if (resolveType != null && (extendObjectNames = LuaASTUtils.getExtendObjectNames(module = resolveType.getModule())).size() > 0) {
                    index.setRight(extendObjectNames.get(0));
                }
                return luaExpression;
            }
            LuaASTUtils.findExtendLuaExtendExpression(sourceModule, record);
        }
        return luaExpression;
    }

    private static Identifier getClassSuperIdentifer(Call call) {
        return null;
    }

    private static List<String> getExtendObjectNames(ISourceModule module) {
        ArrayList<String> extendObjectNames = new ArrayList<String>();
        try {
            String source = module.getSource();
            Pattern pattern = Pattern.compile("--(\\s)*@extend(.|\\t|\\x0B|\\f|\\r)*\\n");
            Matcher mathcer = pattern.matcher(source);
            boolean result = mathcer.find();
            if (result) {
                String group = mathcer.group();
                int extendIndex = group.indexOf(EXTEND);
                String extendObjects = group.substring(extendIndex + 7);
                String[] extendArray = extendObjects.split(",");
                int i = 0;
                while (i < extendArray.length) {
                    extendObjectNames.add(extendArray[i].trim());
                    ++i;
                }
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return extendObjectNames;
    }

    private static List<String> getParentModuleNames(ISourceModule module) {
        ArrayList<String> extendObjectNames = new ArrayList<String>();
        try {
            String source = module.getSource();
            Pattern pattern = Pattern.compile("--(\\s)*@parent_module(.|\\t|\\x0B|\\f|\\r)*\\n");
            Matcher mathcer = pattern.matcher(source);
            boolean result = mathcer.find();
            if (result) {
                String group = mathcer.group();
                int extendIndex = group.indexOf(PARENT_MODULE);
                String extendObjects = group.substring(extendIndex + 7);
                String[] extendArray = extendObjects.split(",");
                int i = 0;
                while (i < extendArray.length) {
                    extendObjectNames.add(extendArray[i].trim());
                    ++i;
                }
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return extendObjectNames;
    }

    private static List<String> getFunctionReturnValue(TypeResolution resolvedFunctionType, FunctionTypeDef functiontype) {
        ArrayList<String> returnValues = new ArrayList<String>();
        ISourceModule sourceModule = resolvedFunctionType.getModule();
        LuaASTNode parentNode = functiontype.getParent();
        if (parentNode != null && sourceModule != null) {
            try {
                String source = sourceModule.getSource();
                Document doc = new Document();
                if (source != null) {
                    doc.set(source);
                    int start = parentNode.start();
                    int line = doc.getLineOfOffset(start);
                    int lineOffset = doc.getLineOffset(line);
                    int lineLength = doc.getLineLength(line);
                    String lineStr = doc.get(lineOffset, lineLength);
                    Pattern pattern = Pattern.compile("--(\\s)*@return(\\s)*(.|\\t|\\x0B|\\f|\\r)*\\n");
                    Matcher mathcer = pattern.matcher(lineStr);
                    boolean result = mathcer.find();
                    if (result) {
                        String group = mathcer.group();
                        int extendIndex = group.indexOf(RETURN);
                        String str = group.substring(extendIndex + 7).trim();
                        String[] strs = str.split("\\|");
                        int i = 0;
                        while (i < strs.length) {
                            returnValues.add(strs[i]);
                            ++i;
                        }
                    }
                }
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        HashSet set = new HashSet(returnValues);
        returnValues.clear();
        returnValues.addAll(set);
        return returnValues;
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, InlineTypeRef inlineTypeRef) {
        TypeDef typeDef = inlineTypeRef.getDefinition();
        return new TypeResolution(sourceModule, typeDef);
    }

    public static Collection<Item> getLocalVars(LuaSourceRoot luaSourceRoot, final int offset, final String start) {
        final HashMap collectedLocalVars = new HashMap();
        ASTVisitor localvarCollector = new ASTVisitor(){

            public boolean visit(ASTNode node) throws Exception {
                if (node instanceof Block) {
                    return node.sourceStart() <= offset && offset <= node.sourceEnd();
                }
                return false;
            }

            public boolean endvisit(ASTNode node) throws Exception {
                if (node instanceof Block) {
                    List<LocalVar> localVars = ((Block)node).getLocalVars();
                    for (LocalVar localVar : localVars) {
                        Item item = localVar.getVar();
                        if (collectedLocalVars.containsKey(item.getName()) || start != null && !item.getName().toLowerCase().startsWith(start.toLowerCase())) continue;
                        collectedLocalVars.put(item.getName(), item);
                    }
                    return true;
                }
                return false;
            }
        };
        try {
            luaSourceRoot.getInternalContent().getContent().traverse(localvarCollector);
        }
        catch (Exception e) {
            Activator.logError("unable to collect local var", e);
        }
        return collectedLocalVars.values();
    }

    public static LuaExpression getLuaExpressionAt(LuaSourceRoot luaSourceRoot, int startOffset, int endOffset) {
        try {
            MatchNodeVisitor matchNodeVisitor = new MatchNodeVisitor(startOffset, endOffset, LuaExpression.class);
            luaSourceRoot.getInternalContent().getContent().traverse(matchNodeVisitor);
            return (LuaExpression)matchNodeVisitor.getNode();
        }
        catch (Exception e) {
            Activator.logError("unable to get expression at", e);
            return null;
        }
    }

    public static Definition getDefinition(ISourceModule sourceModule, LuaExpression luaExpression) {
        if (luaExpression instanceof Identifier) {
            Identifier identifier = (Identifier)luaExpression;
            if (identifier.getDefinition() != null) {
                Definition globalVarDefinition;
                Item definition = identifier.getDefinition();
                if (definition instanceof UnknownItem) {
                    String identifiername = definition.getName();
                    LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(sourceModule);
                    Item localvarItem = LuaASTUtils.getClosestLocalVar(luaSourceRoot, identifiername, identifier.start());
                    if (localvarItem != null) {
                        return new Definition(sourceModule, localvarItem);
                    }
                    Definition globalVarDefinition2 = LuaASTUtils.getGlobalVarDefinition(sourceModule, identifiername);
                    if (globalVarDefinition2 != null) {
                        return globalVarDefinition2;
                    }
                    return null;
                }
                if (LuaASTUtils.isUnresolvedGlobal(definition) && (globalVarDefinition = LuaASTUtils.getGlobalVarDefinition(sourceModule, definition.getName())) != null) {
                    return globalVarDefinition;
                }
                return new Definition(sourceModule, definition);
            }
        } else if (luaExpression instanceof Index) {
            Index index = (Index)luaExpression;
            TypeResolution resolveType = LuaASTUtils.resolveType(sourceModule, index.getLeft());
            if (resolveType != null && resolveType.getTypeDef() instanceof RecordTypeDef) {
                RecordTypeDef typeDef = (RecordTypeDef)resolveType.getTypeDef();
                Item definition = typeDef.getFields().get(index.getRight());
                return new Definition(resolveType.getModule(), definition);
            }
        } else if (luaExpression instanceof Invoke) {
            Invoke invoke = (Invoke)luaExpression;
            TypeResolution resolveType = LuaASTUtils.resolveType(sourceModule, invoke.getRecord());
            if (resolveType != null && resolveType.getTypeDef() instanceof RecordTypeDef) {
                RecordTypeDef typeDef = (RecordTypeDef)resolveType.getTypeDef();
                Item definition = typeDef.getFields().get(invoke.getFunctionName());
                return new Definition(resolveType.getModule(), definition);
            }
        } else if (luaExpression instanceof Call) {
            Call call = (Call)luaExpression;
            Definition definition = LuaASTUtils.getDefinition(sourceModule, call.getFunction());
            return definition;
        }
        return null;
    }

    public static List<Definition> getAllDefinition(ISourceModule sourceModule, LuaExpression luaExpression) {
        ArrayList<Definition> definitions = new ArrayList<Definition>();
        if (luaExpression instanceof Identifier) {
            Identifier identifier = (Identifier)luaExpression;
            if (identifier.getDefinition() != null) {
                Item definition = identifier.getDefinition();
                if (definition instanceof UnknownItem) {
                    String identifiername = definition.getName();
                    LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(sourceModule);
                    Item localvarItem = LuaASTUtils.getClosestLocalVar(luaSourceRoot, identifiername, identifier.start());
                    if (localvarItem != null) {
                        definitions.add(new Definition(sourceModule, localvarItem));
                    } else {
                        List<Definition> globalVarDefinitions = LuaASTUtils.getAllGlobalVarDefinition(sourceModule, identifiername);
                        definitions.addAll(globalVarDefinitions);
                    }
                } else if (LuaASTUtils.isUnresolvedGlobal(definition)) {
                    List<Definition> globalVarDefinitions = LuaASTUtils.getAllGlobalVarDefinition(sourceModule, definition.getName());
                    definitions.addAll(globalVarDefinitions);
                } else {
                    definitions.add(new Definition(sourceModule, definition));
                }
            }
        } else if (luaExpression instanceof Index) {
            Index index = (Index)luaExpression;
            TypeResolution resolveType = LuaASTUtils.resolveType(sourceModule, index.getLeft());
            if (resolveType != null && resolveType.getTypeDef() instanceof RecordTypeDef) {
                RecordTypeDef typeDef = (RecordTypeDef)resolveType.getTypeDef();
                Item definition = typeDef.getFields().get(index.getRight());
                definitions.add(new Definition(resolveType.getModule(), definition));
            }
        } else if (luaExpression instanceof Invoke) {
            Invoke invoke = (Invoke)luaExpression;
            TypeResolution resolveType = LuaASTUtils.resolveType(sourceModule, invoke.getRecord());
            if (resolveType != null && resolveType.getTypeDef() instanceof RecordTypeDef) {
                RecordTypeDef typeDef = (RecordTypeDef)resolveType.getTypeDef();
                Item definition = typeDef.getFields().get(invoke.getFunctionName());
                definitions.add(new Definition(resolveType.getModule(), definition));
            }
        } else if (luaExpression instanceof Call) {
            Call call = (Call)luaExpression;
            Definition definition = LuaASTUtils.getDefinition(sourceModule, call.getFunction());
            definitions.add(definition);
        }
        return definitions;
    }

    public static Definition getDefinition(ISourceModule sourceModule, LuaExpression luaExpression, String itemName, int itemStart, boolean isCompletion) {
        if (luaExpression instanceof Identifier) {
            Identifier identifier = (Identifier)luaExpression;
            if (identifier.getDefinition() != null) {
                Definition globalVarDefinition;
                Item definition = identifier.getDefinition();
                if (definition instanceof UnknownItem) {
                    String identifiername = definition.getName();
                    LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(sourceModule, itemName, itemStart, isCompletion);
                    Item localvarItem = LuaASTUtils.getClosestLocalVar(luaSourceRoot, identifiername, identifier.start());
                    if (localvarItem != null) {
                        return new Definition(sourceModule, localvarItem);
                    }
                    Definition globalVarDefinition2 = LuaASTUtils.getGlobalVarDefinition(sourceModule, identifiername);
                    if (globalVarDefinition2 != null) {
                        return globalVarDefinition2;
                    }
                    return null;
                }
                if (LuaASTUtils.isUnresolvedGlobal(definition) && (globalVarDefinition = LuaASTUtils.getGlobalVarDefinition(sourceModule, definition.getName())) != null) {
                    return globalVarDefinition;
                }
                return new Definition(sourceModule, definition);
            }
        } else if (luaExpression instanceof Index) {
            Index index = (Index)luaExpression;
            TypeResolution resolveType = LuaASTUtils.resolveType(sourceModule, index.getLeft());
            if (resolveType != null && resolveType.getTypeDef() instanceof RecordTypeDef) {
                RecordTypeDef typeDef = (RecordTypeDef)resolveType.getTypeDef();
                Item definition = typeDef.getFields().get(index.getRight());
                return new Definition(resolveType.getModule(), definition);
            }
        } else if (luaExpression instanceof Invoke) {
            Invoke invoke = (Invoke)luaExpression;
            TypeResolution resolveType = LuaASTUtils.resolveType(sourceModule, invoke.getRecord());
            if (resolveType != null && resolveType.getTypeDef() instanceof RecordTypeDef) {
                RecordTypeDef typeDef = (RecordTypeDef)resolveType.getTypeDef();
                Item definition = typeDef.getFields().get(invoke.getFunctionName());
                return new Definition(resolveType.getModule(), definition);
            }
        } else if (luaExpression instanceof Call) {
            Call call = (Call)luaExpression;
            Definition definition = LuaASTUtils.getDefinition(sourceModule, call.getFunction());
            return definition;
        }
        return null;
    }

    public static List<Definition> getAllGlobalVarsDefinition(ISourceModule sourceModule, String start) {
        ArrayList<Definition> definitions = new ArrayList<Definition>();
        ISourceModule preloadedSourceModule = LuaASTUtils.getPreloadSourceModule(sourceModule);
        if (preloadedSourceModule != null) {
            definitions.addAll(LuaASTUtils.getAllInternalGlobalVarsDefinition(preloadedSourceModule, start));
        }
        if (Platform.getPreferencesService().getBoolean(LuaLanguageToolkit.getDefault().getPreferenceQualifier(), "USE_GLOBAL_VAR_IN_LDT", true, null)) {
            definitions.addAll(LuaASTUtils.getAllInternalGlobalVarsDefinition(sourceModule, start));
            definitions.addAll(LuaASTUtils.getAllExternalGlobalVarsDefinition(sourceModule, start));
        }
        return definitions;
    }

    public static List<Definition> getAllGlobalVarDefinition(ISourceModule sourceModule, String start) {
        ArrayList<Definition> definitions = new ArrayList<Definition>();
        List<ISourceModule> preloadedSourceModules = LuaASTUtils.getAllPreloadSourceModule(sourceModule);
        int i = 0;
        while (i < preloadedSourceModules.size()) {
            ISourceModule preloadedSourceModule = preloadedSourceModules.get(i);
            definitions.addAll(LuaASTUtils.getAllInternalGlobalVarsDefinition(preloadedSourceModule, start));
            ++i;
        }
        if (Platform.getPreferencesService().getBoolean(LuaLanguageToolkit.getDefault().getPreferenceQualifier(), "USE_GLOBAL_VAR_IN_LDT", true, null)) {
            definitions.addAll(LuaASTUtils.getAllInternalGlobalVarsDefinition(sourceModule, start));
            definitions.addAll(LuaASTUtils.getAllExternalGlobalVarsDefinition(sourceModule, start));
        }
        return definitions;
    }

    public static List<Definition> getAllInternalGlobalVarsDefinition(ISourceModule sourceModule, String start) {
        ArrayList<Definition> definitions = new ArrayList<Definition>();
        LuaSourceRoot currentluaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(sourceModule);
        if (currentluaSourceRoot != null) {
            for (Item globalvar : currentluaSourceRoot.getFileapi().getGlobalvars().values()) {
                if (start != null && !start.isEmpty() && !globalvar.getName().toLowerCase().startsWith(start.toLowerCase())) continue;
                definitions.add(new Definition(sourceModule, globalvar));
            }
        }
        return definitions;
    }

    public static List<Definition> getAllExternalGlobalVarsDefinition(ISourceModule originalSourceModule, String start) {
        return LuaASTUtils.getExternalGlobalVarsDefinition(originalSourceModule, start, false);
    }

    private static List<Definition> getExternalGlobalVarsDefinition(final ISourceModule originalSourceModule, final String start, final boolean exactName) {
        final ArrayList<Definition> definitions = new ArrayList<Definition>();
        IProjectSourceVisitor2 visitor = new IProjectSourceVisitor2(){

            @Override
            public void processFile(ISourceModule sourceModule, IPath absolutePath, IPath relativePath, String charset, IProgressMonitor monitor) throws CoreException {
                if (sourceModule != null && !sourceModule.equals(originalSourceModule)) {
                    if (exactName) {
                        definitions.add(LuaASTUtils.getInternalGlobalVarDefinition(sourceModule, start));
                    } else {
                        definitions.addAll(LuaASTUtils.getAllInternalGlobalVarsDefinition(sourceModule, start));
                    }
                }
            }

            @Override
            public void processDirectory(IScriptFolder sourceModule, IPath absolutePath, IPath relativePath, IProgressMonitor monitor) throws CoreException {
            }
        };
        try {
            LuaUtils.visitSourceFiles(originalSourceModule.getScriptProject(), EnumSet.of(LuaUtils.ProjectFragmentFilter.DEPENDENT_PROJECT), visitor, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.logError("Unable to get external global for auto-complete", e);
        }
        return definitions;
    }

    public static Definition getGlobalVarDefinition(ISourceModule sourceModule, String varname) {
        Definition definition = LuaASTUtils.getGlobalVarDefinitionInPreloadedSourceModule(sourceModule, varname);
        if (definition != null) {
            return definition;
        }
        if (Platform.getPreferencesService().getBoolean(LuaLanguageToolkit.getDefault().getPreferenceQualifier(), "USE_GLOBAL_VAR_IN_LDT", true, null)) {
            definition = LuaASTUtils.getInternalGlobalVarDefinition(sourceModule, varname);
            if (definition != null) {
                return definition;
            }
            definition = LuaASTUtils.getExternalGlobalVarDefinition(sourceModule, varname);
            if (definition != null) {
                return definition;
            }
            Document document = new Document(varname);
            LuaHeuristicScanner luaHeuristicScanner = new LuaHeuristicScanner((IDocument)document);
            LuaExpression luaExpression = luaHeuristicScanner.guessLuaExpression(varname.length());
            if (luaExpression instanceof Index && (definition = LuaASTUtils.getDefinition(sourceModule, luaExpression)) != null) {
                return definition;
            }
        }
        return null;
    }

    public static Definition getGlobalVarDefinitionInPreloadedSourceModule(ISourceModule sourceModule, String varname) {
        ISourceModule preloadedSourceModule = LuaASTUtils.getPreloadSourceModule(sourceModule);
        if (preloadedSourceModule == null) {
            return null;
        }
        LuaSourceRoot preloadedLuaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(preloadedSourceModule);
        if (preloadedLuaSourceRoot == null) {
            return null;
        }
        Item item = preloadedLuaSourceRoot.getFileapi().getGlobalvars().get(varname);
        if (item == null) {
            return null;
        }
        return new Definition(preloadedSourceModule, item);
    }

    public static TypeResolution getExternalPreloadedTypeResolution(ISourceModule sourceModule, String varname) {
        TypeResolution typeResolution = null;
        ISourceModule externalSourceModule = LuaUtils.getSourceModule(varname, sourceModule.getScriptProject());
        if (externalSourceModule == null) {
            return null;
        }
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(externalSourceModule);
        TypeDef typeDef = luaSourceRoot.getFileapi().getTypes().get(varname);
        if (typeDef != null) {
            typeResolution = new TypeResolution(externalSourceModule, typeDef);
        }
        return typeResolution;
    }

    public static List<TypeResolution> getExternalPreloadedTypeResolutionByStart(ISourceModule sourceModule, String start) {
        ArrayList<TypeResolution> typeResolutions = new ArrayList<TypeResolution>();
        List<ISourceModule> externalSourceModules = LuaUtils.getSourceModuleByStart(start, sourceModule.getScriptProject());
        int i = 0;
        while (i < externalSourceModules.size()) {
            TypeDef typeDef;
            ISourceModule externalSourceModule = externalSourceModules.get(i);
            LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(externalSourceModule);
            String elementName = externalSourceModule.getElementName();
            if (elementName.endsWith(LUA_EXT)) {
                elementName = elementName.substring(0, elementName.length() - LUA_EXT.length());
            }
            if (LuaASTUtils.getParentModuleNames(externalSourceModule).size() == 0 && (typeDef = luaSourceRoot.getFileapi().getTypes().get(elementName)) != null) {
                typeResolutions.add(new TypeResolution(externalSourceModule, typeDef));
            }
            ++i;
        }
        return typeResolutions;
    }

    private static boolean isGlobalNameSpace(ISourceModule sourceModule, String key) {
        List<ISourceModule> preloadedSourceModules = LuaASTUtils.getAllPreloadSourceModule(sourceModule);
        int i = 0;
        while (i < preloadedSourceModules.size()) {
            ISourceModule preloadedSourceModule = preloadedSourceModules.get(i);
            LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(preloadedSourceModule);
            HashMap<String, Item> globalvars = luaSourceRoot.getFileapi().getGlobalvars();
            Set<Map.Entry<String, Item>> sets = globalvars.entrySet();
            for (Map.Entry<String, Item> entry : sets) {
                RecordTypeDef recordTypeDef;
                TypeDef typeDef;
                TypeResolution typeResolution;
                TypeRef typeRef;
                Item item;
                String name = entry.getKey();
                ISourceModule fieldSourceModule = LuaASTUtils.getPreloadSourceModule(preloadedSourceModule, name);
                if (fieldSourceModule == null || (item = entry.getValue()) == null || (typeRef = item.getType()) == null || (typeResolution = LuaASTUtils.resolveType(fieldSourceModule, typeRef)) == null || !((typeDef = typeResolution.typeDef) instanceof RecordTypeDef) || !(recordTypeDef = (RecordTypeDef)typeDef).getFields().containsKey(key)) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Definition getInternalGlobalVarDefinition(ISourceModule sourceModule, String varname) {
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(sourceModule);
        if (luaSourceRoot == null) {
            return null;
        }
        Item item = luaSourceRoot.getFileapi().getGlobalvars().get(varname);
        if (item == null) {
            return null;
        }
        return new Definition(sourceModule, item);
    }

    public static Definition getExternalGlobalVarDefinition(ISourceModule originalSourceModule, String start) {
        List<Definition> definitions = LuaASTUtils.getExternalGlobalVarsDefinition(originalSourceModule, start, true);
        if (!definitions.isEmpty()) {
            return definitions.get(0);
        }
        return null;
    }

    public static ISourceModule getPreloadSourceModule(ISourceModule sourceModule) {
        if (sourceModule != null && sourceModule.getScriptProject() != null) {
            return LuaUtils.getSourceModule("global", sourceModule.getScriptProject());
        }
        return null;
    }

    public static List<ISourceModule> getAllPreloadSourceModule(ISourceModule sourceModule) {
        if (sourceModule != null && sourceModule.getScriptProject() != null) {
            return LuaUtils.getAllSourceModule("global", sourceModule.getScriptProject());
        }
        return null;
    }

    public static ISourceModule getPreloadSourceModule(ISourceModule sourceModule, String name) {
        if (sourceModule != null && sourceModule.getScriptProject() != null) {
            return LuaUtils.getSourceModule(name, sourceModule.getScriptProject());
        }
        return null;
    }

    public static boolean isModule(LuaFileAPI luaFileAPI, RecordTypeDef recordTypeDef) {
        TypeRef moduleReturnTypeRef = LuaASTUtils.getModuleReturnType(luaFileAPI);
        if (!(moduleReturnTypeRef instanceof InternalTypeRef)) {
            return false;
        }
        String typename = ((InternalTypeRef)moduleReturnTypeRef).getTypeName();
        return luaFileAPI.getTypes().get(typename) == recordTypeDef;
    }

    public static boolean isInlineTypeDef(TypeDef typedef) {
        return typedef != null && typedef.getParent() instanceof Item;
    }

    public static boolean isInlineTypeField(Item item) {
        return item.getParent() instanceof RecordTypeDef && LuaASTUtils.isInlineTypeDef((TypeDef)item.getParent());
    }

    public static boolean isLocalVariable(Item item) {
        return item.getParent() instanceof Block;
    }

    public static boolean isGlobalVariable(Item item) {
        return item.getParent() instanceof LuaFileAPI;
    }

    public static boolean isUnresolvedGlobal(Item item) {
        return item.getParent() instanceof LuaInternalContent;
    }

    public static boolean isTypeField(Item item) {
        return item.getParent() instanceof RecordTypeDef;
    }

    public static boolean isModuleTypeField(LuaFileAPI luaFileAPI, Item item) {
        LuaASTNode parent = item.getParent();
        if (parent instanceof RecordTypeDef) {
            return LuaASTUtils.isModule(luaFileAPI, (RecordTypeDef)parent);
        }
        return false;
    }

    public static boolean isModule(LuaFileAPI luaFileAPI, LuaASTNode node) {
        TypeDef typedef;
        if (node instanceof Item) {
            Item item = (Item)node;
            if (LuaASTUtils.isInlineTypeField(item) && item.getParent() instanceof RecordTypeDef) {
                LuaASTNode parent = ((RecordTypeDef)item.getParent()).getParent();
                return LuaASTUtils.isModule(luaFileAPI, parent);
            }
            return LuaASTUtils.isModuleTypeField(luaFileAPI, item);
        }
        if (node instanceof TypeDef && LuaASTUtils.isInlineTypeDef(typedef = (TypeDef)node)) {
            return LuaASTUtils.isModule(luaFileAPI, ((TypeDef)node).getParent());
        }
        return false;
    }

    public static boolean isPublic(LuaASTNode node) {
        TypeDef typedef;
        if (node instanceof Item) {
            Item item = (Item)node;
            if (LuaASTUtils.isInlineTypeField(item) && item.getParent() instanceof RecordTypeDef) {
                LuaASTNode parent = ((RecordTypeDef)item.getParent()).getParent();
                return LuaASTUtils.isPublic(parent);
            }
            return LuaASTUtils.isGlobalVariable(item) || LuaASTUtils.isTypeField(item);
        }
        if (node instanceof TypeDef && LuaASTUtils.isInlineTypeDef(typedef = (TypeDef)node)) {
            return LuaASTUtils.isPublic(((TypeDef)node).getParent());
        }
        return false;
    }

    public static boolean isPrivate(LuaASTNode node) {
        TypeDef typedef;
        if (node instanceof Item) {
            Item item = (Item)node;
            if (LuaASTUtils.isInlineTypeField(item) && item.getParent() instanceof RecordTypeDef) {
                LuaASTNode parent = ((RecordTypeDef)item.getParent()).getParent();
                return LuaASTUtils.isPrivate(parent);
            }
            return LuaASTUtils.isLocalVariable(item);
        }
        if (node instanceof TypeDef && LuaASTUtils.isInlineTypeDef(typedef = (TypeDef)node)) {
            return LuaASTUtils.isPrivate(((TypeDef)node).getParent());
        }
        return false;
    }

    public static TypeDef resolveTypeLocaly(ISourceModule sourceModule, Item item) {
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(sourceModule);
        if (luaSourceRoot != null) {
            return LuaASTUtils.resolveTypeLocaly(luaSourceRoot.getFileapi(), item);
        }
        return null;
    }

    public static TypeDef resolveTypeLocaly(LuaFileAPI luaFileAPI, Item item) {
        if (item == null) {
            return null;
        }
        TypeRef typeref = item.getType();
        if (typeref instanceof InternalTypeRef) {
            if (luaFileAPI == null) {
                return null;
            }
            InternalTypeRef internaltyperef = (InternalTypeRef)typeref;
            TypeDef typeDef = luaFileAPI.getTypes().get(internaltyperef.getTypeName());
            return typeDef;
        }
        if (typeref instanceof InlineTypeRef) {
            InlineTypeRef inlinetyperef = (InlineTypeRef)typeref;
            TypeDef typeDef = inlinetyperef.getDefinition();
            return typeDef;
        }
        return null;
    }

    public static TypeRef getModuleReturnType(LuaFileAPI luaFileAPI) {
        ArrayList<Return> returns = luaFileAPI.getReturns();
        if (returns.isEmpty()) {
            return null;
        }
        Return returnValues = returns.get(0);
        if (returnValues.getTypes().isEmpty()) {
            return null;
        }
        return returnValues.getTypes().get(0);
    }

    private static class ClosestItemVisitor
    extends ASTVisitor {
        private Item result = null;
        private int position;
        private String identifierName;

        public ClosestItemVisitor(int position, String identifierName) {
            this.position = position;
            this.identifierName = identifierName;
        }

        public Item getResult() {
            return this.result;
        }

        public boolean visit(ASTNode node) throws Exception {
            if (node instanceof LocalVar) {
                return false;
            }
            if (node instanceof Block) {
                return node.sourceStart() <= this.position && this.position <= node.sourceEnd();
            }
            return false;
        }

        public boolean endvisit(ASTNode node) throws Exception {
            if (this.result == null && node instanceof Block) {
                List<LocalVar> localVars = ((Block)node).getLocalVars();
                for (LocalVar localVar : localVars) {
                    Item item = localVar.getVar();
                    if (!item.getName().equals(this.identifierName)) continue;
                    this.result = item;
                }
                return true;
            }
            return false;
        }
    }

    public static class Definition {
        private ISourceModule module;
        private Item item;

        public Definition(ISourceModule module, Item item) {
            this.module = module;
            this.item = item;
        }

        public ISourceModule getModule() {
            return this.module;
        }

        public Item getItem() {
            return this.item;
        }
    }

    public static class TypeResolution {
        private ISourceModule module;
        private TypeDef typeDef;

        public TypeResolution(ISourceModule module, TypeDef typeDef) {
            this.module = module;
            this.typeDef = typeDef;
        }

        public ISourceModule getModule() {
            return this.module;
        }

        public TypeDef getTypeDef() {
            return this.typeDef;
        }

        public boolean equals(Object obj) {
            boolean typeDefEquality;
            boolean moduleEquality;
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeResolution typeResolution = (TypeResolution)obj;
            if (this.module == null && typeResolution.module == null) {
                moduleEquality = true;
            } else if (this.module != null && this.module.equals(typeResolution.module)) {
                moduleEquality = true;
            } else {
                return false;
            }
            if (this.typeDef == null && typeResolution.typeDef == null) {
                typeDefEquality = true;
            } else if (this.typeDef != null && this.typeDef.equals(typeResolution.typeDef)) {
                typeDefEquality = true;
            } else {
                return false;
            }
            return typeDefEquality && moduleEquality;
        }

        public int hashCode() {
            int hash = 1;
            hash = 17 * hash + (this.module == null ? 0 : this.module.hashCode());
            hash = 31 * hash + (this.typeDef == null ? 0 : this.typeDef.hashCode());
            return hash;
        }
    }
}

