/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.tools.usage.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.tigris.subversion.subclipse.tools.usage.http.HttpMessages;
import org.tigris.subversion.subclipse.tools.usage.http.IPropertiesProvider;
import org.tigris.subversion.subclipse.tools.usage.util.HttpEncodingUtils;
import org.tigris.subversion.subclipse.tools.usage.util.LoggingUtils;
import org.tigris.subversion.subclipse.tools.usage.util.StatusUtils;
import org.tigris.subversion.subclipse.tools.usage.util.reader.ReaderUtils;

public class HttpRemotePropertiesProvider
implements IPropertiesProvider {
    static final String GET_METHOD_NAME = "GET";
    protected Plugin plugin;
    private Map valuesMap;
    private String[] keys;
    private String url;
    private char valueDelimiter;

    public HttpRemotePropertiesProvider(String url, char valueDelimiter, Plugin plugin, String[] keys) {
        this.url = url;
        this.keys = keys;
        this.valueDelimiter = valueDelimiter;
        this.plugin = plugin;
    }

    public Map getMap() throws IOException {
        if (this.valuesMap == null) {
            HttpURLConnection urlConnection = this.createURLConnection(this.url);
            InputStreamReader reader = this.request(urlConnection);
            this.valuesMap = this.parse(this.keys, this.valueDelimiter, reader, new HashMap());
        }
        return this.valuesMap;
    }

    protected InputStreamReader request(HttpURLConnection urlConnection) throws IOException {
        InputStreamReader responseReader = null;
        Object[] messageArguments = new Object[]{this.url};
        try {
            urlConnection.connect();
            int responseCode = this.getResponseCode(urlConnection);
            if (responseCode == 200) {
                IStatus status = StatusUtils.getInfoStatus(this.plugin.getBundle().getSymbolicName(), HttpMessages.HttpResourceMap_Info_HttpQuery, messageArguments);
                LoggingUtils.log(status, this.plugin);
                responseReader = this.getInputStreamReader(urlConnection.getInputStream(), urlConnection.getContentType());
            } else {
                IStatus status = StatusUtils.getErrorStatus(this.plugin.getBundle().getSymbolicName(), HttpMessages.HttpGetMethod_Error_Http, null, messageArguments);
                this.plugin.getLog().log(status);
            }
            return responseReader;
        }
        catch (IOException e) {
            IStatus status = StatusUtils.getErrorStatus(this.plugin.getBundle().getSymbolicName(), HttpMessages.HttpGetMethod_Error_Http, e, messageArguments);
            this.plugin.getLog().log(status);
            throw e;
        }
    }

    private InputStreamReader getInputStreamReader(InputStream inputStream, String contentType) throws UnsupportedEncodingException, IOException {
        String contentTypeCharset = HttpEncodingUtils.getContentTypeCharset(contentType);
        if (contentTypeCharset != null && contentTypeCharset.length() > 0) {
            return new InputStreamReader((InputStream)new BufferedInputStream(inputStream), contentTypeCharset);
        }
        return new InputStreamReader(new BufferedInputStream(inputStream));
    }

    private Map parse(String[] keys, char valueDelimiter, InputStreamReader reader, Map valuesMap) throws IOException {
        String key = null;
        while ((key = ReaderUtils.skipUntil(reader, keys)) != null) {
            char[] delimiters = new char[]{valueDelimiter};
            String value = ReaderUtils.readStringUntil((Reader)reader, delimiters);
            valuesMap.put(key, value);
        }
        return valuesMap;
    }

    protected HttpURLConnection createURLConnection(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setInstanceFollowRedirects(true);
        urlConnection.setRequestMethod(GET_METHOD_NAME);
        return urlConnection;
    }

    protected int getResponseCode(HttpURLConnection urlConnection) throws IOException {
        return urlConnection.getResponseCode();
    }
}

