/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.transport.packet;

import java.io.IOException;
import org.ccdt.transport.Connection;

public abstract class PacketManager
implements Runnable {
    private final Connection c;
    private volatile Thread d;
    private volatile IOException e;

    protected PacketManager(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("You cannot create a new PacketManager with a null Connection");
        }
        this.c = connection;
    }

    public Connection getConnection() {
        return this.c;
    }

    public void disconnect(IOException iOException) {
        this.e = iOException;
        this.disconnect();
    }

    public void disconnect() {
        try {
            this.c.close();
        }
        catch (IOException iOException) {
            this.e = iOException;
        }
        if (this.d != null) {
            this.d.interrupt();
        }
    }

    public boolean isDisconnected() {
        return this.c == null || !this.c.isOpen();
    }

    public IOException getDisconnectedException() {
        return this.e;
    }

    public void setPartnerThread(Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException("You cannot send a null partner thread on the PacketManager");
        }
        this.d = thread;
    }
}

