/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.transport;

import org.ccdt.transport.Connection;
import org.ccdt.transport.exception.DisconnectedException;
import org.ccdt.transport.exception.TimeoutException;
import org.ccdt.transport.packet.Packet;
import org.ccdt.transport.packet.PacketReceiveManager;
import org.ccdt.transport.packet.PacketSendManager;
import org.ccdt.transport.packet.Response;

public class ConnectSession {
    private final PacketReceiveManager a;
    private final PacketSendManager b;

    public ConnectSession(Connection connection, String string) {
        this.a = new PacketReceiveManager(connection);
        Thread thread = new Thread((Runnable)this.a, String.valueOf(string) + " - Receive Manager");
        thread.setDaemon(true);
        this.b = new PacketSendManager(connection);
        Thread thread2 = new Thread((Runnable)this.b, String.valueOf(string) + " - Send Manager");
        thread2.setDaemon(true);
        this.a.setPartnerThread(thread2);
        this.b.setPartnerThread(thread);
        thread.start();
        thread2.start();
    }

    public void dispose() {
        this.a.disconnect();
        this.b.disconnect();
    }

    public void send(Packet packet) throws DisconnectedException {
        if (packet == null) {
            throw new IllegalArgumentException("You cannot send a null request");
        }
        this.b.sendPacket(packet);
    }

    public Response receiveResponse(int n, int n2) throws TimeoutException, DisconnectedException {
        return this.a.getResponse(n, (long)n2);
    }

    public Response receiveResponse(String string, int n) throws TimeoutException, DisconnectedException {
        return this.a.getResponse(string, (long)n);
    }

    public Packet receive(String string, int n) throws TimeoutException, DisconnectedException {
        return this.a.getCommand(string, n);
    }
}

