/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.dltk.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class NewSourceFolderWizardPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "NewSourceFolderWizardPage";
    private StringButtonDialogField fProjectField;
    private StatusInfo fProjectStatus;
    private StringButtonDialogField fRootDialogField;
    private StatusInfo fRootStatus;
    private SelectionButtonDialogField fExcludeInOthersFields;
    private IWorkspaceRoot fWorkspaceRoot;
    private IScriptProject fCurrJProject;
    private IBuildpathEntry[] fEntries;
    private IBuildpathEntry[] fNewEntries;
    private boolean fIsProjectAsSourceFolder;
    private IProjectFragment fCreatedRoot;

    public NewSourceFolderWizardPage() {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.NewSourceFolderWizardPage_title);
        this.setDescription(NewWizardMessages.NewSourceFolderWizardPage_description);
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        RootFieldAdapter adapter = new RootFieldAdapter();
        this.fProjectField = new StringButtonDialogField(adapter);
        this.fProjectField.setDialogFieldListener(adapter);
        this.fProjectField.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_project_label);
        this.fProjectField.setButtonLabel(NewWizardMessages.NewSourceFolderWizardPage_project_button);
        this.fRootDialogField = new StringButtonDialogField(adapter);
        this.fRootDialogField.setDialogFieldListener(adapter);
        this.fRootDialogField.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_root_label);
        this.fRootDialogField.setButtonLabel(NewWizardMessages.NewSourceFolderWizardPage_root_button);
        this.fExcludeInOthersFields = new SelectionButtonDialogField(32);
        this.fExcludeInOthersFields.setDialogFieldListener(adapter);
        this.fExcludeInOthersFields.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_exclude_label);
        this.fExcludeInOthersFields.setEnabled("enabled".equals(DLTKCore.getOption((String)"org.eclipse.dltk.core.buildpath.exclusionPatterns")));
        this.fRootStatus = new StatusInfo();
        this.fProjectStatus = new StatusInfo();
    }

    public void init(IStructuredSelection selection) {
        IScriptProject jproject;
        if (selection == null || selection.isEmpty()) {
            this.setDefaultAttributes();
            return;
        }
        Object selectedElement = selection.getFirstElement();
        if (selectedElement == null) {
            selectedElement = EditorUtility.getActiveEditorModelInput();
        }
        String projPath = null;
        if (selectedElement instanceof IResource) {
            IProject proj = ((IResource)selectedElement).getProject();
            if (proj != null) {
                projPath = proj.getFullPath().makeRelative().toString();
            }
        } else if (selectedElement instanceof IModelElement && (jproject = ((IModelElement)selectedElement).getScriptProject()) != null) {
            projPath = jproject.getProject().getFullPath().makeRelative().toString();
        }
        if (projPath != null) {
            this.fProjectField.setText(projPath);
            this.fRootDialogField.setText("");
        } else {
            this.setDefaultAttributes();
        }
    }

    private void setDefaultAttributes() {
        String projPath = "";
        IProject[] projects = this.fWorkspaceRoot.getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject proj = projects[i];
            if (DLTKLanguageManager.hasScriptNature((IProject)proj)) {
                projPath = proj.getFullPath().makeRelative().toString();
                break;
            }
            ++i;
        }
        this.fProjectField.setText(projPath);
        this.fRootDialogField.setText("");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.fProjectField.doFillIntoGrid(composite, 3);
        this.fRootDialogField.doFillIntoGrid(composite, 3);
        this.fExcludeInOthersFields.doFillIntoGrid(composite, 3);
        int maxFieldWidth = this.convertWidthInCharsToPixels(40);
        LayoutUtil.setWidthHint((Control)this.fProjectField.getTextControl(null), maxFieldWidth);
        LayoutUtil.setHorizontalGrabbing((Control)this.fProjectField.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.fRootDialogField.getTextControl(null), maxFieldWidth);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fRootDialogField.setFocus();
        }
    }

    protected void packRootChangeControlPressed(DialogField field) {
        IScriptProject jproject;
        if (field == this.fRootDialogField) {
            String title = NewWizardMessages.NewSourceFolderWizardPage_ChooseExistingRootDialog_title;
            String message = NewWizardMessages.NewSourceFolderWizardPage_ChooseExistingRootDialog_description;
            Path initialPath = new Path(this.fRootDialogField.getText());
            IFolder folder = this.chooseFolder(title, message, (IPath)initialPath);
            if (folder != null) {
                IPath path = folder.getFullPath().removeFirstSegments(1);
                this.fRootDialogField.setText(path.toString());
            }
        } else if (field == this.fProjectField && (jproject = this.chooseProject()) != null) {
            IPath path = jproject.getProject().getFullPath().makeRelative();
            this.fProjectField.setText(path.toString());
        }
    }

    protected void packRootDialogFieldChanged(DialogField field) {
        if (field == this.fRootDialogField) {
            this.updateRootStatus();
        } else if (field == this.fProjectField) {
            this.updateProjectStatus();
            this.updateRootStatus();
        } else if (field == this.fExcludeInOthersFields) {
            this.updateRootStatus();
        }
        this.updateStatus(new IStatus[]{this.fProjectStatus, this.fRootStatus});
    }

    private void updateProjectStatus() {
        this.fCurrJProject = null;
        this.fIsProjectAsSourceFolder = false;
        String str = this.fProjectField.getText();
        if (str.length() == 0) {
            this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_EnterProjectName);
            return;
        }
        Path path = new Path(str);
        if (path.segmentCount() != 1) {
            this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_InvalidProjectPath);
            return;
        }
        IProject project = this.fWorkspaceRoot.getProject(path.toString());
        if (!project.exists()) {
            this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_ProjectNotExists);
            return;
        }
        try {
            if (DLTKLanguageManager.hasScriptNature((IProject)project)) {
                this.fCurrJProject = DLTKCore.create((IProject)project);
                this.fEntries = this.fCurrJProject.getRawBuildpath();
                this.fProjectStatus.setOK();
                return;
            }
        }
        catch (CoreException e) {
            DLTKUIPlugin.log(e);
            this.fCurrJProject = null;
        }
        this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_NotAScriptProject);
    }

    private void updateRootStatus() {
        this.fRootDialogField.enableButton(this.fCurrJProject != null);
        this.fIsProjectAsSourceFolder = false;
        if (this.fCurrJProject == null) {
            return;
        }
        this.fRootStatus.setOK();
        IPath projPath = this.fCurrJProject.getProject().getFullPath();
        String str = this.fRootDialogField.getText();
        if (str.length() == 0) {
            this.fRootStatus.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_EnterRootName, this.fCurrJProject.getProject().getFullPath().toString()));
        } else {
            IPath path = projPath.append(str);
            IStatus validate = this.fWorkspaceRoot.getWorkspace().validatePath(path.toString(), 2);
            if (validate.matches(4)) {
                this.fRootStatus.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_InvalidRootName, validate.getMessage()));
            } else {
                IBuildpathEntry entry;
                IResource res = this.fWorkspaceRoot.findMember(path);
                if (res != null) {
                    if (res.getType() != 2) {
                        this.fRootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_NotAFolder);
                        return;
                    }
                } else {
                    URI projLocation = this.fCurrJProject.getProject().getLocationURI();
                    if (projLocation != null) {
                        try {
                            IFileStore store = EFS.getStore((URI)projLocation).getChild(str);
                            if (store.fetchInfo().exists()) {
                                this.fRootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExistingDifferentCase);
                                return;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                }
                ArrayList<IBuildpathEntry> newEntries = new ArrayList<IBuildpathEntry>(this.fEntries.length + 1);
                int projectEntryIndex = -1;
                int i = 0;
                while (i < this.fEntries.length) {
                    IBuildpathEntry curr = this.fEntries[i];
                    if (curr.getEntryKind() == 3) {
                        if (path.equals((Object)curr.getPath())) {
                            this.fRootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExisting);
                            return;
                        }
                        if (projPath.equals((Object)curr.getPath())) {
                            projectEntryIndex = i;
                        }
                    }
                    newEntries.add(curr);
                    ++i;
                }
                IBuildpathEntry newEntry = DLTKCore.newSourceEntry((IPath)path);
                HashSet<IBuildpathEntry> modified = new HashSet<IBuildpathEntry>();
                if (this.fExcludeInOthersFields.isSelected()) {
                    this.addExclusionPatterns(newEntry, newEntries, modified);
                    entry = DLTKCore.newSourceEntry((IPath)path);
                    this.insertAtEndOfCategory(entry, newEntries);
                } else if (projectEntryIndex != -1) {
                    this.fIsProjectAsSourceFolder = true;
                    newEntries.set(projectEntryIndex, newEntry);
                } else {
                    entry = DLTKCore.newSourceEntry((IPath)path);
                    this.insertAtEndOfCategory(entry, newEntries);
                }
                this.fNewEntries = newEntries.toArray(new IBuildpathEntry[newEntries.size()]);
                IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)this.fCurrJProject, (IBuildpathEntry[])this.fNewEntries);
                if (!status.isOK()) {
                    this.fRootStatus.setError(status.getMessage());
                    return;
                }
                if (this.fIsProjectAsSourceFolder) {
                    this.fRootStatus.setInfo(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceSF);
                    return;
                }
                if (!modified.isEmpty()) {
                    this.fRootStatus.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_AddedExclusions, String.valueOf(modified.size())));
                    return;
                }
            }
        }
    }

    private void insertAtEndOfCategory(IBuildpathEntry entry, List<IBuildpathEntry> entries) {
        int length = entries.size();
        IBuildpathEntry[] elements = entries.toArray(new IBuildpathEntry[length]);
        int i = 0;
        while (i < length && elements[i].getEntryKind() != entry.getEntryKind()) {
            ++i;
        }
        if (i < length) {
            ++i;
            while (i < length && elements[i].getEntryKind() == entry.getEntryKind()) {
                ++i;
            }
            entries.add(i, entry);
            return;
        }
        switch (entry.getEntryKind()) {
            case 3: {
                entries.add(0, entry);
                break;
            }
            default: {
                entries.add(entry);
            }
        }
    }

    private void addExclusionPatterns(IBuildpathEntry newEntry, List<IBuildpathEntry> existing, Set<IBuildpathEntry> modifiedEntries) {
        IPath entryPath = newEntry.getPath();
        int i = 0;
        while (i < existing.size()) {
            IPath[] exclusionFilters;
            IBuildpathEntry curr = existing.get(i);
            IPath currPath = curr.getPath();
            if (curr.getEntryKind() == 3 && currPath.isPrefixOf(entryPath) && !ScriptModelUtil.isExcludedPath((IPath)entryPath, (IPath[])(exclusionFilters = curr.getExclusionPatterns()))) {
                IPath pathToExclude = entryPath.removeFirstSegments(currPath.segmentCount()).addTrailingSeparator();
                IPath[] newExclusionFilters = new IPath[exclusionFilters.length + 1];
                System.arraycopy(exclusionFilters, 0, newExclusionFilters, 0, exclusionFilters.length);
                newExclusionFilters[exclusionFilters.length] = pathToExclude;
                IBuildpathEntry updated = DLTKCore.newSourceEntry((IPath)currPath, (IPath[])newExclusionFilters);
                existing.set(i, updated);
                modifiedEntries.add(updated);
            }
            ++i;
        }
    }

    public IProjectFragment getNewProjectFragment() {
        return this.fCreatedRoot;
    }

    public IResource getCorrespondingResource() {
        return this.fCurrJProject.getProject().getFolder(this.fRootDialogField.getText());
    }

    public void createProjectFragment(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.NewSourceFolderWizardPage_operation, 3);
        try {
            String relPath = this.fRootDialogField.getText();
            IFolder folder = this.fCurrJProject.getProject().getFolder(relPath);
            if (!folder.exists()) {
                CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            this.fCurrJProject.setRawBuildpath(this.fNewEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            this.fCreatedRoot = this.fCurrJProject.getProjectFragment((IResource)folder);
        }
        finally {
            monitor.done();
        }
    }

    private IFolder chooseFolder(String title, String message, IPath initialPath) {
        Class[] acceptedClasses = new Class[]{IFolder.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, null);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IProject currProject = this.fCurrJProject.getProject();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)currProject);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        IResource res = currProject.findMember(initialPath);
        if (res != null) {
            dialog.setInitialSelection((Object)res);
        }
        if (dialog.open() == 0) {
            return (IFolder)dialog.getFirstResult();
        }
        return null;
    }

    private IScriptProject chooseProject() {
        Object[] projects;
        try {
            projects = DLTKCore.create((IWorkspaceRoot)this.fWorkspaceRoot).getScriptProjects();
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
            projects = new IScriptProject[]{};
        }
        ModelElementLabelProvider labelProvider = new ModelElementLabelProvider(ModelElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(NewWizardMessages.NewSourceFolderWizardPage_ChooseProjectDialog_title);
        dialog.setMessage(NewWizardMessages.NewSourceFolderWizardPage_ChooseProjectDialog_description);
        dialog.setElements(projects);
        dialog.setInitialSelections(new Object[]{this.fCurrJProject});
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            return (IScriptProject)dialog.getFirstResult();
        }
        return null;
    }

    private class RootFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private RootFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            NewSourceFolderWizardPage.this.packRootChangeControlPressed(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            NewSourceFolderWizardPage.this.packRootDialogFieldChanged(field);
        }
    }
}

