/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.CompletionProposalComputerDescriptor;
import org.eclipse.dltk.ui.text.completion.CompletionProposalComputerRegistry;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.ScriptTextMessages;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.osgi.framework.Bundle;

public final class CompletionProposalCategory {
    private static final String ICON = "icon";
    private final String fId;
    private final String fName;
    private final IConfigurationElement fElement;
    private final ImageDescriptor fImage;
    private boolean fIsSeparateCommand = true;
    private boolean fIsEnabled = true;
    private boolean fIsIncluded = true;
    private final CompletionProposalComputerRegistry fRegistry;
    private int fSortOrder = 65536;
    private String fLastError = null;
    private String fToolkitID = null;

    CompletionProposalCategory(IConfigurationElement element, CompletionProposalComputerRegistry registry) {
        Bundle bundle;
        this.fElement = element;
        this.fRegistry = registry;
        IExtension parent = (IExtension)element.getParent();
        this.fId = parent.getUniqueIdentifier();
        this.checkNotNull(this.fId, "id");
        String name = parent.getLabel();
        this.fName = name == null ? this.fId : name;
        String icon = element.getAttribute(ICON);
        ImageDescriptor img = null;
        if (icon != null && (bundle = this.getBundle()) != null) {
            Path path = new Path(icon);
            URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
            img = ImageDescriptor.createFromURL((URL)url);
        }
        this.fImage = img;
        this.fToolkitID = element.getAttribute("toolkitId");
    }

    CompletionProposalCategory(String id, String name, CompletionProposalComputerRegistry registry, String toolkitID) {
        this.fRegistry = registry;
        this.fId = id;
        this.fName = name;
        this.fElement = null;
        this.fImage = null;
        this.fToolkitID = toolkitID;
    }

    private Bundle getBundle() {
        String namespace = this.fElement.getDeclaringExtension().getContributor().getName();
        Bundle bundle = Platform.getBundle((String)namespace);
        return bundle;
    }

    private void checkNotNull(Object obj, String attribute) throws InvalidRegistryObjectException {
        if (obj == null) {
            Object[] args = new Object[]{this.getId(), this.fElement.getContributor().getName(), attribute};
            String message = Messages.format(ScriptTextMessages.CompletionProposalComputerDescriptor_illegal_attribute_message, args);
            Status status = new Status(2, "org.eclipse.dltk.ui", 0, message, null);
            DLTKUIPlugin.log((IStatus)status);
            throw new InvalidRegistryObjectException();
        }
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public String getDisplayName() {
        return LegacyActionTools.removeMnemonics((String)this.fName);
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fImage;
    }

    public void setSeparateCommand(boolean enabled) {
        this.fIsSeparateCommand = enabled;
    }

    public boolean isSeparateCommand() {
        return this.fIsSeparateCommand;
    }

    public void setIncluded(boolean included) {
        this.fIsIncluded = included;
    }

    public boolean isIncluded() {
        return this.fIsIncluded;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.fIsEnabled = isEnabled;
    }

    public boolean hasComputers() {
        List<CompletionProposalComputerDescriptor> descriptors = this.fRegistry.getProposalComputerDescriptors();
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() != this) continue;
            return true;
        }
        return false;
    }

    public boolean hasComputers(String partition) {
        List<CompletionProposalComputerDescriptor> descriptors = this.fRegistry.getProposalComputerDescriptors(partition);
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() != this) continue;
            return true;
        }
        return false;
    }

    public int getSortOrder() {
        return this.fSortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.fSortOrder = sortOrder;
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, String partition, IProgressMonitor monitor) {
        this.fLastError = null;
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        ArrayList<CompletionProposalComputerDescriptor> descriptors = new ArrayList<CompletionProposalComputerDescriptor>(this.fRegistry.getProposalComputerDescriptors(partition));
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            ScriptContentAssistInvocationContext scriptContext;
            if (context instanceof ScriptContentAssistInvocationContext && !(scriptContext = (ScriptContentAssistInvocationContext)context).getLanguageNatureID().equals(desc.getLanguageToolkitID())) continue;
            if (desc.getCategory() == this) {
                result.addAll(desc.computeCompletionProposals(context, monitor));
            }
            if (this.fLastError != null) continue;
            this.fLastError = desc.getErrorMessage();
        }
        return result;
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, String partition, IProgressMonitor monitor) {
        System.err.println("run");
        this.fLastError = null;
        ArrayList<IContextInformation> result = new ArrayList<IContextInformation>();
        ArrayList<CompletionProposalComputerDescriptor> descriptors = new ArrayList<CompletionProposalComputerDescriptor>(this.fRegistry.getProposalComputerDescriptors(partition));
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            ScriptContentAssistInvocationContext scriptContext;
            if (context instanceof ScriptContentAssistInvocationContext && !(scriptContext = (ScriptContentAssistInvocationContext)context).getLanguageNatureID().equals(desc.getLanguageToolkitID())) continue;
            if (desc.getCategory() == this) {
                result.addAll(desc.computeContextInformation(context, monitor));
            }
            if (this.fLastError != null) continue;
            this.fLastError = desc.getErrorMessage();
        }
        return result;
    }

    public String getErrorMessage() {
        return this.fLastError;
    }

    public void sessionStarted() {
        ArrayList<CompletionProposalComputerDescriptor> descriptors = new ArrayList<CompletionProposalComputerDescriptor>(this.fRegistry.getProposalComputerDescriptors());
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() == this) {
                desc.sessionStarted();
            }
            if (this.fLastError != null) continue;
            this.fLastError = desc.getErrorMessage();
        }
    }

    public void sessionEnded() {
        ArrayList<CompletionProposalComputerDescriptor> descriptors = new ArrayList<CompletionProposalComputerDescriptor>(this.fRegistry.getProposalComputerDescriptors());
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() == this) {
                desc.sessionEnded();
            }
            if (this.fLastError != null) continue;
            this.fLastError = desc.getErrorMessage();
        }
    }

    public String getToolkitID() {
        return this.fToolkitID;
    }
}

