/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text.hover;

import org.eclipse.dltk.internal.ui.text.hover.AbstractScriptEditorTextHover;
import org.eclipse.dltk.internal.ui.text.hover.EditorTextHoverDescriptor;
import org.eclipse.dltk.ui.text.hover.IScriptEditorTextHover;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.IEditorPart;

public class EditorTextHoverProxy
extends AbstractScriptEditorTextHover
implements ITextHoverExtension,
ITextHoverExtension2,
IInformationProviderExtension2 {
    private EditorTextHoverDescriptor fHoverDescriptor;
    private IScriptEditorTextHover fHover;

    public EditorTextHoverProxy(EditorTextHoverDescriptor descriptor, IEditorPart editor, IPreferenceStore store) {
        this.fHoverDescriptor = descriptor;
        this.setEditor(editor);
        this.setPreferenceStore(store);
    }

    @Override
    public void setPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
        if (this.fHover != null) {
            this.fHover.setPreferenceStore(this.getPreferenceStore());
        }
    }

    @Override
    public void setEditor(IEditorPart editor) {
        super.setEditor(editor);
        if (this.fHover != null) {
            this.fHover.setEditor(this.getEditor());
        }
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (this.ensureHoverCreated()) {
            return this.fHover.getHoverRegion(textViewer, offset);
        }
        return null;
    }

    @Override
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.ensureHoverCreated()) {
            return this.fHover.getHoverInfo(textViewer, hoverRegion);
        }
        return null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        if (!this.ensureHoverCreated()) {
            return null;
        }
        if (this.fHover instanceof ITextHoverExtension2) {
            return ((ITextHoverExtension2)this.fHover).getHoverInfo2(textViewer, hoverRegion);
        }
        return this.fHover.getHoverInfo(textViewer, hoverRegion);
    }

    private boolean ensureHoverCreated() {
        if (!this.isEnabled() || this.fHoverDescriptor == null) {
            return false;
        }
        return this.isCreated() || this.createHover();
    }

    private boolean isCreated() {
        return this.fHover != null;
    }

    private boolean createHover() {
        this.fHover = this.fHoverDescriptor.createTextHover();
        if (this.fHover != null) {
            this.fHover.setEditor(this.getEditor());
            this.fHover.setPreferenceStore(this.getPreferenceStore());
        }
        return this.isCreated();
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        if (this.ensureHoverCreated() && this.fHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fHover).getHoverControlCreator();
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.ensureHoverCreated() && this.fHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fHover).getInformationPresenterControlCreator();
        }
        return null;
    }
}

