/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text.hover;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.text.hover.AbstractScriptEditorTextHover;
import org.eclipse.dltk.internal.ui.text.hover.EditorTextHoverDescriptor;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.hover.IScriptEditorTextHover;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.IEditorPart;

public class BestMatchHover
extends AbstractScriptEditorTextHover
implements ITextHoverExtension,
ITextHoverExtension2,
IInformationProviderExtension2 {
    private List<EditorTextHoverDescriptor> fTextHoverSpecifications = null;
    private List<ITextHover> fInstantiatedTextHovers;
    private ITextHover fBestHover;

    public BestMatchHover() {
    }

    public BestMatchHover(IEditorPart editor, IPreferenceStore store) {
        this.setEditor(editor);
        this.setPreferenceStore(store);
    }

    private void installTextHovers() {
        this.fTextHoverSpecifications = new ArrayList<EditorTextHoverDescriptor>(8);
        this.fInstantiatedTextHovers = new ArrayList<ITextHover>(8);
        EditorTextHoverDescriptor[] hoverDescs = DLTKUIPlugin.getDefault().getEditorTextHoverDescriptors(this.getPreferenceStore(), this.getNatureId());
        int i = 0;
        while (i < hoverDescs.length) {
            if (!"org.eclipse.dltk.ui.BestMatchHover".equals(hoverDescs[i].getId())) {
                this.fTextHoverSpecifications.add(hoverDescs[i]);
            }
            ++i;
        }
    }

    private String getNatureId() {
        IEditorPart editor = this.getEditor();
        if (editor == null || !(editor instanceof ScriptEditor)) {
            return null;
        }
        return ((ScriptEditor)editor).getLanguageToolkit().getNatureId();
    }

    private void checkTextHovers() {
        if (this.fTextHoverSpecifications == null) {
            this.installTextHovers();
        }
        if (this.fTextHoverSpecifications.isEmpty()) {
            return;
        }
        EditorTextHoverDescriptor[] editorTextHoverDescriptorArray = this.fTextHoverSpecifications.toArray(new EditorTextHoverDescriptor[this.fTextHoverSpecifications.size()]);
        int n = editorTextHoverDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditorTextHoverDescriptor spec = editorTextHoverDescriptorArray[n2];
            IScriptEditorTextHover hover = spec.createTextHover();
            if (hover != null) {
                hover.setEditor(this.getEditor());
                hover.setPreferenceStore(this.getPreferenceStore());
                this.addTextHover(hover);
                this.fTextHoverSpecifications.remove(spec);
            }
            ++n2;
        }
    }

    protected void addTextHover(ITextHover hover) {
        if (!this.fInstantiatedTextHovers.contains(hover)) {
            this.fInstantiatedTextHovers.add(hover);
        }
    }

    @Override
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        for (ITextHover hover : this.fInstantiatedTextHovers) {
            String s = hover.getHoverInfo(textViewer, hoverRegion);
            if (s == null || s.trim().length() <= 0) continue;
            this.fBestHover = hover;
            return s;
        }
        return null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        for (ITextHover hover : this.fInstantiatedTextHovers) {
            Object result = hover instanceof ITextHoverExtension2 ? ((ITextHoverExtension2)hover).getHoverInfo2(textViewer, hoverRegion) : hover.getHoverInfo(textViewer, hoverRegion);
            if (result == null) continue;
            if (result instanceof String && result.toString().length() == 0) {
                return null;
            }
            this.fBestHover = hover;
            return result;
        }
        return null;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        if (this.fBestHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fBestHover).getHoverControlCreator();
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fBestHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fBestHover).getInformationPresenterControlCreator();
        }
        return null;
    }
}

