/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.core.model;

import com.boothen.jsonedit.core.editors.JsonTextEditor;
import com.boothen.jsonedit.core.model.jsonnode.JsonNodeBuilder;
import com.boothen.jsonedit.core.model.node.NodeBuilder;
import com.boothen.jsonedit.folding.JsonFoldingPositionsBuilder;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.widgets.Display;

public class JsonReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private JsonTextEditor textEditor;
    private IDocument fDocument;

    public void reconcile(IRegion partition) {
        this.initialReconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.initialReconcile();
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public void initialReconcile() {
        this.parse();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    private void parse() {
        final List nodes = new NodeBuilder(this.fDocument).buildNodes();
        final List jsonNodes = new JsonNodeBuilder(this.fDocument, nodes).buildJsonNodes();
        final List fPositions = new JsonFoldingPositionsBuilder(jsonNodes).buildFoldingPositions();
        if (this.textEditor != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    JsonReconcilingStrategy.this.textEditor.updateFoldingStructure(fPositions);
                    JsonReconcilingStrategy.this.textEditor.updateContentOutlinePage(jsonNodes, nodes);
                }
            });
        }
    }

    public void setTextEditor(JsonTextEditor textEditor) {
        this.textEditor = textEditor;
    }
}

