/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.core.handlers;

import com.boothen.jsonedit.core.editors.JsonPageEditor;
import com.boothen.jsonedit.core.editors.JsonTextEditor;
import com.boothen.jsonedit.preferences.JsonPreferenceStore;
import com.boothen.jsonedit.text.JsonTextFormatter;
import com.boothen.jsonedit.text.LineEndingUtil;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class FormatTextHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(editor instanceof JsonPageEditor)) {
            return null;
        }
        JsonTextEditor textEditor = (JsonTextEditor)((JsonPageEditor)editor).getEditor();
        JsonPreferenceStore store = new JsonPreferenceStore();
        boolean spaces = store.getSpacesForTab();
        int numSpaces = store.getTabWidth();
        FormatTextHandler.formatText(textEditor, spaces, numSpaces);
        return null;
    }

    public static void formatText(JsonTextEditor textEditor, boolean spaces, int numSpaces) {
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        String text = document.get();
        IFile file = (IFile)textEditor.getEditorInput().getAdapter(IFile.class);
        String lineEnding = LineEndingUtil.determineProjectLineEnding((IFile)file);
        JsonTextFormatter textFormatter = new JsonTextFormatter(text, spaces, numSpaces, lineEnding);
        textEditor.storeOutlineState();
        textEditor.storeTextLocation();
        textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput()).set(textFormatter.formatText());
        textEditor.getFOutlinePage().update();
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

