/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.core.editors.listeners;

import com.boothen.jsonedit.core.editors.JsonSourceViewerConfiguration;
import com.boothen.jsonedit.preferences.JsonPreferenceStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PlatformPreferenceListener
implements IEclipsePreferences.IPreferenceChangeListener,
IPropertyChangeListener {
    private JsonSourceViewerConfiguration viewerConfiguration;
    private JsonPreferenceStore jsonPreferenceStore;
    private IEclipsePreferences iEclipsePreferences;

    public PlatformPreferenceListener(JsonSourceViewerConfiguration viewerConfiguration, JsonPreferenceStore jsonPreferenceStore) {
        this.viewerConfiguration = viewerConfiguration;
        this.jsonPreferenceStore = jsonPreferenceStore;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        this.viewerConfiguration.handlePreferenceStoreChanged();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.viewerConfiguration.handlePreferenceStoreChanged();
        this.jsonPreferenceStore.updateEditorPreferences();
    }

    public void setPreferenceChangeListener(IFile file) {
        if (file != null) {
            this.iEclipsePreferences = new ProjectScope(file.getProject()).getNode("org.eclipse.core.runtime");
            this.iEclipsePreferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        JsonPreferenceStore.getEditorPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void removePreferenceChangeListener() {
        if (this.iEclipsePreferences != null) {
            this.iEclipsePreferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        JsonPreferenceStore.getEditorPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

