/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.core.editors;

import com.boothen.jsonedit.core.editors.JsonSourceViewerConfiguration;
import com.boothen.jsonedit.core.editors.listeners.PlatformPreferenceListener;
import com.boothen.jsonedit.core.handlers.FormatTextHandler;
import com.boothen.jsonedit.core.model.jsonnode.JsonNode;
import com.boothen.jsonedit.core.model.node.Node;
import com.boothen.jsonedit.outline.JsonContentOutlinePage;
import com.boothen.jsonedit.preferences.JsonPreferenceStore;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class JsonTextEditor
extends TextEditor {
    private static final char[] PAIRS = new char[]{'{', '}', '[', ']'};
    private DefaultCharacterPairMatcher pairsMatcher = new DefaultCharacterPairMatcher(PAIRS);
    private JsonSourceViewerConfiguration viewerConfiguration;
    private JsonContentOutlinePage fOutlinePage;
    private PlatformPreferenceListener platformPreferenceListener;
    private ProjectionAnnotationModel annotationModel;
    private ProjectionAnnotation[] oldAnnotations;
    private boolean[] annotationCollapsedState;
    private boolean restoreCursorLocation = false;
    private int nodePositionOffset = 0;
    private int nodePosition = 0;
    private List<Node> nodes;

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.pairsMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("matchingBrackets", "matchingBracketsColor");
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId("#JsonTextEditorContext");
        this.setRulerContextMenuId("#JsonTextRulerContext");
        this.setPreferenceStore(JsonPreferenceStore.getChainedPreferenceStore());
    }

    public void dispose() {
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setInput(null);
        }
        if (this.pairsMatcher != null) {
            this.pairsMatcher.dispose();
            this.pairsMatcher = null;
        }
        if (this.platformPreferenceListener != null) {
            this.platformPreferenceListener.removePreferenceChangeListener();
        }
        super.dispose();
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.doAutoFormatOnSave();
        super.doSave(monitor);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSaveAs() {
        this.doAutoFormatOnSave();
        super.doSaveAs();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    private void doAutoFormatOnSave() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean autoFormatOnSave = store.getBoolean("autoFormatOnSave");
        if (autoFormatOnSave) {
            boolean spaces = store.getBoolean("spaces_for_tabs");
            int numSpaces = store.getInt("num_spaces");
            FormatTextHandler.formatText(this, spaces, numSpaces);
        }
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setInput((Object)input);
        }
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new JsonContentOutlinePage(this.getDocumentProvider(), (ITextEditor)this);
                if (this.getEditorInput() != null) {
                    this.fOutlinePage.setInput((Object)this.getEditorInput());
                }
            }
            return this.fOutlinePage;
        }
        return super.getAdapter(required);
    }

    public void createPartControl(Composite parent) {
        JsonPreferenceStore jsonPreferenceStore = new JsonPreferenceStore();
        this.viewerConfiguration = new JsonSourceViewerConfiguration(this, jsonPreferenceStore);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.viewerConfiguration);
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        ProjectionSupport projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
        SourceViewerDecorationSupport support = this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        support.install(this.getPreferenceStore());
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        this.platformPreferenceListener = new PlatformPreferenceListener(this.viewerConfiguration, jsonPreferenceStore);
        this.platformPreferenceListener.setPreferenceChangeListener(file);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        this.viewerConfiguration.handlePreferenceStoreChanged();
        super.handlePreferenceStoreChanged(event);
    }

    public void updateFoldingStructure(List<Position> positions) {
        ProjectionAnnotation[] annotations = new ProjectionAnnotation[positions.size()];
        HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
        int i = 0;
        while (i < positions.size()) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            newAnnotations.put(annotation, positions.get(i));
            annotations[i] = annotation;
            if (this.annotationCollapsedState != null && this.annotationCollapsedState.length > i && this.annotationCollapsedState[i]) {
                annotation.markCollapsed();
            }
            ++i;
        }
        this.annotationModel.modifyAnnotations((Annotation[])this.oldAnnotations, newAnnotations, null);
        this.oldAnnotations = annotations;
    }

    public JsonContentOutlinePage getFOutlinePage() {
        return this.fOutlinePage;
    }

    public void updateContentOutlinePage(List<JsonNode> jsonNodes, List<Node> nodes) {
        this.nodes = nodes;
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setJsonNodes(jsonNodes);
        }
        this.restoreTextLocation();
    }

    public void storeOutlineState() {
        if (this.oldAnnotations != null) {
            this.annotationCollapsedState = new boolean[this.oldAnnotations.length];
            int i = 0;
            while (i < this.oldAnnotations.length) {
                this.annotationCollapsedState[i] = this.oldAnnotations[i].isCollapsed();
                ++i;
            }
        }
    }

    public void storeTextLocation() {
        ITextSelection iTextSelection = (ITextSelection)this.getSite().getSelectionProvider().getSelection();
        int textLocation = iTextSelection.getOffset();
        if (this.nodes != null) {
            int i = 0;
            while (i < this.nodes.size()) {
                Node node = this.nodes.get(i);
                if (node.getPosition().includes(textLocation)) {
                    this.nodePosition = i;
                    this.nodePositionOffset = textLocation - node.getPosition().getOffset();
                    break;
                }
                ++i;
            }
        }
        this.restoreCursorLocation = true;
    }

    public void restoreTextLocation() {
        Node node;
        if (!this.restoreCursorLocation) {
            return;
        }
        this.restoreCursorLocation = false;
        ITextOperationTarget target = (ITextOperationTarget)this.getAdapter(ITextOperationTarget.class);
        if (!(target instanceof ITextViewer)) {
            return;
        }
        ITextViewer textViewer = (ITextViewer)target;
        if (this.nodes != null && this.nodes.size() > this.nodePosition && (node = this.nodes.get(this.nodePosition)) != null) {
            int textLocation = node.getPosition().getOffset() + this.nodePositionOffset;
            textViewer.getTextWidget().setSelection(textLocation);
        }
    }

    public void updateTabWidth(int tabWidth) {
        this.getSourceViewer().getTextWidget().setTabs(tabWidth);
    }
}

