/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.core.editors;

import com.boothen.jsonedit.core.editors.JsonTextEditor;
import com.boothen.jsonedit.core.model.JsonReconcilingStrategy;
import com.boothen.jsonedit.preferences.JsonPreferenceStore;
import com.boothen.jsonedit.text.JsonIndentLineAutoEditStrategy;
import com.boothen.jsonedit.text.JsonScanner;
import com.boothen.jsonedit.text.LineEndingUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class JsonSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private JsonTextEditor textEditor;
    private JsonIndentLineAutoEditStrategy jsonIndentLineAutoEditStrategy;
    private JsonScanner jsonScanner;
    private JsonPreferenceStore store;

    public JsonSourceViewerConfiguration(JsonTextEditor textEditor, JsonPreferenceStore store) {
        this.store = store;
        this.textEditor = textEditor;
        boolean spaces = store.getSpacesForTab();
        int numSpaces = store.getTabWidth();
        String lineEnding = this.getTextEditorLineEnding();
        this.jsonIndentLineAutoEditStrategy = new JsonIndentLineAutoEditStrategy(spaces, numSpaces, lineEnding);
        this.jsonScanner = new JsonScanner();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.jsonScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        JsonReconcilingStrategy strategy = new JsonReconcilingStrategy();
        strategy.setTextEditor(this.textEditor);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        return reconciler;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{this.jsonIndentLineAutoEditStrategy};
    }

    public void handlePreferenceStoreChanged() {
        boolean spacesForTab = this.store.getSpacesForTab();
        int tabWidth = this.store.getTabWidth();
        String lineEnding = this.getTextEditorLineEnding();
        this.textEditor.updateTabWidth(tabWidth);
        this.jsonIndentLineAutoEditStrategy.initPreferences(spacesForTab, tabWidth, lineEnding);
        this.jsonScanner.reinitScanner();
    }

    private String getTextEditorLineEnding() {
        IFile file = (IFile)this.textEditor.getEditorInput().getAdapter(IFile.class);
        return LineEndingUtil.determineProjectLineEnding((IFile)file);
    }
}

