/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.repo;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.team.core.TeamException;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNStatus;
import org.tigris.subversion.subclipse.core.client.NotificationListener;
import org.tigris.subversion.subclipse.core.repo.IUserInfo;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNRepositoryLocation
implements ISVNRepositoryLocation,
IUserInfo,
IAdaptable {
    public static final String PREF_REPOSITORIES_NODE = "repositories";
    private static final String DEFAULT_REPOSITORY_SETTINGS_NODE = "default_repository_settings";
    public static final String PREF_LOCATION = "location";
    public static final String PREF_SERVER_ENCODING = "encoding";
    private String label = null;
    private String user;
    private SVNUrl url;
    private SVNUrl repositoryRootUrl;
    private RemoteFolder rootFolder;
    public static final String INFO_PASSWORD = "org.tigris.subversion.subclipse.core.password";
    public static final String INFO_USERNAME = "org.tigris.subversion.subclipse.core.username";
    public static final String AUTH_SCHEME = "";
    public static final URL FAKE_URL;
    public static final String USER_VARIABLE = "{user}";
    public static final String PASSWORD_VARIABLE = "{password}";
    public static final String HOST_VARIABLE = "{host}";
    public static final String PORT_VARIABLE = "{port}";

    static {
        URL temp = null;
        try {
            temp = new URL("http://org.tigris.subversion.subclipse.core");
        }
        catch (MalformedURLException malformedURLException) {}
        FAKE_URL = temp;
    }

    public static Preferences getParentPreferences() {
        return SVNProviderPlugin.getPlugin().getInstancePreferences().node(PREF_REPOSITORIES_NODE);
    }

    public static Preferences getDefaultPreferences() {
        Preferences defaults = new DefaultScope().getNode("org.tigris.subversion.subclipse.core").node(DEFAULT_REPOSITORY_SETTINGS_NODE);
        defaults.put(PREF_SERVER_ENCODING, SVNRepositoryLocation.getDefaultEncoding());
        return defaults;
    }

    private static String getDefaultEncoding() {
        return System.getProperty("file.encoding", "UTF-8");
    }

    private SVNRepositoryLocation(String user, String password, SVNUrl url, SVNUrl repositoryRootUrl) {
        this.user = user;
        this.url = url;
        this.repositoryRootUrl = repositoryRootUrl;
        this.rootFolder = new RemoteFolder(this, url, SVNRevision.HEAD);
    }

    public void dispose() throws SVNException {
        try {
            if (this.hasPreferences()) {
                this.internalGetPreferences().removeNode();
                SVNRepositoryLocation.getParentPreferences().flush();
            }
        }
        catch (BackingStoreException e) {
            SVNProviderPlugin.log(SVNException.wrapException((Exception)((Object)e)));
        }
    }

    public SVNUrl getUrl() {
        return this.url;
    }

    public String getLocation() {
        return this.getUrl().toString();
    }

    public ISVNRemoteFolder getRootFolder() {
        return this.rootFolder;
    }

    public void refreshRootFolder() {
        this.rootFolder.refresh();
    }

    public ISVNRemoteResource[] members(IProgressMonitor progress) throws SVNException {
        try {
            ISVNRemoteResource[] resources = this.getRootFolder().members(progress);
            return resources;
        }
        catch (TeamException e) {
            throw new SVNException(e.getStatus());
        }
    }

    public ISVNRemoteFolder getRemoteFolder(String remotePath) {
        return new RemoteFolder(this, this.getUrl().appendPath(remotePath), SVNRevision.HEAD);
    }

    public ISVNRemoteFile getRemoteFile(SVNUrl url) throws SVNException {
        ISVNClientAdapter svnClient = this.getSVNClient();
        ISVNInfo info = null;
        try {
            if (this.getRepositoryRoot().equals((Object)url)) {
                return new RemoteFile(this, url, SVNRevision.HEAD);
            }
            info = svnClient.getInfo(url, SVNRevision.HEAD, SVNRevision.HEAD);
        }
        catch (SVNClientException sVNClientException) {
            throw new SVNException("Can't get latest remote resource for " + url);
        }
        if (info == null) {
            return null;
        }
        return new RemoteFile(null, this, url, SVNRevision.HEAD, info.getLastChangedRevision(), info.getLastChangedDate(), info.getLastCommitAuthor());
    }

    public ISVNRemoteFile getRemoteFile(String remotePath) throws SVNException {
        return this.getRemoteFile(this.getUrl().appendPath(remotePath));
    }

    public String getUsername() {
        return this.user == null ? AUTH_SCHEME : this.user;
    }

    public ISVNClientAdapter getSVNClient() throws SVNException {
        ISVNClientAdapter svnClient = SVNProviderPlugin.getPlugin().getSVNClient();
        svnClient.addNotifyListener((ISVNNotifyListener)NotificationListener.getInstance());
        return svnClient;
    }

    public void returnSVNClient(ISVNClientAdapter client) {
        SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
    }

    public String toString() {
        if (this.getLabel() != null) {
            return this.getLabel();
        }
        return this.getLocation();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SVNRepositoryLocation)) {
            return false;
        }
        return this.getLocation().equals(((SVNRepositoryLocation)o).getLocation());
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    public void setPassword(String password) {
    }

    public void setUsername(String user) {
    }

    public void updateCache() throws SVNException {
    }

    public void validateConnection(IProgressMonitor monitor) throws SVNException {
        ISVNClientAdapter svnClient = this.getSVNClient();
        try {
            ISVNInfo info = svnClient.getInfo(this.getUrl());
            this.repositoryRootUrl = info.getRepository();
        }
        catch (SVNClientException e) {
            this.dispose();
            throw SVNException.wrapException((Exception)((Object)e));
        }
    }

    public boolean pathExists() throws SVNException {
        ISVNClientAdapter svnClient = this.getSVNClient();
        try {
            svnClient.getList(this.getUrl(), SVNRevision.HEAD, false);
        }
        catch (SVNClientException sVNClientException) {
            return false;
        }
        return true;
    }

    public static SVNRepositoryLocation fromProperties(Properties configuration) throws SVNException {
        String url;
        String rootUrl;
        String user = configuration.getProperty("user");
        if (user == null || user.length() == 0) {
            user = null;
        }
        String password = configuration.getProperty("password");
        if (user == null) {
            password = null;
        }
        if ((rootUrl = configuration.getProperty("rootUrl")) == null || rootUrl.length() == 0) {
            rootUrl = null;
        }
        if ((url = configuration.getProperty("url")) == null) {
            throw new SVNException((IStatus)new Status(4, "org.tigris.subversion.subclipse.core", -6, Policy.bind("SVNRepositoryLocation.hostRequired"), null));
        }
        SVNUrl urlURL = null;
        try {
            urlURL = new SVNUrl(url);
        }
        catch (MalformedURLException e) {
            throw new SVNException(e.getMessage());
        }
        SVNUrl rootUrlURL = null;
        if (rootUrl != null) {
            try {
                rootUrlURL = new SVNUrl(rootUrl);
            }
            catch (MalformedURLException e) {
                throw new SVNException(e.getMessage());
            }
        }
        return new SVNRepositoryLocation(user, password, urlURL, rootUrlURL);
    }

    public static SVNRepositoryLocation fromString(String location) throws SVNException {
        try {
            return SVNRepositoryLocation.fromString(location, false);
        }
        catch (SVNException e) {
            MultiStatus error = new MultiStatus("org.tigris.subversion.subclipse.core", 4, Policy.bind("SVNRepositoryLocation.invalidFormat", new Object[]{location}), null);
            error.merge((IStatus)new SVNStatus(4, Policy.bind("SVNRepositoryLocation.locationForm")));
            error.merge(e.getStatus());
            throw new SVNException((IStatus)error);
        }
    }

    public static SVNRepositoryLocation fromString(String location, boolean validateOnly) throws SVNException {
        String partId = null;
        try {
            String user = null;
            String password = null;
            SVNUrl rootUrl = null;
            SVNUrl url = new SVNUrl(location);
            if (validateOnly) {
                throw new SVNException((IStatus)new SVNStatus(0, Policy.bind("ok")));
            }
            return new SVNRepositoryLocation(user, password, url, rootUrl);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SVNException(Policy.bind(partId));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SVNException(Policy.bind(partId));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SVNException(Policy.bind(partId));
        }
    }

    public static SVNRepositoryLocation fromString(String location, boolean validateOnly, boolean useRootUrl) throws SVNException {
        if (!useRootUrl) {
            return SVNRepositoryLocation.fromString(location, validateOnly);
        }
        ISVNClientAdapter svnClient = SVNProviderPlugin.getPlugin().getSVNClient();
        try {
            SVNUrl url = new SVNUrl(location);
            ISVNInfo info = svnClient.getInfo(url);
            SVNUrl rootUrl = info.getRepository();
            SVNRepositoryLocation sVNRepositoryLocation = SVNRepositoryLocation.fromString(rootUrl.toString());
            return sVNRepositoryLocation;
        }
        catch (MalformedURLException e) {
            throw SVNException.wrapException(e);
        }
        catch (SVNClientException e) {
            throw SVNException.wrapException((Exception)((Object)e));
        }
        finally {
            SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(svnClient);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISVNRemoteFolder.class) {
            return this.rootFolder;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public SVNUrl getRepositoryRoot() {
        if (this.repositoryRootUrl == null) {
            return this.getUrl();
        }
        return this.repositoryRootUrl;
    }

    public void setRepositoryRoot(SVNUrl url) {
        this.repositoryRootUrl = url;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Preferences getPreferences() {
        if (!this.hasPreferences()) {
            this.ensurePreferencesStored();
        }
        return this.internalGetPreferences();
    }

    private Preferences internalGetPreferences() {
        return SVNRepositoryLocation.getParentPreferences().node(this.getPreferenceName());
    }

    private boolean hasPreferences() {
        try {
            return SVNRepositoryLocation.getParentPreferences().nodeExists(this.getPreferenceName());
        }
        catch (Exception e) {
            SVNProviderPlugin.log(SVNException.wrapException(e));
            return false;
        }
    }

    private String getPreferenceName() {
        return this.getLocation().replace('/', '%').replace(':', '%');
    }

    public void storePreferences() {
        Preferences prefs = this.internalGetPreferences();
        prefs.put(PREF_LOCATION, this.getLocation());
        this.flushPreferences();
    }

    private void flushPreferences() {
        try {
            this.internalGetPreferences().flush();
        }
        catch (BackingStoreException e) {
            SVNProviderPlugin.log(SVNException.wrapException((Exception)((Object)e)));
        }
    }

    public void setUrl(SVNUrl url) {
        this.url = url;
    }

    private void ensurePreferencesStored() {
        if (!this.hasPreferences()) {
            this.storePreferences();
        }
    }
}

