/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.simpleview.service;

import org.ccdt.common.logger.CocosLogger;
import org.ccdt.common.ui.handlers.WorkbenchHandler;
import org.ccdt.simpleview.build.LocalElementBuilder;
import org.ccdt.simpleview.element.Element;
import org.ccdt.simpleview.element.ServerElement;
import org.ccdt.simpleview.manager.BuilderManager;
import org.ccdt.simpleview.manager.MatcherManager;
import org.ccdt.simpleview.matcher.LocalMatcher;
import org.ccdt.simpleview.matcher.MatchParam;
import org.ccdt.simpleview.service.HTTPService;
import org.ccdt.simpleview.service.IService;
import org.ccdt.simpleview.service.request.IRequest;
import org.ccdt.simpleview.service.request.PreviewRquest;
import org.ccdt.simpleview.view.SimpleView;
import org.ccdt.simpleview.view.input.SimpleViewInput;
import org.ccdt.simpleview.view.input.SimpleViewServerInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public final class PreviewService
implements IService {
    private static PreviewService instance;
    private MatcherManager matcherManager;
    private BuilderManager buildManager;
    private HTTPService httpService = new HTTPService();
    private IRequest currRequest;

    private PreviewService() {
    }

    public static synchronized PreviewService getInstance() {
        if (instance == null) {
            instance = new PreviewService();
        }
        return instance;
    }

    @Override
    public void start() {
        this.matcherManager = new MatcherManager();
        this.buildManager = new BuilderManager();
        this.matcherManager.addMatcher(new LocalMatcher());
        this.buildManager.addElementBuilder(new LocalElementBuilder());
    }

    @Override
    public void stop() {
        CocosLogger.LOG.info((Object)"stop preview service");
        this.matcherManager = null;
        this.buildManager = null;
        this.currRequest = null;
        this.httpService.stop();
    }

    public MatcherManager getMatcherManager() {
        return this.matcherManager;
    }

    public BuilderManager getBuildManager() {
        return this.buildManager;
    }

    @Override
    public boolean isActive() {
        return this.matcherManager != null && this.buildManager != null;
    }

    @Override
    public void service(final IRequest request) {
        this.currRequest = request;
        Job job = new Job("preview request processing"){

            protected IStatus run(IProgressMonitor monitor) {
                SimpleViewInput input;
                if (!(request instanceof PreviewRquest)) {
                    CocosLogger.getLogger(((Object)((Object)this)).getClass()).info((Object)("unexpected request :" + request));
                    return Status.CANCEL_STATUS;
                }
                CocosLogger.getLogger(((Object)((Object)this)).getClass()).info((Object)("preview service accept request:" + request));
                if (!PreviewService.this.isActive()) {
                    CocosLogger.getLogger(((Object)((Object)this)).getClass()).error((Object)("request " + request + " refused, preview service is not alive"));
                    return Status.CANCEL_STATUS;
                }
                PreviewRquest previewRequest = (PreviewRquest)request;
                Element element = PreviewService.this.matcherManager.match(new MatchParam(previewRequest.getIndexFilePath(), previewRequest.getRootFilePath()));
                if (element == null) {
                    return Status.CANCEL_STATUS;
                }
                CocosLogger.getLogger(((Object)((Object)this)).getClass()).info((Object)("match element :" + element));
                if (element instanceof ServerElement) {
                    ((ServerElement)element).setRootPath(previewRequest.getRootFilePath());
                }
                if ((input = PreviewService.this.buildManager.build(element)) instanceof SimpleViewServerInput) {
                    if (!PreviewService.this.httpService.isActive()) {
                        PreviewService.this.httpService.start();
                    }
                    if (!PreviewService.this.httpService.isActive()) {
                        CocosLogger.getLogger(((Object)((Object)this)).getClass()).error((Object)"http service is not active.");
                        return Status.CANCEL_STATUS;
                    }
                    SimpleViewServerInput serverInput = (SimpleViewServerInput)input;
                    PreviewService.this.httpService.setResourceHandler(serverInput.getResourceHandler());
                    serverInput.setLocalhost(PreviewService.this.httpService.getHost());
                    serverInput.setPort(PreviewService.this.httpService.getPort());
                }
                if (input == null) {
                    return Status.CANCEL_STATUS;
                }
                if (PreviewService.this.currRequest != request) {
                    return Status.CANCEL_STATUS;
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPart part = WorkbenchHandler.instance.getActiveWorkbenchPage().getActivePart();
                        SimpleView view = (SimpleView)WorkbenchHandler.instance.showView("org.ccdt.simpleview");
                        if (view != null) {
                            view.refresh(input);
                        }
                        if (part instanceof IViewPart) {
                            part.setFocus();
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

