/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.simpleview.service;

import java.io.IOException;
import java.net.ServerSocket;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.simpleview.server.HTTPResourceHandler;
import org.ccdt.simpleview.server.HTTPServer;
import org.ccdt.simpleview.service.IService;
import org.ccdt.simpleview.service.request.IRequest;

public class HTTPService
implements IService {
    private static final int INVALID_PORT = -1;
    private static final int MIN_PORT = 8088;
    private static final int MAX_PORT = 65000;
    private static final String host = "127.0.0.1";
    private int port = -1;
    private HTTPServer server;

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return host;
    }

    public HTTPServer getServer() {
        return this.server;
    }

    public int getUsablePort() {
        ServerSocket testSoket = null;
        int port = 8088;
        while (port < 65000) {
            try {
                testSoket = new ServerSocket(port);
                testSoket.close();
                return port;
            }
            catch (IOException iOException) {
                ++port;
            }
        }
        return -1;
    }

    public void setResourceHandler(HTTPResourceHandler resourceHandler) {
        if (this.server != null) {
            this.server.setResourceManager(resourceHandler);
        }
    }

    @Override
    public void start() {
        if (this.isActive()) {
            this.stop();
        }
        this.port = this.getUsablePort();
        if (this.port != -1) {
            CocosLogger.LOG.info((Object)("start preview service , the port is " + this.port));
            try {
                this.server = new HTTPServer(new HTTPResourceHandler(), this.port);
                this.server.start();
                CocosLogger.LOG.info((Object)"start HTTP Server successful.");
            }
            catch (IOException e) {
                CocosLogger.LOG.error((Object)"start HTTP Server failed.");
                CocosLogger.LOG.error((Object)e.getMessage());
                this.server = null;
            }
        }
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.server.stopServer();
            this.server = null;
        }
    }

    @Override
    public boolean isActive() {
        return this.server != null && this.server.isAlive();
    }

    @Override
    public void service(IRequest request) {
    }
}

