/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.simpleview.service;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.ccdt.simpleview.server.HTTPRequestProcessor;
import org.ccdt.simpleview.service.IService;
import org.ccdt.simpleview.service.request.HTTPRequest;
import org.ccdt.simpleview.service.request.IRequest;
import org.eclipse.core.runtime.Assert;

public class HTTPRequestService
implements IService {
    private int poolSize = 50;
    private ExecutorService processorPool;

    public HTTPRequestService(int poolSize) {
        Assert.isTrue((poolSize > 0 ? 1 : 0) != 0);
        this.poolSize = poolSize;
    }

    @Override
    public void start() {
        this.processorPool = Executors.newFixedThreadPool(this.poolSize);
    }

    @Override
    public void stop() {
        if (this.processorPool != null) {
            this.processorPool.shutdown();
        }
        this.processorPool = null;
    }

    @Override
    public boolean isActive() {
        return this.processorPool != null && !this.processorPool.isTerminated();
    }

    @Override
    public void service(IRequest request) {
        if (!this.isActive()) {
            return;
        }
        if (!(request instanceof HTTPRequest)) {
            return;
        }
        this.processorPool.execute(new HTTPRequestProcessor((HTTPRequest)request));
    }
}

