/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.simpleview.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.simpleview.server.HTTPResourceHandler;
import org.ccdt.simpleview.service.HTTPRequestService;
import org.ccdt.simpleview.service.request.HTTPRequest;
import org.eclipse.core.runtime.Assert;

public class HTTPServer
extends Thread {
    private ServerSocket server;
    private HTTPRequestService requestService;
    private HTTPResourceHandler resourceHandler;
    private static final int POOL_SIZE = 50;

    public HTTPServer(HTTPResourceHandler resourceManager, int port) throws IOException {
        Assert.isNotNull((Object)resourceManager);
        this.resourceHandler = resourceManager;
        this.server = new ServerSocket(port);
    }

    public HTTPResourceHandler getResourceManager() {
        return this.resourceHandler;
    }

    public void setResourceManager(HTTPResourceHandler resourceManager) {
        this.resourceHandler = resourceManager;
    }

    @Override
    public void run() {
        this.requestService = new HTTPRequestService(50);
        this.requestService.start();
        CocosLogger.getLogger(this.getClass()).info((Object)("Accepting connection on port " + this.server.getLocalPort()));
        CocosLogger.getLogger(this.getClass()).info((Object)this.resourceHandler);
        while (true) {
            try {
                while (true) {
                    Socket request = this.server.accept();
                    this.requestService.service(new HTTPRequest(this.resourceHandler, request));
                }
            }
            catch (IOException e) {
                CocosLogger.getLogger(this.getClass()).error((Object)e.getMessage());
                continue;
            }
            break;
        }
    }

    public void stopServer() {
        if (this.requestService != null) {
            this.requestService.stop();
        }
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException iOException) {}
        }
    }
}

