/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.simpleview.server;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.ccdt.common.logger.CocosLogger;

public class HTTPResourceHandler {
    public static final String URL_SPLIT_CHAR = "/";
    private static final String DEFAULT_INDEX = "index.html";
    private Map<String, String> urlMapping;
    private Map<String, File> rootMapping;

    public HTTPResourceHandler(Map<String, String> urlMapping, Map<String, File> rootMapping) {
        if (urlMapping == null) {
            urlMapping = new HashMap<String, String>();
        }
        if (rootMapping == null) {
            rootMapping = new HashMap<String, File>();
        }
        this.rootMapping = rootMapping;
        this.urlMapping = urlMapping;
    }

    public HTTPResourceHandler() {
        this.urlMapping = new HashMap<String, String>();
        this.rootMapping = new HashMap<String, File>();
    }

    public void setHandler(HTTPResourceHandler handler) {
        if (handler != null) {
            this.urlMapping = handler.getUrlMapping();
            this.rootMapping = handler.getRootMapping();
        }
    }

    public String getResource(String url) {
        String filePath;
        if (url == null) {
            return null;
        }
        if (url.startsWith(URL_SPLIT_CHAR)) {
            url = url.substring(URL_SPLIT_CHAR.length());
        }
        if ((filePath = this.urlMapping.get(url)) != null) {
            return filePath;
        }
        if (url.endsWith(URL_SPLIT_CHAR)) {
            url = String.valueOf(url) + DEFAULT_INDEX;
        }
        for (Map.Entry<String, File> entry : this.rootMapping.entrySet()) {
            if (!url.startsWith(entry.getKey())) continue;
            return String.valueOf(entry.getValue().getAbsolutePath()) + URL_SPLIT_CHAR + url.substring(entry.getKey().length());
        }
        return null;
    }

    public void clearRoot() {
        this.rootMapping.clear();
    }

    public void clearURLMapping() {
        this.urlMapping.clear();
    }

    public void addURLMapping(String url, String resourcePath) {
        this.urlMapping.put(url, resourcePath);
    }

    public void addRoot(String key, File root) {
        try {
            if (!root.isDirectory()) {
                throw new IOException(root + " does not exist as a directory ");
            }
            root = root.getCanonicalFile();
        }
        catch (IOException e) {
            CocosLogger.getLogger(this.getClass()).error((Object)e.getMessage());
            return;
        }
        this.rootMapping.put(key, root);
    }

    public Map<String, String> getUrlMapping() {
        return this.urlMapping;
    }

    public void setUrlMapping(Map<String, String> urlMapping) {
        this.urlMapping = urlMapping;
    }

    public Map<String, File> getRootMapping() {
        return this.rootMapping;
    }

    public void setRootMapping(Map<String, File> rootMapping) {
        this.rootMapping = rootMapping;
    }

    public void removeRoot(String key) {
        this.rootMapping.remove(key);
    }

    public String toString() {
        return "HTTPResourceManager [urlMapping=" + this.urlMapping + ", rootMapping=" + this.rootMapping + "]";
    }
}

