/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.simpleview.server;

public enum ContentType {
    HTML("html", "text/html"),
    HTM("htm", "text/html"),
    GIF("gif", "image/gif"),
    CLASS("class", "application/octet-stream"),
    JPG("jpg", "image/jpeg"),
    JPEG("jpeg", "image/jpeg"),
    OTHER("*", "text/plain");

    private String fileSuffix;
    private String contentType;

    private ContentType(String fileSuffix, String contentType) {
        this.fileSuffix = fileSuffix;
        this.contentType = contentType;
    }

    public static ContentType getContentType(String filePath) {
        if (filePath == null) {
            return OTHER;
        }
        ContentType[] contentTypeArray = ContentType.values();
        int n = contentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentType type = contentTypeArray[n2];
            if (filePath.endsWith("." + type.fileSuffix)) {
                return type;
            }
            ++n2;
        }
        return OTHER;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String toString() {
        return this.contentType;
    }
}

