/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.simpleview.matcher;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.minidev.json.JSONArray;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.simpleview.element.Element;
import org.ccdt.simpleview.element.SceneElement;
import org.ccdt.simpleview.manager.MatcherManager;
import org.ccdt.simpleview.matcher.MatchParam;
import org.ccdt.simpleview.matcher.Matcher;
import org.ccdt.simpleview.service.PreviewService;

public class SceneMatcher
implements Matcher {
    private static final String SCENE_MATCH_FILE_SUFFIX = ".json";
    private static final String SCENE_MATCH_REGEX = "$..components";

    @Override
    public Element match(MatchParam param) {
        List components;
        SceneElement result;
        File file;
        block11: {
            if (param == null) {
                return null;
            }
            String filePath = param.getFilePath();
            if (!filePath.endsWith(SCENE_MATCH_FILE_SUFFIX)) {
                return null;
            }
            file = new File(filePath);
            if (!file.isFile()) {
                return null;
            }
            result = null;
            components = (List)JsonPath.read((File)file, (String)SCENE_MATCH_REGEX, (Filter[])new Filter[0]);
            if (!components.isEmpty()) break block11;
            return null;
        }
        try {
            result = new SceneElement(file.getAbsolutePath());
            String root = file.getParent();
            File guessFile = null;
            for (Object component : components) {
                if (!(component instanceof JSONArray)) continue;
                List paths = (List)JsonPath.read(component, (String)"$..fileData[*].path", (Filter[])new Filter[0]);
                for (String path : paths) {
                    guessFile = new File(String.valueOf(root) + File.separator + path);
                    if (!guessFile.isFile()) continue;
                    result.addLoadFile(guessFile.getAbsolutePath());
                }
            }
        }
        catch (IOException e) {
            CocosLogger.getLogger(this.getClass()).error((Object)e.getMessage());
            return null;
        }
        MatcherManager manager = PreviewService.getInstance().getMatcherManager();
        if (manager == null) {
            return result;
        }
        Element subElement = null;
        String[] stringArray = result.getLoadFiles();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String loadFile = stringArray[n2];
            if (!result.getFilePath().equals(loadFile)) {
                subElement = manager.match(new MatchParam(loadFile, param.getRootFilePath()));
                result.addSubElement(subElement);
            }
            ++n2;
        }
        return result;
    }
}

