/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.simpleview.matcher;

import java.io.File;
import java.util.List;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.simpleview.element.Element;
import org.ccdt.simpleview.element.ParticleElement;
import org.ccdt.simpleview.matcher.MatchParam;
import org.ccdt.simpleview.matcher.Matcher;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class ParticleMatcher
implements Matcher {
    private static final String SCENE_MATCH_FILE_SUFFIX = ".plist";
    private static final String XPATH_KEY_TEXTUREFILENAME = "plist/dict/key[text()=\"textureFileName\"]";
    private static final String ELEMENT_KEY_STRING = "string";

    @Override
    public Element match(MatchParam param) {
        if (param == null) {
            return null;
        }
        String filePath = param.getFilePath();
        if (!filePath.endsWith(SCENE_MATCH_FILE_SUFFIX)) {
            return null;
        }
        File file = new File(filePath);
        if (!file.isFile()) {
            return null;
        }
        Document document = null;
        SAXReader reader = new SAXReader();
        reader.setValidation(false);
        reader.setIncludeExternalDTDDeclarations(false);
        reader.setIncludeInternalDTDDeclarations(false);
        try {
            document = reader.read(file.getAbsolutePath());
        }
        catch (DocumentException e) {
            CocosLogger.getLogger(this.getClass()).error((Object)e.getMessage());
        }
        return this.match(document, file);
    }

    private Element match(Document document, File file) {
        if (document == null) {
            return null;
        }
        ParticleElement result = new ParticleElement(file.getAbsolutePath());
        org.dom4j.Element textureFileKey = (org.dom4j.Element)document.selectSingleNode(XPATH_KEY_TEXTUREFILENAME);
        if (textureFileKey == null) {
            return null;
        }
        org.dom4j.Element dictElement = textureFileKey.getParent();
        List childs = dictElement.elements();
        int index = dictElement.indexOf((Node)textureFileKey);
        int textureFileValueIndex = index + 1;
        if (textureFileValueIndex >= childs.size()) {
            return null;
        }
        org.dom4j.Element textureFileValue = (org.dom4j.Element)childs.get(textureFileValueIndex);
        if (!ELEMENT_KEY_STRING.equalsIgnoreCase(textureFileValue.getName())) {
            return null;
        }
        File guessFile = new File(String.valueOf(file.getParent()) + File.separator + textureFileValue.getTextTrim());
        if (guessFile.isFile()) {
            result.addLoadFile(guessFile.getAbsolutePath());
        }
        return result;
    }
}

