/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.simpleview.matcher;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.ccdt.simpleview.element.CCBElement;
import org.ccdt.simpleview.matcher.MatchParam;
import org.ccdt.simpleview.matcher.Matcher;
import org.ccdt.simpleview.util.XMLUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class CCBMatcher
implements Matcher {
    private static final String XPATH_KEY_JSCONTROLLER = "plist/dict/dict/key[text()=\"jsController\"]";
    private static final String XPATH_KEY_SUBCCB = "plist/dict/dict//dict";
    public static final String DEFAULT_CCB_SEARCHPATH = "res/";

    @Override
    public CCBElement match(MatchParam param) {
        if (param == null) {
            return null;
        }
        String filePath = param.getFilePath();
        String ccbFilePath = null;
        String ccbiFilePath = null;
        if (filePath.endsWith(".ccbi")) {
            ccbFilePath = filePath.substring(0, filePath.length() - 1);
            ccbiFilePath = filePath;
        } else if (filePath.endsWith(".ccb")) {
            ccbFilePath = filePath;
            ccbiFilePath = String.valueOf(filePath) + "i";
        }
        File ccbiFile = this.getFile(ccbiFilePath);
        File ccbFile = this.getFile(ccbFilePath);
        if (ccbiFile == null || ccbFile == null) {
            return null;
        }
        Document document = XMLUtil.instance.getDocument(ccbFile);
        return this.match(document, ccbiFilePath, param.getRootFilePath());
    }

    private File getFile(String filePath) {
        if (filePath == null) {
            return null;
        }
        File file = new File(filePath);
        if (!file.isFile()) {
            return null;
        }
        return file;
    }

    private String findJsController(Document document) {
        Element jsControllerKey = (Element)document.selectSingleNode(XPATH_KEY_JSCONTROLLER);
        if (jsControllerKey == null) {
            return null;
        }
        Element dictElement = jsControllerKey.getParent();
        List childs = dictElement.elements();
        int index = dictElement.indexOf((Node)jsControllerKey);
        int jsControlValueIndex = index + 1;
        if (jsControlValueIndex >= childs.size()) {
            return null;
        }
        Element jsControlValue = (Element)childs.get(jsControlValueIndex);
        if (!"string".equalsIgnoreCase(jsControlValue.getName())) {
            return null;
        }
        return jsControlValue.getTextTrim();
    }

    private CCBElement match(Document document, String filePath, String rootFilePath) {
        if (document == null) {
            return null;
        }
        CCBElement result = new CCBElement(filePath);
        result.setResourcePath(DEFAULT_CCB_SEARCHPATH);
        String jsController = this.findJsController(document);
        if (jsController != null) {
            result.setJsControlled(jsController);
        }
        List guessChilds = document.selectNodes(XPATH_KEY_SUBCCB);
        Map<String, String> keyStringMapping = null;
        String subCCBPath = null;
        CCBElement subCCBElement = null;
        for (Element element : guessChilds) {
            keyStringMapping = XMLUtil.instance.getPlistKeyStringMapping(element);
            if (!"CCBFile".equals(keyStringMapping.get("type")) || (subCCBPath = keyStringMapping.get("value")) == null || (subCCBElement = this.match(new MatchParam(subCCBPath = String.valueOf(rootFilePath) + File.separator + DEFAULT_CCB_SEARCHPATH + subCCBPath, rootFilePath))) == null) continue;
            result.addChildren(subCCBElement);
        }
        return result;
    }
}

