/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.simpleview.element;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.ccdt.simpleview.element.Element;
import org.ccdt.simpleview.element.ServerElement;

public class SceneElement
extends ServerElement {
    private List<Element> subElements = new ArrayList<Element>();

    public SceneElement(String filePath) {
        super(filePath);
        this.addLoadFile(filePath);
    }

    public void addSubElement(Element element) {
        if (element != null) {
            this.subElements.add(element);
        }
    }

    @Override
    public boolean needServer() {
        return true;
    }

    @Override
    public String[] getLoadFiles() {
        HashSet<String> loadFiles = new HashSet<String>();
        loadFiles.addAll(this.loadFiles);
        for (Element sub : this.subElements) {
            if (!(sub instanceof ServerElement)) continue;
            loadFiles.addAll(((ServerElement)sub).loadFiles);
        }
        return loadFiles.toArray(new String[loadFiles.size()]);
    }

    @Override
    public boolean canLoad() {
        return !this.loadFiles.isEmpty();
    }

    public String toString() {
        return "SceneElement [filePath=" + this.filePath + ", rootPath=" + this.rootPath + ", loadFiles=" + this.loadFiles + "]";
    }
}

