/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.simpleview.build;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.utils.CharacterUtil;
import org.ccdt.simpleview.build.ElementBuilder;
import org.ccdt.simpleview.element.Element;
import org.ccdt.simpleview.element.LocalElement;
import org.ccdt.simpleview.element.ServerElement;
import org.ccdt.simpleview.server.HTTPResourceHandler;
import org.ccdt.simpleview.template.Template;
import org.ccdt.simpleview.template.TemplateParam;
import org.ccdt.simpleview.view.input.SimpleViewInput;
import org.ccdt.simpleview.view.input.SimpleViewServerInput;

public abstract class ServerElementBuilder
implements ElementBuilder {
    protected abstract Template getTemplate();

    protected abstract TemplateParam[] getTemplateParam(Element var1);

    public String getloadPath(String root, String loadFileAbsolutePath) {
        if (loadFileAbsolutePath == null) {
            return null;
        }
        if ((loadFileAbsolutePath = CharacterUtil.instance.formatFilePath(loadFileAbsolutePath)).startsWith(String.valueOf(root) + "/")) {
            return loadFileAbsolutePath.substring(root.length() + 1);
        }
        return null;
    }

    @Override
    public SimpleViewInput build(Element element) {
        if (element == null) {
            return null;
        }
        if (element instanceof LocalElement) {
            return new SimpleViewInput(element.getFilePath());
        }
        if (element instanceof ServerElement) {
            return this.build((ServerElement)element);
        }
        return null;
    }

    public SimpleViewInput build(ServerElement element) {
        String root = CharacterUtil.instance.formatFilePath(element.getRootPath());
        if (root == null) {
            CocosLogger.getLogger(this.getClass()).error((Object)("root file is not a valid directory:" + root));
            return null;
        }
        File rootFile = new File(root);
        if (!rootFile.isDirectory()) {
            CocosLogger.getLogger(this.getClass()).error((Object)("root file is not a valid directory:" + root));
            return null;
        }
        HTTPResourceHandler handler = new HTTPResourceHandler();
        String rootName = rootFile.getName();
        handler.addRoot(rootName, rootFile);
        handler.addURLMapping(String.valueOf(rootName) + "/" + "cocos2d-html5-v3.0-rc-min.js", String.valueOf(PathManager.instance.getTemplatesPath()) + File.separator + "cocos2d-html5-v3.0-rc-min.js");
        handler.addURLMapping(String.valueOf(rootName) + "/" + "project.json", String.valueOf(PathManager.instance.getTemplatesPath()) + File.separator + "project.json");
        handler.addURLMapping(String.valueOf(rootName) + "/" + "preview", String.valueOf(PathManager.instance.getTemplatesPath()) + File.separator + "index.html");
        Template template = this.getTemplate();
        if (template == null) {
            CocosLogger.getLogger(this.getClass()).error((Object)"template not found");
            return null;
        }
        String indexFilePath = this.getloadPath(root, element.getFilePath());
        if (indexFilePath == null) {
            CocosLogger.getLogger(this.getClass()).error((Object)("is not match root:" + root));
            return null;
        }
        String[] loadFiles = element.getLoadFiles();
        StringBuilder buff = new StringBuilder();
        int i = 0;
        while (i < loadFiles.length) {
            loadFiles[i] = this.getloadPath(root, loadFiles[i]);
            if (loadFiles[i] != null) {
                buff.append('\"').append(loadFiles[i]).append('\"');
                if (i != loadFiles.length - 1) {
                    buff.append(',').append("\r\n");
                }
            } else {
                CocosLogger.getLogger(this.getClass()).error((Object)("unexpect load file path:" + loadFiles[i]));
            }
            ++i;
        }
        TemplateParam loadfilesParam = new TemplateParam("loadfiles", buff.toString());
        TemplateParam rootfileParam = new TemplateParam("rootfile", String.valueOf('\"') + indexFilePath + '\"');
        ArrayList<TemplateParam> params = new ArrayList<TemplateParam>();
        params.add(loadfilesParam);
        params.add(rootfileParam);
        TemplateParam[] appendParam = this.getTemplateParam(element);
        if (appendParam != null) {
            params.addAll(Arrays.asList(appendParam));
        }
        template.output(String.valueOf(PathManager.instance.getTemplatesPath()) + File.separator + "main.js", params.toArray(new TemplateParam[params.size()]));
        handler.addURLMapping(String.valueOf(rootName) + "/" + "main.js", String.valueOf(PathManager.instance.getTemplatesPath()) + File.separator + "main.js");
        return new SimpleViewServerInput(handler, String.valueOf(rootName) + "/" + "preview");
    }
}

