/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.simpleview.build;

import java.io.File;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.common.manager.PathManager;
import org.ccdt.simpleview.build.ServerElementBuilder;
import org.ccdt.simpleview.element.CCBElement;
import org.ccdt.simpleview.element.Element;
import org.ccdt.simpleview.template.FileTemplate;
import org.ccdt.simpleview.template.Template;
import org.ccdt.simpleview.template.TemplateParam;

public class CCBElementBuilder
extends ServerElementBuilder {
    private static final String JSCONTROLLERS_TEMPLATE_KEY = "jsControllers";
    private static final String RESOURCEPATH_TEMPLATE_KEY = "resourcePath";

    @Override
    public boolean adapter(Element element) {
        return element instanceof CCBElement;
    }

    @Override
    protected Template getTemplate() {
        String templatePath = String.valueOf(PathManager.instance.getTemplatesPath()) + File.separator + "template_ccb.js";
        if (!new File(templatePath).isFile()) {
            CocosLogger.getLogger(this.getClass()).error((Object)("that template can not be read:" + templatePath));
            return null;
        }
        return new FileTemplate(templatePath);
    }

    @Override
    protected TemplateParam[] getTemplateParam(Element element) {
        if (element instanceof CCBElement) {
            String[] jsControllers = ((CCBElement)element).getAllJsController();
            StringBuilder jsControllersBuff = new StringBuilder();
            String[] stringArray = jsControllers;
            int n = jsControllers.length;
            int n2 = 0;
            while (n2 < n) {
                String jsController = stringArray[n2];
                jsControllersBuff.append("cc.BuilderReader.registerController(\"").append(jsController).append("\", {});").append("\r\n");
                ++n2;
            }
            TemplateParam resourcePathParam = new TemplateParam(RESOURCEPATH_TEMPLATE_KEY, String.valueOf('\"') + ((CCBElement)element).getResourcePath() + '\"');
            TemplateParam jsControllersParam = new TemplateParam(JSCONTROLLERS_TEMPLATE_KEY, jsControllersBuff.toString());
            return new TemplateParam[]{resourcePathParam, jsControllersParam};
        }
        return null;
    }
}

