/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.ChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerUpdateMonitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.jface.viewers.TreePath;

class ChildrenCountUpdate
extends ViewerUpdateMonitor
implements IChildrenCountUpdate {
    private int fCount = 0;
    private List fBatchedRequests = null;
    private boolean fShouldFilter = false;
    private int[] fFilteredChildren = null;
    private ChildrenUpdate fChildrenUpdate;

    public ChildrenCountUpdate(TreeModelContentProvider provider, Object viewerInput, TreePath elementPath, Object element, IElementContentProvider elementContentProvider) {
        super(provider, viewerInput, elementPath, element, elementContentProvider, provider.getPresentationContext());
        this.fShouldFilter = provider.areTreeModelViewerFiltersApplicable(element);
        this.fFilteredChildren = provider.getFilteredChildren(elementPath);
    }

    public synchronized void cancel() {
        if (this.fChildrenUpdate != null) {
            this.fChildrenUpdate.cancel();
        }
        super.cancel();
    }

    protected synchronized void scheduleViewerUpdate() {
        if (this.fShouldFilter || this.fFilteredChildren != null) {
            if (this.fChildrenUpdate == null) {
                int count;
                int startIdx;
                if (this.fShouldFilter) {
                    startIdx = 0;
                    count = this.getCount();
                } else {
                    startIdx = this.fFilteredChildren[0];
                    int endIdx = this.fFilteredChildren[this.fFilteredChildren.length - 1];
                    count = endIdx - startIdx + 1;
                }
                this.fChildrenUpdate = new ChildrenUpdate(this.getContentProvider(), this.getViewerInput(), this.getElementPath(), this.getElement(), startIdx, count, this.getElementContentProvider()){

                    protected void performUpdate() {
                        this.performUpdate(true);
                        ChildrenCountUpdate.super.scheduleViewerUpdate();
                    }

                    protected void scheduleViewerUpdate() {
                        this.execInDisplayThread(new Runnable(this){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                if (!this.this$1.getContentProvider().isDisposed() && !this.this$1.isCanceled()) {
                                    this.this$1.performUpdate();
                                }
                            }
                        });
                    }
                };
                this.execInDisplayThread(new Runnable(){

                    public void run() {
                        ChildrenCountUpdate.this.fChildrenUpdate.startRequest();
                    }
                });
                return;
            }
        } else {
            super.scheduleViewerUpdate();
        }
    }

    protected void performUpdate() {
        int viewCount = this.fCount;
        TreePath elementPath = this.getElementPath();
        if (viewCount == 0) {
            this.getContentProvider().clearFilters(elementPath);
        } else {
            this.getContentProvider().setModelChildCount(elementPath, this.fCount);
            viewCount = this.getContentProvider().modelToViewChildCount(elementPath, this.fCount);
        }
        if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            DebugUIPlugin.trace("setChildCount(" + this.getElement() + ", modelCount: " + this.fCount + " viewCount: " + viewCount + ")");
        }
        if (this.fShouldFilter && this.getContentProvider().isFiltered(elementPath, 0)) {
            this.getContentProvider().updateElement(elementPath, 0);
        }
        this.getContentProvider().getViewer().setChildCount(elementPath, viewCount);
        this.getContentProvider().getStateTracker().restorePendingStateOnUpdate(this.getElementPath(), -1, true, true, false);
    }

    public void setChildCount(int numChildren) {
        this.fCount = numChildren;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("IChildrenCountUpdate: ");
        buf.append(this.getElement());
        return buf.toString();
    }

    boolean coalesce(ViewerUpdateMonitor request) {
        if (request instanceof ChildrenCountUpdate) {
            if (this.getElementPath().equals((Object)request.getElementPath())) {
                return true;
            }
            if (this.getElementContentProvider().equals(request.getElementContentProvider())) {
                if (this.fBatchedRequests == null) {
                    this.fBatchedRequests = new ArrayList(4);
                    this.fBatchedRequests.add(this);
                }
                this.fBatchedRequests.add(request);
                return true;
            }
        }
        return false;
    }

    void startRequest() {
        if (this.fBatchedRequests == null) {
            this.getElementContentProvider().update(new IChildrenCountUpdate[]{this});
        } else {
            IChildrenCountUpdate[] updates = this.fBatchedRequests.toArray(new IChildrenCountUpdate[this.fBatchedRequests.size()]);
            int i = 1;
            while (i < updates.length) {
                this.getContentProvider().updateStarted((ViewerUpdateMonitor)((Object)updates[i]));
                ++i;
            }
            this.getElementContentProvider().update(updates);
        }
    }

    boolean containsUpdate(TreePath path) {
        if (this.getElementPath().equals((Object)path)) {
            return true;
        }
        if (this.fBatchedRequests != null) {
            int i = 0;
            while (i < this.fBatchedRequests.size()) {
                if (((ViewerUpdateMonitor)this.fBatchedRequests.get(i)).getElementPath().equals((Object)path)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    int getPriority() {
        return 2;
    }

    TreePath getSchedulingPath() {
        TreePath path = this.getElementPath();
        if (path.getSegmentCount() > 0) {
            return path.getParentPath();
        }
        return path;
    }

    int getCount() {
        return this.fCount;
    }

    protected boolean doEquals(ViewerUpdateMonitor update) {
        return update instanceof ChildrenCountUpdate && this.getViewerInput().equals(update.getViewerInput()) && this.getElementPath().equals((Object)update.getElementPath());
    }

    protected int doHashCode() {
        return this.getClass().hashCode() + this.getViewerInput().hashCode() + this.getElementPath().hashCode();
    }
}

