/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.internal.intro.impl.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.ccdt.internal.intro.impl.IntroPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.XMLMemento;

public class ReopenUtil {
    private static final String STATE = "state";
    private static final String REOPEN = "reopen";

    public static boolean isReopenPreferenceInitialized() {
        return ReopenUtil.readMemento() != null;
    }

    public static void setReopenPreference(boolean reopen) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)STATE);
        memento.putBoolean(REOPEN, reopen);
        ReopenUtil.saveMemento(memento);
    }

    public static boolean isReopenPreference() {
        XMLMemento memento = ReopenUtil.readMemento();
        if (memento == null) {
            return false;
        }
        return memento.getBoolean(REOPEN);
    }

    private static XMLMemento readMemento() {
        XMLMemento memento;
        block18: {
            InputStreamReader reader = null;
            try {
                File stateFile = ReopenUtil.getStateFile();
                FileInputStream input = new FileInputStream(stateFile);
                reader = new InputStreamReader((InputStream)input, "utf-8");
                memento = XMLMemento.createReadRoot((Reader)reader);
            }
            catch (FileNotFoundException fileNotFoundException) {
                memento = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    break block18;
                }
                catch (IOException iOException) {}
                break block18;
            }
            catch (Exception exception) {
                try {
                    memento = null;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    break block18;
                }
                catch (IOException iOException) {}
                break block18;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return memento;
    }

    private static void saveMemento(XMLMemento memento) {
        block14: {
            File stateFile = ReopenUtil.getStateFile();
            OutputStreamWriter writer = null;
            try {
                try {
                    FileOutputStream stream = new FileOutputStream(stateFile);
                    writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
                    memento.save((Writer)writer);
                }
                catch (IOException iOException) {
                    stateFile.delete();
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException2) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static File getStateFile() {
        IPath path = IntroPlugin.getDefault().getStateLocation();
        path = path.append("introstate");
        File stateFile = path.toFile();
        return stateFile;
    }
}

