/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.internal.intro.impl.swt;

import org.ccdt.internal.intro.config.IIntroContentProviderSite;
import org.ccdt.internal.intro.impl.IIntroConstants;
import org.ccdt.internal.intro.impl.model.AbstractIntroElement;
import org.ccdt.internal.intro.impl.model.AbstractIntroPage;
import org.ccdt.internal.intro.impl.model.IntroModelRoot;
import org.ccdt.internal.intro.impl.swt.PageStyleManager;
import org.ccdt.internal.intro.impl.swt.PageWidgetFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PageContentForm
implements IIntroConstants {
    private FormToolkit toolkit;
    private IntroModelRoot model;
    private PageStyleManager styleManager;
    private Composite contentComposite;
    private AbstractIntroPage page;
    private IIntroContentProviderSite site;

    public PageContentForm(FormToolkit toolkit, IntroModelRoot modelRoot) {
        this.toolkit = toolkit;
        this.model = modelRoot;
        this.page = this.model.getCurrentPage();
    }

    public PageContentForm(FormToolkit toolkit, IntroModelRoot modelRoot, AbstractIntroPage page) {
        this(toolkit, modelRoot);
        this.page = page;
    }

    public void createPartControl(ScrolledPageBook contentPageBook, PageStyleManager pageStyleManager) {
        this.styleManager = pageStyleManager;
        this.contentComposite = contentPageBook.createPage((Object)this.page.getId());
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 15;
        layout.leftMargin = 15;
        layout.rightMargin = 15;
        layout.bottomMargin = 15;
        layout.verticalSpacing = 15;
        this.contentComposite.setLayout((Layout)layout);
        if (this.styleManager.getPageDescription() != null) {
            Label label = this.toolkit.createLabel(this.contentComposite, this.styleManager.getPageDescription(), 64);
            label.setFont(PageStyleManager.getBannerFont());
            TableWrapData td = new TableWrapData();
            td.align = 128;
            label.setLayoutData((Object)td);
        }
        this.contentComposite.setData("PageSubtitle", (Object)this.styleManager.getPageSubTitle());
        this.createPageChildren(this.page, this.contentComposite);
        this.styleManager = null;
    }

    private void createPageChildren(AbstractIntroPage page, Composite parent) {
        PageWidgetFactory factory = new PageWidgetFactory(this.toolkit, this.styleManager);
        factory.setContentProviderSite(this.site);
        Composite pageComposite = PageContentForm.createPageTableComposite(factory, this.toolkit, this.styleManager, parent);
        AbstractIntroElement[] children = page.getChildren();
        int i = 0;
        while (i < children.length) {
            factory.createIntroElement(pageComposite, children[i]);
            ++i;
        }
    }

    static Composite createPageTableComposite(PageWidgetFactory factory, FormToolkit toolkit, PageStyleManager styleManager, Composite parent) {
        Composite client = toolkit.createComposite(parent);
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        int numColumns = styleManager.getPageNumberOfColumns();
        layout.numColumns = numColumns == 0 ? 1 : numColumns;
        layout.horizontalSpacing = styleManager.getPageHorizantalSpacing();
        layout.verticalSpacing = styleManager.getPageVerticalSpacing();
        client.setLayout((Layout)layout);
        TableWrapData td = new TableWrapData(128, 128);
        td.grabHorizontal = true;
        client.setLayoutData((Object)td);
        return client;
    }

    public void setContentProviderSite(IIntroContentProviderSite site) {
        this.site = site;
    }
}

