/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.internal.intro.impl.parts;

import java.util.Enumeration;
import java.util.Hashtable;
import org.ccdt.internal.intro.config.CustomizableIntroPart;
import org.ccdt.internal.intro.config.IStandbyContentPart;
import org.ccdt.internal.intro.impl.IIntroConstants;
import org.ccdt.internal.intro.impl.IntroPlugin;
import org.ccdt.internal.intro.impl.Messages;
import org.ccdt.internal.intro.impl.model.AbstractIntroPage;
import org.ccdt.internal.intro.impl.model.IntroModelRoot;
import org.ccdt.internal.intro.impl.model.IntroStandbyContentPart;
import org.ccdt.internal.intro.impl.model.loader.ExtensionPointManager;
import org.ccdt.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.ccdt.internal.intro.impl.parts.EmptyStandbyContentPart;
import org.ccdt.internal.intro.impl.util.ImageUtil;
import org.ccdt.internal.intro.impl.util.Log;
import org.ccdt.internal.intro.impl.util.StringUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.intro.IIntroPart;

public class StandbyPart
implements IIntroConstants {
    private FormToolkit toolkit;
    private IntroModelRoot model;
    protected ImageHyperlink returnLink;
    protected Control separator;
    private Composite container;
    protected Composite content;
    private IIntroPart introPart;
    private EmptyStandbyContentPart emptyPart;
    private IMemento memento;
    private Hashtable cachedContentParts = new Hashtable();
    private ControlKey cachedControlKey;

    public StandbyPart(IntroModelRoot model) {
        this.model = model;
    }

    public void init(IIntroPart introPart, IMemento memento) {
        this.introPart = introPart;
        this.memento = memento;
    }

    private IMemento getMemento(IMemento memento, String key) {
        if (memento == null) {
            return null;
        }
        return memento.getChild(key);
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.container = this.toolkit.createComposite(parent);
        this.container.setLayout((Layout)new StandbyLayout());
        ImageUtil.registerImage("back", "full/elcl16/home_nav.gif");
        this.returnLink = this.toolkit.createImageHyperlink(this.container, 0x1000040);
        this.returnLink.setImage(ImageUtil.getImage("back"));
        this.returnLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                StandbyPart.this.doReturn();
            }
        });
        this.separator = this.toolkit.createCompositeSeparator(this.container);
        this.content = this.toolkit.createComposite(this.container);
        StackLayout slayout = new StackLayout();
        slayout.marginHeight = 0;
        slayout.marginWidth = 0;
        this.content.setLayout((Layout)slayout);
        boolean success = false;
        if (this.memento != null && !(success = this.restoreState(this.memento))) {
            this.addAndShowEmptyPart(Messages.StandbyPart_canNotRestore);
        }
        this.updateReturnLinkLabel();
    }

    private void addAndShowEmptyPart(String message) {
        if (this.emptyPart == null) {
            this.emptyPart = new EmptyStandbyContentPart();
        }
        this.addStandbyContentPart("org.eclipse.ui.intro.config.emptyStandby", this.emptyPart);
        this.emptyPart.setMessage(message);
        this.setTopControl("org.eclipse.ui.intro.config.emptyStandby");
    }

    private boolean restoreState(IMemento memento) {
        String contentPartId = memento.getString("contentPartID");
        if (contentPartId == null) {
            return false;
        }
        return this.showContentPart(contentPartId, null);
    }

    public boolean showContentPart(String partId, String input) {
        IntroStandbyContentPart standbyPartContent = ExtensionPointManager.getInst().getSharedConfigExtensionsManager().getStandbyPart(partId);
        if (standbyPartContent != null) {
            String standbyContentClassName = standbyPartContent.getClassName();
            String pluginId = standbyPartContent.getPluginId();
            Object standbyContentObject = ModelLoaderUtil.createClassInstance(pluginId, standbyContentClassName);
            if (standbyContentObject instanceof IStandbyContentPart) {
                IStandbyContentPart contentPart = (IStandbyContentPart)standbyContentObject;
                Control c = this.addStandbyContentPart(partId, contentPart);
                if (c != null) {
                    try {
                        this.setTopControl(partId);
                        this.setInput(input);
                        return true;
                    }
                    catch (Exception e) {
                        Log.error("Failed to set the input: " + input + " on standby part: " + partId, e);
                    }
                }
                String message = NLS.bind((String)Messages.StandbyPart_failedToCreate, (Object)partId);
                this.addAndShowEmptyPart(message);
                return false;
            }
        }
        String message = NLS.bind((String)Messages.StandbyPart_nonDefined, (Object)partId);
        this.addAndShowEmptyPart(message);
        return false;
    }

    public Control addStandbyContentPart(String partId, IStandbyContentPart standbyContent) {
        ControlKey controlKey = this.getCachedContent(partId);
        if (controlKey == null) {
            try {
                standbyContent.init(this.introPart, this.getMemento(this.memento, "standbyContentPart"));
                standbyContent.createPartControl(this.content, this.toolkit);
            }
            catch (Exception e) {
                Log.error("Failed to create part for standby part: " + partId, e);
                return null;
            }
            Control control = standbyContent.getControl();
            controlKey = new ControlKey(control, standbyContent, partId);
            this.cachedContentParts.put(partId, controlKey);
            if (partId.equals("org.eclipse.ui.intro.config.emptyStandby")) {
                this.emptyPart = (EmptyStandbyContentPart)standbyContent;
            }
            if (controlKey.getControl() == null) {
                String message = StringUtil.concat("Standby Content part: ", partId, " has a null Control defined. This prevents the part from being displayed.").toString();
                Log.error(message, null);
                return null;
            }
        }
        return controlKey.getControl();
    }

    public void setInput(Object input) {
        IStandbyContentPart standbyContent = this.cachedControlKey.getContentPart();
        standbyContent.setInput(input);
        this.updateReturnLinkLabel();
        this.container.layout();
    }

    public void setTopControl(String key) {
        this.cachedControlKey = this.getCachedContent(key);
        if (this.cachedControlKey != null) {
            this.setTopControl(this.cachedControlKey.getControl());
        }
    }

    private void setTopControl(Control c) {
        StackLayout layout = (StackLayout)this.content.getLayout();
        layout.topControl = c;
        if (c instanceof Composite) {
            ((Composite)c).layout();
        }
        this.content.layout();
        this.container.layout();
    }

    private void updateReturnLinkLabel() {
        String linkText = Messages.StandbyPart_returnToIntro;
        this.returnLink.setText(linkText);
        AbstractIntroPage page = this.model.getCurrentPage();
        if (page == null) {
            return;
        }
        String toolTip = Messages.StandbyPart_returnTo;
        if (page.getTitle() != null) {
            toolTip = String.valueOf(toolTip) + " " + page.getTitle();
        }
        this.returnLink.setToolTipText(toolTip);
    }

    protected void doReturn() {
        ((CustomizableIntroPart)this.introPart).getControl().setData("showStandbyPart", null);
        IntroPlugin.setIntroStandby(false);
    }

    public void dispose() {
        Enumeration values = this.cachedContentParts.elements();
        while (values.hasMoreElements()) {
            ControlKey controlKey = (ControlKey)values.nextElement();
            controlKey.getContentPart().dispose();
        }
        this.toolkit.dispose();
    }

    public void saveState(IMemento memento) {
        if (this.cachedControlKey != null) {
            String contentPartId = this.cachedControlKey.getContentPartId();
            if (contentPartId == "org.eclipse.ui.intro.config.emptyStandby") {
                return;
            }
            memento.putString("contentPartID", contentPartId);
            IMemento standbyContentPartMemento = memento.createChild("standbyContentPart");
            IStandbyContentPart standbyContentpart = this.cachedControlKey.getContentPart();
            if (standbyContentpart != null) {
                standbyContentpart.saveState(standbyContentPartMemento);
            }
        }
    }

    public void setFocus() {
        this.returnLink.setFocus();
        if (this.cachedControlKey != null) {
            this.cachedControlKey.getContentPart().setFocus();
        }
    }

    private ControlKey getCachedContent(String key) {
        if (this.cachedContentParts.containsKey(key)) {
            return (ControlKey)this.cachedContentParts.get(key);
        }
        return null;
    }

    class ControlKey {
        Control c;
        IStandbyContentPart part;
        String contentPartId;

        ControlKey(Control c, IStandbyContentPart part, String contentPartId) {
            this.c = c;
            this.part = part;
            this.contentPartId = contentPartId;
        }

        public Control getControl() {
            return this.c;
        }

        public IStandbyContentPart getContentPart() {
            return this.part;
        }

        public String getContentPartId() {
            return this.contentPartId;
        }
    }

    class StandbyLayout
    extends Layout {
        private int VGAP = 9;
        private int VMARGIN = 5;
        private int HMARGIN = 5;
        private int SEPARATOR_HEIGHT = 1;

        StandbyLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point lsize = StandbyPart.this.returnLink.computeSize(-1, -1, flushCache);
            Point csize = StandbyPart.this.content.computeSize(-1, -1, flushCache);
            int width = Math.max(lsize.x + 2 * this.HMARGIN, csize.x);
            int height = this.VMARGIN + lsize.y + this.VGAP + this.SEPARATOR_HEIGHT + csize.y;
            return new Point(width, height);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle carea = composite.getClientArea();
            int lwidth = carea.width - this.HMARGIN * 2;
            Point lsize = StandbyPart.this.returnLink.computeSize(lwidth, -1, flushCache);
            int x = this.HMARGIN;
            int y = this.VMARGIN;
            StandbyPart.this.returnLink.setBounds(x, y, lsize.x, lsize.y);
            x = 0;
            StandbyPart.this.separator.setBounds(x, y += lsize.y + this.VGAP, carea.width, this.SEPARATOR_HEIGHT);
            StandbyPart.this.content.setBounds(x, y += this.SEPARATOR_HEIGHT, carea.width, carea.height - this.VMARGIN - lsize.y - this.VGAP - this.SEPARATOR_HEIGHT);
        }
    }
}

